/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.linalg.QuasiTensor;
import breeze.linalg.Tensor;
import breeze.linalg.TensorLike;
import breeze.linalg.support.CanCopy;
import breeze.linalg.support.CanCreateZerosLike;
import breeze.optimize.ApproximateGradientFunction$;
import breeze.optimize.DiffFunction;
import java.io.Serializable;
import scala.;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;

public class ApproximateGradientFunction<K, T>
implements DiffFunction<T> {
    private final Function1<T, Object> f;
    private final double epsilon;
    private final CanCreateZerosLike<T, T> zeros;
    private final .less.colon.less<T, Tensor<K, Object>> view;
    private final CanCopy<T> copy;

    public static double $lessinit$greater$default$2() {
        return ApproximateGradientFunction$.MODULE$.$lessinit$greater$default$2();
    }

    public <K, T> ApproximateGradientFunction(Function1<T, Object> f, double epsilon, CanCreateZerosLike<T, T> zeros, .less.colon.less<T, Tensor<K, Object>> view, CanCopy<T> copy) {
        this.f = f;
        this.epsilon = epsilon;
        this.zeros = zeros;
        this.view = view;
        this.copy = copy;
    }

    @Override
    public double valueAt(T x) {
        return BoxesRunTime.unboxToDouble((Object)this.f.apply(x));
    }

    @Override
    public Tuple2<Object, T> calculate(T x) {
        double fx = BoxesRunTime.unboxToDouble((Object)this.f.apply(x));
        T grad = this.zeros.apply(x);
        T xx = this.copy.apply(x);
        ((QuasiTensor)this.view.apply(x)).iterator().withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object k = tuple2._1();
            double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
            Tensor tensor = (Tensor)this.view.apply(xx);
            tensor.update(k, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(tensor.apply(k)) + this.epsilon)));
            ((TensorLike)this.view.apply(grad)).update(k, BoxesRunTime.boxToDouble((double)((BoxesRunTime.unboxToDouble((Object)this.f.apply(xx)) - fx) / this.epsilon)));
            Tensor tensor2 = (Tensor)this.view.apply(xx);
            tensor2.update(k, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(tensor2.apply(k)) - this.epsilon)));
        });
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)fx), grad);
    }

    public Tuple2<Object, T> calculateAndPrint(T x, T trueGrad) {
        double fx = BoxesRunTime.unboxToDouble((Object)this.f.apply(x));
        T grad = this.zeros.apply(x);
        T xx = this.copy.apply(x);
        ((QuasiTensor)this.view.apply(x)).activeIterator().withFilter((Function1 & Serializable)x$1 -> {
            boolean bl;
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Object k = tuple2._1();
                double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }).foreach((Function1)(JProcedure1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object k = tuple2._1();
            double v = BoxesRunTime.unboxToDouble((Object)tuple2._2());
            Tensor tensor = (Tensor)this.view.apply(xx);
            tensor.update(k, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(tensor.apply(k)) + this.epsilon)));
            ((TensorLike)this.view.apply(grad)).update(k, BoxesRunTime.boxToDouble((double)((BoxesRunTime.unboxToDouble((Object)this.f.apply(xx)) - fx) / this.epsilon)));
            Tensor tensor2 = (Tensor)this.view.apply(xx);
            tensor2.update(k, BoxesRunTime.boxToDouble((double)(BoxesRunTime.unboxToDouble(tensor2.apply(k)) - this.epsilon)));
            Predef$.MODULE$.println((Object)("diff : " + this.epsilon + " val: " + (BoxesRunTime.unboxToDouble(((TensorLike)this.view.apply(grad)).apply(k)) - BoxesRunTime.unboxToDouble(((TensorLike)this.view.apply(trueGrad)).apply(k))) + " dp: " + ((TensorLike)this.view.apply(trueGrad)).apply(k) + " empirical: " + ((TensorLike)this.view.apply(grad)).apply(k)));
        });
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)fx), grad);
    }
}

