/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.linalg.norm$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.math.MutableFiniteCoordinateField;
import breeze.math.NormedModule;
import breeze.optimize.AdaptiveGradientDescent;
import breeze.optimize.AdaptiveGradientDescent$L1Regularization$;
import breeze.optimize.AdaptiveGradientDescent$L2Regularization$;
import breeze.optimize.BatchDiffFunction;
import breeze.optimize.DiffFunction;
import breeze.optimize.DiffFunction$;
import breeze.optimize.FirstOrderException;
import breeze.optimize.FirstOrderMinimizer$;
import breeze.optimize.FirstOrderMinimizer$FunctionValuesConverged$;
import breeze.optimize.FirstOrderMinimizer$MonitorFunctionNotImproving$;
import breeze.optimize.FirstOrderMinimizer$MonitorFunctionValuesCheck$;
import breeze.optimize.FirstOrderMinimizer$MonitorFunctionValuesCheck$Info$;
import breeze.optimize.FirstOrderMinimizer$OptParams$;
import breeze.optimize.FirstOrderMinimizer$SequenceConvergenceCheck$;
import breeze.optimize.FirstOrderMinimizer$State$;
import breeze.optimize.LBFGS;
import breeze.optimize.Minimizer;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import breeze.optimize.StochasticGradientDescent;
import breeze.stats.distributions.RandBasis;
import breeze.stats.distributions.RandBasis$;
import breeze.util.Implicits$;
import breeze.util.LazyLogger;
import breeze.util.SerializableLogging;
import java.io.Serializable;
import java.lang.constant.Constable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.deriving.Mirror;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public abstract class FirstOrderMinimizer<T, DF extends StochasticDiffFunction<T>>
implements Minimizer<T, DF>,
SerializableLogging {
    private volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;
    private final ConvergenceCheck convergenceCheck;
    private final NormedModule<T, Object> space;

    public static <T> ConvergenceCheck<T> defaultConvergenceCheck(int n, double d, boolean bl, int n2, NormedModule<T, Object> normedModule) {
        return FirstOrderMinimizer$.MODULE$.defaultConvergenceCheck(n, d, bl, n2, normedModule);
    }

    public static <T> ConvergenceCheck<T> functionValuesConverged(double d, boolean bl, int n) {
        return FirstOrderMinimizer$.MODULE$.functionValuesConverged(d, bl, n);
    }

    public static <T> ConvergenceCheck<T> gradientConverged(double d, boolean bl, NormedModule<T, Object> normedModule) {
        return FirstOrderMinimizer$.MODULE$.gradientConverged(d, bl, normedModule);
    }

    public static <T> ConvergenceCheck<T> maxIterationsReached(int n) {
        return FirstOrderMinimizer$.MODULE$.maxIterationsReached(n);
    }

    public static <T> ConvergenceCheck<T> monitorFunctionValues(Function1<T, Object> function1, int n, double d, int n2) {
        return FirstOrderMinimizer$.MODULE$.monitorFunctionValues(function1, n, d, n2);
    }

    public static ConvergenceCheck searchFailed() {
        return FirstOrderMinimizer$.MODULE$.searchFailed();
    }

    public static int $lessinit$greater$default$1() {
        return FirstOrderMinimizer$.MODULE$.$lessinit$greater$default$1();
    }

    public static double functionValuesConverged$default$1() {
        return FirstOrderMinimizer$.MODULE$.functionValuesConverged$default$1();
    }

    public static double $lessinit$greater$default$2() {
        return FirstOrderMinimizer$.MODULE$.$lessinit$greater$default$2();
    }

    public static boolean functionValuesConverged$default$2() {
        return FirstOrderMinimizer$.MODULE$.functionValuesConverged$default$2();
    }

    public static boolean gradientConverged$default$2() {
        return FirstOrderMinimizer$.MODULE$.gradientConverged$default$2();
    }

    public static int monitorFunctionValues$default$2() {
        return FirstOrderMinimizer$.MODULE$.monitorFunctionValues$default$2();
    }

    public static int $lessinit$greater$default$3() {
        return FirstOrderMinimizer$.MODULE$.$lessinit$greater$default$3();
    }

    public static boolean defaultConvergenceCheck$default$3() {
        return FirstOrderMinimizer$.MODULE$.defaultConvergenceCheck$default$3();
    }

    public static int functionValuesConverged$default$3() {
        return FirstOrderMinimizer$.MODULE$.functionValuesConverged$default$3();
    }

    public static double monitorFunctionValues$default$3() {
        return FirstOrderMinimizer$.MODULE$.monitorFunctionValues$default$3();
    }

    public static boolean $lessinit$greater$default$4() {
        return FirstOrderMinimizer$.MODULE$.$lessinit$greater$default$4();
    }

    public static int defaultConvergenceCheck$default$4() {
        return FirstOrderMinimizer$.MODULE$.defaultConvergenceCheck$default$4();
    }

    public static int monitorFunctionValues$default$4() {
        return FirstOrderMinimizer$.MODULE$.monitorFunctionValues$default$4();
    }

    public <T, DF extends StochasticDiffFunction<T>> FirstOrderMinimizer(ConvergenceCheck<T> convergenceCheck, NormedModule<T, Object> space) {
        this.convergenceCheck = convergenceCheck;
        this.space = space;
        SerializableLogging.$init$(this);
    }

    @Override
    public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
        return this.breeze$util$SerializableLogging$$_the_logger;
    }

    @Override
    public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
        this.breeze$util$SerializableLogging$$_the_logger = x$1;
    }

    public ConvergenceCheck<T> convergenceCheck() {
        return this.convergenceCheck;
    }

    public <T, DF extends StochasticDiffFunction<T>> FirstOrderMinimizer(int maxIter, double tolerance, int fvalMemory, boolean relativeTolerance, NormedModule<T, Object> space) {
        this(FirstOrderMinimizer$.MODULE$.defaultConvergenceCheck(maxIter, tolerance, relativeTolerance, fvalMemory, space), space);
    }

    public abstract Object initialHistory(DF var1, T var2);

    public DF adjustFunction(DF f) {
        return f;
    }

    public Tuple2<Object, T> adjust(T newX, T newGrad, double newVal) {
        return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)newVal), newGrad);
    }

    public abstract T chooseDescentDirection(State<T, Object, Object> var1, DF var2);

    public abstract double determineStepSize(State<T, Object, Object> var1, DF var2, T var3);

    public abstract T takeStep(State<T, Object, Object> var1, T var2, double var3);

    public abstract Object updateHistory(T var1, T var2, double var3, DF var5, State<T, Object, Object> var6);

    public State<T, Object, Object> initialState(DF f, T init) {
        T x = init;
        Object history = this.initialHistory(f, init);
        Tuple2<Object, T> tuple2 = this.calculateObjective(f, x, history);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        double value = BoxesRunTime.unboxToDouble((Object)tuple2._1());
        Object grad = tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)value), grad);
        double value2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
        Object grad2 = tuple22._2();
        Tuple2<Object, Object> tuple23 = this.adjust(x, grad2, value2);
        if (tuple23 == null) {
            throw new MatchError(tuple23);
        }
        double adjValue = BoxesRunTime.unboxToDouble((Object)tuple23._1());
        Object adjGrad = tuple23._2();
        Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)adjValue), adjGrad);
        double adjValue2 = BoxesRunTime.unboxToDouble((Object)tuple24._1());
        Object adjGrad2 = tuple24._2();
        return FirstOrderMinimizer$State$.MODULE$.apply(x, value2, grad2, adjValue2, adjGrad2, 0, adjValue2, history, this.convergenceCheck().initialInfo(), FirstOrderMinimizer$State$.MODULE$.$lessinit$greater$default$10(), FirstOrderMinimizer$State$.MODULE$.$lessinit$greater$default$11());
    }

    public Tuple2<Object, T> calculateObjective(DF f, T x, Object history) {
        return f.calculate(x);
    }

    public Iterator<State<T, Object, Object>> infiniteIterations(DF f, State<T, Object, Object> state2) {
        BooleanRef failedOnce = BooleanRef.create((boolean)false);
        DF adjustedFun = this.adjustFunction(f);
        return package$.MODULE$.Iterator().iterate(state2, (Function1 & Serializable)state -> this.liftedTree1$5(failedOnce, (StochasticDiffFunction)adjustedFun, (State)state));
    }

    public Iterator<State<T, Object, Object>> iterations(DF f, T init) {
        DF adjustedFun = this.adjustFunction(f);
        return Implicits$.MODULE$.scEnrichIterator((Iterator)this.infiniteIterations(f, this.initialState(adjustedFun, init))).takeUpToWhere((Function1 & Serializable)s -> {
            boolean bl;
            Option<ConvergenceReason> option = this.convergenceCheck().apply((State<T, ?, ?>)s, s.convergenceInfo());
            if (option instanceof Some) {
                ConvergenceReason converged = (ConvergenceReason)((Some)option).value();
                this.logger().info(() -> FirstOrderMinimizer.iterations$$anonfun$2$$anonfun$1(converged));
                s.convergenceReason_$eq((Option<ConvergenceReason>)Some$.MODULE$.apply((Object)converged));
                bl = true;
            } else if (None$.MODULE$.equals(option)) {
                bl = false;
            } else {
                throw new MatchError(option);
            }
            return bl;
        });
    }

    @Override
    public T minimize(DF f, T init) {
        return this.minimizeAndReturnState(f, init).x();
    }

    public State<T, Object, Object> minimizeAndReturnState(DF f, T init) {
        return (State)Implicits$.MODULE$.scEnrichIterator((Iterator)this.iterations(f, init)).last();
    }

    private static final String liftedTree1$1$$anonfun$1(double stepSize$1) {
        return StringOps$.MODULE$.format$extension("Step Size: %.4g", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)stepSize$1)}));
    }

    private final String liftedTree1$2$$anonfun$2(double adjValue$1, Object adjGrad$1, double oneOffImprovement$1) {
        return StringOps$.MODULE$.format$extension("Val and Grad Norm: %.6g (rel: %.3g) %.6g", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)adjValue$1), BoxesRunTime.boxToDouble((double)oneOffImprovement$1), norm$.MODULE$.apply(adjGrad$1, this.space.normImpl())}));
    }

    private static final String liftedTree1$3$$anonfun$3(FirstOrderException x$2) {
        return "Failure! Resetting history: " + x$2;
    }

    private static final String liftedTree1$4$$anonfun$4() {
        return "Failure again! Giving up and returning. Maybe the objective is just poorly behaved?";
    }

    private final State liftedTree1$5(BooleanRef failedOnce$1, StochasticDiffFunction adjustedFun$1, State state$1) {
        State<Object, Object, Object> state;
        try {
            boolean bl;
            T dir = this.chooseDescentDirection(state$1, adjustedFun$1);
            double stepSize = this.determineStepSize(state$1, adjustedFun$1, dir);
            this.logger().info(() -> FirstOrderMinimizer.liftedTree1$1$$anonfun$1(stepSize));
            T x = this.takeStep(state$1, dir, stepSize);
            Tuple2<Object, T> tuple2 = this.calculateObjective(adjustedFun$1, x, state$1.history());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            double value = BoxesRunTime.unboxToDouble((Object)tuple2._1());
            Object grad = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)value), grad);
            double value2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
            Object grad2 = tuple22._2();
            Tuple2<Object, Object> tuple23 = this.adjust(x, grad2, value2);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            double adjValue = BoxesRunTime.unboxToDouble((Object)tuple23._1());
            Object adjGrad = tuple23._2();
            Tuple2 tuple24 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)adjValue), adjGrad);
            double adjValue2 = BoxesRunTime.unboxToDouble((Object)tuple24._1());
            Object adjGrad2 = tuple24._2();
            double oneOffImprovement = (state$1.adjustedValue() - adjValue2) / RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(state$1.adjustedValue()))), RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(adjValue2)))), 1.0E-6 * RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(state$1.initialAdjVal())));
            this.logger().info(() -> this.liftedTree1$2$$anonfun$2(adjValue2, adjGrad2, oneOffImprovement));
            Object history = this.updateHistory(x, grad2, value2, adjustedFun$1, state$1);
            Object newCInfo = this.convergenceCheck().update(x, adjGrad2, adjValue2, state$1, state$1.convergenceInfo());
            failedOnce$1.elem = bl = false;
            state = FirstOrderMinimizer$State$.MODULE$.apply(x, value2, grad2, adjValue2, adjGrad2, state$1.iter() + 1, state$1.initialAdjVal(), history, newCInfo, FirstOrderMinimizer$State$.MODULE$.$lessinit$greater$default$10(), FirstOrderMinimizer$State$.MODULE$.$lessinit$greater$default$11());
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof FirstOrderException) {
                FirstOrderException firstOrderException;
                FirstOrderException x = firstOrderException = (FirstOrderException)throwable2;
                if (!failedOnce$1.elem) {
                    boolean bl;
                    failedOnce$1.elem = bl = true;
                    this.logger().error(() -> FirstOrderMinimizer.liftedTree1$3$$anonfun$3(x));
                    Object object = this.initialHistory(adjustedFun$1, state$1.x());
                    Object t = state$1.copy$default$1();
                    double d = state$1.copy$default$2();
                    Object t2 = state$1.copy$default$3();
                    double d2 = state$1.copy$default$4();
                    Object t3 = state$1.copy$default$5();
                    int n = state$1.copy$default$6();
                    double d3 = state$1.copy$default$7();
                    Object ConvergenceInfo = state$1.copy$default$9();
                    boolean bl2 = state$1.copy$default$10();
                    Option<ConvergenceReason> option = state$1.copy$default$11();
                    state = state$1.copy(t, d, t2, d2, t3, n, d3, object, ConvergenceInfo, bl2, option);
                } else {
                    FirstOrderException x2 = firstOrderException;
                    this.logger().error(FirstOrderMinimizer::liftedTree1$4$$anonfun$4);
                    state = state$1.copy(state$1.copy$default$1(), state$1.copy$default$2(), state$1.copy$default$3(), state$1.copy$default$4(), state$1.copy$default$5(), state$1.copy$default$6(), state$1.copy$default$7(), state$1.copy$default$8(), state$1.copy$default$9(), true, state$1.copy$default$11());
                }
            }
            throw throwable;
        }
        return state;
    }

    private static final String iterations$$anonfun$2$$anonfun$1(ConvergenceReason converged$1) {
        return "Converged because " + converged$1.reason();
    }

    public static interface ConvergenceCheck<T> {
        public Object initialInfo();

        public Option<ConvergenceReason> apply(State<T, ?, ?> var1, Object var2);

        public Object update(T var1, T var2, double var3, State<T, ?, ?> var5, Object var6);

        public static ConvergenceCheck $bar$bar$(ConvergenceCheck $this, ConvergenceCheck otherCheck) {
            return $this.$bar$bar(otherCheck);
        }

        default public ConvergenceCheck<T> $bar$bar(ConvergenceCheck<T> otherCheck) {
            return this.orElse(otherCheck);
        }

        public static ConvergenceCheck orElse$(ConvergenceCheck $this, ConvergenceCheck other) {
            return $this.orElse(other);
        }

        default public ConvergenceCheck<T> orElse(ConvergenceCheck<T> other) {
            return FirstOrderMinimizer$SequenceConvergenceCheck$.MODULE$.apply((IndexedSeq)this.asChecks().$plus$plus(other.asChecks()));
        }

        public static IndexedSeq asChecks$(ConvergenceCheck $this) {
            return $this.asChecks();
        }

        default public IndexedSeq<ConvergenceCheck<T>> asChecks() {
            return (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new ConvergenceCheck[]{this}));
        }
    }

    public static interface ConvergenceReason {
        public String reason();
    }

    public static class FunctionValuesConverged<T>
    implements ConvergenceCheck<T>,
    Product,
    Serializable {
        private final double tolerance;
        private final boolean relative;
        private final int historyLength;

        public static Mirror.Singleton fromProduct(Product product2) {
            return FirstOrderMinimizer$FunctionValuesConverged$.MODULE$.fromProduct(product2);
        }

        public static String reason() {
            return FirstOrderMinimizer$FunctionValuesConverged$.MODULE$.reason();
        }

        public static <T> FunctionValuesConverged<T> unapply(FunctionValuesConverged<T> functionValuesConverged) {
            return FirstOrderMinimizer$FunctionValuesConverged$.MODULE$.unapply(functionValuesConverged);
        }

        public <T> FunctionValuesConverged(double tolerance, boolean relative, int historyLength) {
            this.tolerance = tolerance;
            this.relative = relative;
            this.historyLength = historyLength;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.tolerance()));
            n = Statics.mix((int)n, (int)(this.relative() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.historyLength());
            return Statics.finalizeHash((int)n, (int)3);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof FunctionValuesConverged)) return false;
            FunctionValuesConverged functionValuesConverged = (FunctionValuesConverged)object;
            if (this.tolerance() != functionValuesConverged.tolerance()) return false;
            if (this.relative() != functionValuesConverged.relative()) return false;
            if (this.historyLength() != functionValuesConverged.historyLength()) return false;
            if (!functionValuesConverged.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof FunctionValuesConverged;
        }

        public int productArity() {
            return 3;
        }

        public String productPrefix() {
            return "FunctionValuesConverged";
        }

        public Object productElement(int n) {
            Constable constable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    constable = BoxesRunTime.boxToDouble((double)this._1());
                    break;
                }
                case 1: {
                    constable = BoxesRunTime.boxToBoolean((boolean)this._2());
                    break;
                }
                case 2: {
                    constable = BoxesRunTime.boxToInteger((int)this._3());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return constable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "tolerance";
                    break;
                }
                case 1: {
                    string = "relative";
                    break;
                }
                case 2: {
                    string = "historyLength";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public double tolerance() {
            return this.tolerance;
        }

        public boolean relative() {
            return this.relative;
        }

        public int historyLength() {
            return this.historyLength;
        }

        public IndexedSeq<Object> update(T newX, T newGrad, double newVal, State<T, ?, ?> oldState, IndexedSeq<Object> oldInfo) {
            return (IndexedSeq)((IndexedSeqOps)oldInfo.$colon$plus((Object)BoxesRunTime.boxToDouble((double)newVal))).takeRight(this.historyLength());
        }

        /*
         * Enabled aggressive block sorting
         */
        public Option<ConvergenceReason> apply(State<T, ?, ?> state, IndexedSeq<Object> info) {
            None$ none$;
            if (info.length() >= 2) {
                double d = RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(state.adjustedValue() - BoxesRunTime.unboxToDouble((Object)info.max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$))));
                double d2 = this.tolerance();
                double d3 = this.relative() ? RichDouble$.MODULE$.abs$extension(Predef$.MODULE$.doubleWrapper(state.initialAdjVal())) : 1.0;
                if (d <= d2 * d3) {
                    none$ = Some$.MODULE$.apply((Object)FirstOrderMinimizer$FunctionValuesConverged$.MODULE$);
                    return none$;
                }
            }
            none$ = None$.MODULE$;
            return none$;
        }

        public IndexedSeq initialInfo() {
            return (IndexedSeq)package$.MODULE$.IndexedSeq().apply((Seq)ScalaRunTime$.MODULE$.wrapDoubleArray(new double[]{Double.POSITIVE_INFINITY}));
        }

        public <T> FunctionValuesConverged<T> copy(double tolerance, boolean relative, int historyLength) {
            return new FunctionValuesConverged<T>(tolerance, relative, historyLength);
        }

        public double copy$default$1() {
            return this.tolerance();
        }

        public boolean copy$default$2() {
            return this.relative();
        }

        public int copy$default$3() {
            return this.historyLength();
        }

        public double _1() {
            return this.tolerance();
        }

        public boolean _2() {
            return this.relative();
        }

        public int _3() {
            return this.historyLength();
        }
    }

    public static class MonitorFunctionValuesCheck<T>
    implements ConvergenceCheck<T>,
    SerializableLogging,
    Product {
        private volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;
        private final Function1 f;
        private final int numFailures;
        private final double improvementRequirement;
        private final int evalFrequency;
        public final FirstOrderMinimizer$MonitorFunctionValuesCheck$Info$ Info$lzy1;

        public static MonitorFunctionValuesCheck fromProduct(Product product2) {
            return FirstOrderMinimizer$MonitorFunctionValuesCheck$.MODULE$.fromProduct(product2);
        }

        public static <T> MonitorFunctionValuesCheck<T> unapply(MonitorFunctionValuesCheck<T> monitorFunctionValuesCheck) {
            return FirstOrderMinimizer$MonitorFunctionValuesCheck$.MODULE$.unapply(monitorFunctionValuesCheck);
        }

        public <T> MonitorFunctionValuesCheck(Function1<T, Object> f, int numFailures, double improvementRequirement, int evalFrequency) {
            this.f = f;
            this.numFailures = numFailures;
            this.improvementRequirement = improvementRequirement;
            this.evalFrequency = evalFrequency;
            this.Info$lzy1 = new FirstOrderMinimizer$MonitorFunctionValuesCheck$Info$(this);
            SerializableLogging.$init$(this);
        }

        @Override
        public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
            return this.breeze$util$SerializableLogging$$_the_logger;
        }

        @Override
        public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
            this.breeze$util$SerializableLogging$$_the_logger = x$1;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.f()));
            n = Statics.mix((int)n, (int)this.numFailures());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.improvementRequirement()));
            n = Statics.mix((int)n, (int)this.evalFrequency());
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof MonitorFunctionValuesCheck)) return false;
            MonitorFunctionValuesCheck monitorFunctionValuesCheck = (MonitorFunctionValuesCheck)object;
            if (this.numFailures() != monitorFunctionValuesCheck.numFailures()) return false;
            if (this.improvementRequirement() != monitorFunctionValuesCheck.improvementRequirement()) return false;
            if (this.evalFrequency() != monitorFunctionValuesCheck.evalFrequency()) return false;
            Function1<T, Object> function1 = this.f();
            Function1<T, Object> function12 = monitorFunctionValuesCheck.f();
            if (function1 == null) {
                if (function12 != null) {
                    return false;
                }
            } else if (!function1.equals(function12)) return false;
            if (!monitorFunctionValuesCheck.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof MonitorFunctionValuesCheck;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "MonitorFunctionValuesCheck";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToInteger((int)this._2());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToDouble((double)this._3());
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToInteger((int)this._4());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "f";
                    break;
                }
                case 1: {
                    string = "numFailures";
                    break;
                }
                case 2: {
                    string = "improvementRequirement";
                    break;
                }
                case 3: {
                    string = "evalFrequency";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public Function1<T, Object> f() {
            return this.f;
        }

        public int numFailures() {
            return this.numFailures;
        }

        public double improvementRequirement() {
            return this.improvementRequirement;
        }

        public int evalFrequency() {
            return this.evalFrequency;
        }

        public final FirstOrderMinimizer$MonitorFunctionValuesCheck$Info$ Info() {
            return this.Info$lzy1;
        }

        public Info update(T newX, T newGrad, double newVal, State<T, ?, ?> oldState, Info oldInfo) {
            Info info;
            if (oldState.iter() % this.evalFrequency() == 0) {
                double newValue = BoxesRunTime.unboxToDouble((Object)this.f().apply(newX));
                if (newValue <= oldInfo.bestValue() * (1.0 - this.improvementRequirement())) {
                    this.logger().info(() -> this.update$$anonfun$1(oldInfo, newValue));
                    info = this.Info().apply(newValue, 0);
                } else {
                    this.logger().info(() -> this.update$$anonfun$2(oldInfo, newValue));
                    int n = oldInfo.numFailures() + 1;
                    double d = oldInfo.copy$default$1();
                    info = oldInfo.copy(d, n);
                }
            } else {
                info = oldInfo;
            }
            return info;
        }

        public Option<ConvergenceReason> apply(State<T, ?, ?> state, Info info) {
            return info.numFailures() >= this.numFailures() ? Some$.MODULE$.apply((Object)FirstOrderMinimizer$MonitorFunctionNotImproving$.MODULE$) : None$.MODULE$;
        }

        @Override
        public Info initialInfo() {
            return this.Info().apply(Double.POSITIVE_INFINITY, 0);
        }

        public <T> MonitorFunctionValuesCheck<T> copy(Function1<T, Object> f, int numFailures, double improvementRequirement, int evalFrequency) {
            return new MonitorFunctionValuesCheck<T>(f, numFailures, improvementRequirement, evalFrequency);
        }

        public <T> Function1<T, Object> copy$default$1() {
            return this.f();
        }

        public int copy$default$2() {
            return this.numFailures();
        }

        public double copy$default$3() {
            return this.improvementRequirement();
        }

        public int copy$default$4() {
            return this.evalFrequency();
        }

        public Function1<T, Object> _1() {
            return this.f();
        }

        public int _2() {
            return this.numFailures();
        }

        public double _3() {
            return this.improvementRequirement();
        }

        public int _4() {
            return this.evalFrequency();
        }

        private final String update$$anonfun$1(Info oldInfo$1, double newValue$1) {
            return StringOps$.MODULE$.format$extension("External function improved: current %.3f old: %.3f", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)newValue$1), BoxesRunTime.boxToDouble((double)oldInfo$1.bestValue())}));
        }

        private final String update$$anonfun$2(Info oldInfo$2, double newValue$2) {
            return StringOps$.MODULE$.format$extension("External function failed to improve sufficiently! current %.3f old: %.3f", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)newValue$2), BoxesRunTime.boxToDouble((double)oldInfo$2.bestValue())}));
        }

        public class Info
        implements Product,
        Serializable {
            private final double bestValue;
            private final int numFailures;
            private final MonitorFunctionValuesCheck<T> $outer;

            public Info(MonitorFunctionValuesCheck $outer, double bestValue, int numFailures) {
                this.bestValue = bestValue;
                this.numFailures = numFailures;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public int hashCode() {
                int n = -889275714;
                n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
                n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.bestValue()));
                n = Statics.mix((int)n, (int)this.numFailures());
                return Statics.finalizeHash((int)n, (int)2);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public boolean equals(Object x$0) {
                if (this == x$0) return true;
                Object object = x$0;
                if (!(object instanceof Info)) return false;
                if (((Info)object).breeze$optimize$FirstOrderMinimizer$MonitorFunctionValuesCheck$Info$$$outer() != this.$outer) return false;
                Info info = (Info)object;
                if (this.bestValue() != info.bestValue()) return false;
                if (this.numFailures() != info.numFailures()) return false;
                if (!info.canEqual(this)) return false;
                return true;
            }

            public String toString() {
                return ScalaRunTime$.MODULE$._toString((Product)this);
            }

            public boolean canEqual(Object that) {
                return that instanceof Info;
            }

            public int productArity() {
                return 2;
            }

            public String productPrefix() {
                return "Info";
            }

            public Object productElement(int n) {
                Number number;
                int n2 = n;
                if (0 == n2) {
                    number = BoxesRunTime.boxToDouble((double)this._1());
                } else if (1 == n2) {
                    number = BoxesRunTime.boxToInteger((int)this._2());
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return number;
            }

            public String productElementName(int n) {
                String string;
                int n2 = n;
                if (0 == n2) {
                    string = "bestValue";
                } else if (1 == n2) {
                    string = "numFailures";
                } else {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
                return string;
            }

            public double bestValue() {
                return this.bestValue;
            }

            public int numFailures() {
                return this.numFailures;
            }

            public Info copy(double bestValue, int numFailures) {
                return new Info(this.$outer, bestValue, numFailures);
            }

            public double copy$default$1() {
                return this.bestValue();
            }

            public int copy$default$2() {
                return this.numFailures();
            }

            public double _1() {
                return this.bestValue();
            }

            public int _2() {
                return this.numFailures();
            }

            public final MonitorFunctionValuesCheck<T> breeze$optimize$FirstOrderMinimizer$MonitorFunctionValuesCheck$Info$$$outer() {
                return this.$outer;
            }
        }
    }

    public static class OptParams
    implements Product,
    Serializable {
        private final int batchSize;
        private final double regularization;
        private final double alpha;
        private final int maxIterations;
        private final boolean useL1;
        private final double tolerance;
        private final boolean useStochastic;
        private final int randomSeed;
        private final RandBasis random;

        public static OptParams apply(int n, double d, double d2, int n2, boolean bl, double d3, boolean bl2, int n3) {
            return FirstOrderMinimizer$OptParams$.MODULE$.apply(n, d, d2, n2, bl, d3, bl2, n3);
        }

        public static OptParams fromProduct(Product product2) {
            return FirstOrderMinimizer$OptParams$.MODULE$.fromProduct(product2);
        }

        public static OptParams unapply(OptParams optParams) {
            return FirstOrderMinimizer$OptParams$.MODULE$.unapply(optParams);
        }

        public static int $lessinit$greater$default$1() {
            return FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$1();
        }

        public static double $lessinit$greater$default$2() {
            return FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$2();
        }

        public static double $lessinit$greater$default$3() {
            return FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$3();
        }

        public static int $lessinit$greater$default$4() {
            return FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$4();
        }

        public static boolean $lessinit$greater$default$5() {
            return FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$5();
        }

        public static double $lessinit$greater$default$6() {
            return FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$6();
        }

        public static boolean $lessinit$greater$default$7() {
            return FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$7();
        }

        public static int $lessinit$greater$default$8() {
            return FirstOrderMinimizer$OptParams$.MODULE$.$lessinit$greater$default$8();
        }

        public OptParams(int batchSize, double regularization, double alpha, int maxIterations, boolean useL1, double tolerance, boolean useStochastic, int randomSeed) {
            this.batchSize = batchSize;
            this.regularization = regularization;
            this.alpha = alpha;
            this.maxIterations = maxIterations;
            this.useL1 = useL1;
            this.tolerance = tolerance;
            this.useStochastic = useStochastic;
            this.randomSeed = randomSeed;
            this.random = RandBasis$.MODULE$.withSeed(randomSeed);
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.batchSize());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.regularization()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.alpha()));
            n = Statics.mix((int)n, (int)this.maxIterations());
            n = Statics.mix((int)n, (int)(this.useL1() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.tolerance()));
            n = Statics.mix((int)n, (int)(this.useStochastic() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)this.randomSeed());
            return Statics.finalizeHash((int)n, (int)8);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof OptParams)) return false;
            OptParams optParams = (OptParams)object;
            if (this.batchSize() != optParams.batchSize()) return false;
            if (this.regularization() != optParams.regularization()) return false;
            if (this.alpha() != optParams.alpha()) return false;
            if (this.maxIterations() != optParams.maxIterations()) return false;
            if (this.useL1() != optParams.useL1()) return false;
            if (this.tolerance() != optParams.tolerance()) return false;
            if (this.useStochastic() != optParams.useStochastic()) return false;
            if (this.randomSeed() != optParams.randomSeed()) return false;
            if (!optParams.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof OptParams;
        }

        public int productArity() {
            return 8;
        }

        public String productPrefix() {
            return "OptParams";
        }

        public Object productElement(int n) {
            Constable constable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    constable = BoxesRunTime.boxToInteger((int)this._1());
                    break;
                }
                case 1: {
                    constable = BoxesRunTime.boxToDouble((double)this._2());
                    break;
                }
                case 2: {
                    constable = BoxesRunTime.boxToDouble((double)this._3());
                    break;
                }
                case 3: {
                    constable = BoxesRunTime.boxToInteger((int)this._4());
                    break;
                }
                case 4: {
                    constable = BoxesRunTime.boxToBoolean((boolean)this._5());
                    break;
                }
                case 5: {
                    constable = BoxesRunTime.boxToDouble((double)this._6());
                    break;
                }
                case 6: {
                    constable = BoxesRunTime.boxToBoolean((boolean)this._7());
                    break;
                }
                case 7: {
                    constable = BoxesRunTime.boxToInteger((int)this._8());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return constable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "batchSize";
                    break;
                }
                case 1: {
                    string = "regularization";
                    break;
                }
                case 2: {
                    string = "alpha";
                    break;
                }
                case 3: {
                    string = "maxIterations";
                    break;
                }
                case 4: {
                    string = "useL1";
                    break;
                }
                case 5: {
                    string = "tolerance";
                    break;
                }
                case 6: {
                    string = "useStochastic";
                    break;
                }
                case 7: {
                    string = "randomSeed";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public int batchSize() {
            return this.batchSize;
        }

        public double regularization() {
            return this.regularization;
        }

        public double alpha() {
            return this.alpha;
        }

        public int maxIterations() {
            return this.maxIterations;
        }

        public boolean useL1() {
            return this.useL1;
        }

        public double tolerance() {
            return this.tolerance;
        }

        public boolean useStochastic() {
            return this.useStochastic;
        }

        public int randomSeed() {
            return this.randomSeed;
        }

        public <T> T minimize(BatchDiffFunction<T> f, T init, MutableFiniteCoordinateField<T, ?, Object> space) {
            return ((State)Implicits$.MODULE$.scEnrichIterator((Iterator)this.iterations(f, init, space)).last()).x();
        }

        public <T> T minimize(DiffFunction<T> f, T init, MutableEnumeratedCoordinateField<T, ?, Object> space) {
            return ((State)Implicits$.MODULE$.scEnrichIterator((Iterator)this.iterations(f, init, space)).last()).x();
        }

        public <T> Iterator<State> iterations(BatchDiffFunction<T> f, T init, MutableFiniteCoordinateField<T, ?, Object> space) {
            Iterator<State> it = this.useStochastic() ? this.iterations(f.withRandomBatches(this.batchSize()), init, space) : this.iterations((DiffFunction<T>)f, init, (MutableEnumeratedCoordinateField)space);
            return it;
        }

        public <T> Iterator<State<T, ?, ?>> iterations(StochasticDiffFunction<T> f, T init, MutableFiniteCoordinateField<T, ?, Object> space) {
            StochasticGradientDescent r = this.useL1() ? new AdaptiveGradientDescent.L1Regularization<T>(this.regularization(), AdaptiveGradientDescent$L1Regularization$.MODULE$.$lessinit$greater$default$2(), this.alpha(), this.maxIterations(), space, this.random) : new AdaptiveGradientDescent.L2Regularization<T>(this.regularization(), this.alpha(), this.maxIterations(), AdaptiveGradientDescent$L2Regularization$.MODULE$.$lessinit$greater$default$4(), AdaptiveGradientDescent$L2Regularization$.MODULE$.$lessinit$greater$default$5(), space, this.random);
            return r.iterations(f, init);
        }

        public <T, K> Iterator<State> iterations(DiffFunction<T> f, T init, MutableEnumeratedCoordinateField<T, K, Object> space) {
            return this.useL1() ? new OWLQN<K, T>(this.maxIterations(), 5, this.regularization(), this.tolerance(), space).iterations(f, init) : new LBFGS<T>(this.maxIterations(), 5, this.tolerance(), space).iterations(DiffFunction$.MODULE$.withL2Regularization(f, this.regularization(), space), init);
        }

        public OptParams copy(int batchSize, double regularization, double alpha, int maxIterations, boolean useL1, double tolerance, boolean useStochastic, int randomSeed) {
            return new OptParams(batchSize, regularization, alpha, maxIterations, useL1, tolerance, useStochastic, randomSeed);
        }

        public int copy$default$1() {
            return this.batchSize();
        }

        public double copy$default$2() {
            return this.regularization();
        }

        public double copy$default$3() {
            return this.alpha();
        }

        public int copy$default$4() {
            return this.maxIterations();
        }

        public boolean copy$default$5() {
            return this.useL1();
        }

        public double copy$default$6() {
            return this.tolerance();
        }

        public boolean copy$default$7() {
            return this.useStochastic();
        }

        public int copy$default$8() {
            return this.randomSeed();
        }

        public int _1() {
            return this.batchSize();
        }

        public double _2() {
            return this.regularization();
        }

        public double _3() {
            return this.alpha();
        }

        public int _4() {
            return this.maxIterations();
        }

        public boolean _5() {
            return this.useL1();
        }

        public double _6() {
            return this.tolerance();
        }

        public boolean _7() {
            return this.useStochastic();
        }

        public int _8() {
            return this.randomSeed();
        }
    }

    public static class SequenceConvergenceCheck<T>
    implements ConvergenceCheck<T>,
    Product,
    Serializable {
        private final IndexedSeq checks;

        public static SequenceConvergenceCheck fromProduct(Product product2) {
            return FirstOrderMinimizer$SequenceConvergenceCheck$.MODULE$.fromProduct(product2);
        }

        public static <T> SequenceConvergenceCheck<T> unapply(SequenceConvergenceCheck<T> sequenceConvergenceCheck) {
            return FirstOrderMinimizer$SequenceConvergenceCheck$.MODULE$.unapply(sequenceConvergenceCheck);
        }

        public <T> SequenceConvergenceCheck(IndexedSeq<ConvergenceCheck<T>> checks) {
            this.checks = checks;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof SequenceConvergenceCheck)) return false;
            SequenceConvergenceCheck sequenceConvergenceCheck = (SequenceConvergenceCheck)object;
            IndexedSeq<ConvergenceCheck<T>> indexedSeq = this.checks();
            IndexedSeq<ConvergenceCheck<T>> indexedSeq2 = sequenceConvergenceCheck.checks();
            if (indexedSeq == null) {
                if (indexedSeq2 != null) {
                    return false;
                }
            } else if (!indexedSeq.equals(indexedSeq2)) return false;
            if (!sequenceConvergenceCheck.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof SequenceConvergenceCheck;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "SequenceConvergenceCheck";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "checks";
        }

        public IndexedSeq<ConvergenceCheck<T>> checks() {
            return this.checks;
        }

        public IndexedSeq<Object> initialInfo() {
            return (IndexedSeq)this.checks().map((Function1 & Serializable)_$1 -> _$1.initialInfo());
        }

        public IndexedSeq<Object> update(T newX, T newGrad, double newVal, State<T, ?, ?> oldState, IndexedSeq<Object> oldInfo) {
            if (oldInfo.length() != this.checks().length()) {
                throw new IllegalArgumentException(StringOps$.MODULE$.format$extension("requirement failed: %s", (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{"oldInfo.length.==(SequenceConvergenceCheck.this.checks.length)"})));
            }
            ArrayBuffer out = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
            int i = 0;
            int yy = this.checks().length();
            while (i < this.checks().length()) {
                int n = i++;
                ConvergenceCheck c = (ConvergenceCheck)this.checks().apply(n);
                Object i2 = oldInfo.apply(n);
                out.$plus$eq(c.update(newX, newGrad, newVal, oldState, i2));
            }
            return out.toIndexedSeq();
        }

        public Option<ConvergenceReason> apply(State<T, ?, ?> state, IndexedSeq<Object> info) {
            return ((IndexedSeqOps)this.checks().zip(info)).iterator().flatMap((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                ConvergenceCheck c = (ConvergenceCheck)tuple2._1();
                Object i = tuple2._2();
                return c.apply(state, i);
            }).toStream().headOption();
        }

        public <T> SequenceConvergenceCheck<T> copy(IndexedSeq<ConvergenceCheck<T>> checks) {
            return new SequenceConvergenceCheck<T>(checks);
        }

        public <T> IndexedSeq<ConvergenceCheck<T>> copy$default$1() {
            return this.checks();
        }

        public IndexedSeq<ConvergenceCheck<T>> _1() {
            return this.checks();
        }
    }

    public static class State<T, ConvergenceInfo, History>
    implements Product,
    Serializable {
        private final Object x;
        private final double value;
        private final Object grad;
        private final double adjustedValue;
        private final Object adjustedGradient;
        private final int iter;
        private final double initialAdjVal;
        private final Object history;
        private final Object convergenceInfo;
        private final boolean searchFailed;
        private Option convergenceReason;

        public static <T, ConvergenceInfo, History> State<T, ConvergenceInfo, History> apply(T t, double d, T t2, double d2, T t3, int n, double d3, History History2, ConvergenceInfo ConvergenceInfo, boolean bl, Option<ConvergenceReason> option) {
            return FirstOrderMinimizer$State$.MODULE$.apply(t, d, t2, d2, t3, n, d3, History2, ConvergenceInfo, bl, option);
        }

        public static State fromProduct(Product product2) {
            return FirstOrderMinimizer$State$.MODULE$.fromProduct(product2);
        }

        public static <T, ConvergenceInfo, History> State<T, ConvergenceInfo, History> unapply(State<T, ConvergenceInfo, History> state) {
            return FirstOrderMinimizer$State$.MODULE$.unapply(state);
        }

        public static boolean $lessinit$greater$default$10() {
            return FirstOrderMinimizer$State$.MODULE$.$lessinit$greater$default$10();
        }

        public static Option $lessinit$greater$default$11() {
            return FirstOrderMinimizer$State$.MODULE$.$lessinit$greater$default$11();
        }

        public <T, ConvergenceInfo, History> State(T x, double value, T grad, double adjustedValue, T adjustedGradient, int iter, double initialAdjVal, History history, ConvergenceInfo convergenceInfo, boolean searchFailed, Option<ConvergenceReason> convergenceReason) {
            this.x = x;
            this.value = value;
            this.grad = grad;
            this.adjustedValue = adjustedValue;
            this.adjustedGradient = adjustedGradient;
            this.iter = iter;
            this.initialAdjVal = initialAdjVal;
            this.history = history;
            this.convergenceInfo = convergenceInfo;
            this.searchFailed = searchFailed;
            this.convergenceReason = convergenceReason;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.x()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.value()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.grad()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.adjustedValue()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.adjustedGradient()));
            n = Statics.mix((int)n, (int)this.iter());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.initialAdjVal()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.history()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.convergenceInfo()));
            n = Statics.mix((int)n, (int)(this.searchFailed() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.convergenceReason()));
            return Statics.finalizeHash((int)n, (int)11);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            State state = (State)object;
            if (this.value() != state.value()) return false;
            if (this.adjustedValue() != state.adjustedValue()) return false;
            if (this.iter() != state.iter()) return false;
            if (this.initialAdjVal() != state.initialAdjVal()) return false;
            if (this.searchFailed() != state.searchFailed()) return false;
            if (!BoxesRunTime.equals(this.x(), state.x())) return false;
            if (!BoxesRunTime.equals(this.grad(), state.grad())) return false;
            if (!BoxesRunTime.equals(this.adjustedGradient(), state.adjustedGradient())) return false;
            if (!BoxesRunTime.equals(this.history(), state.history())) return false;
            if (!BoxesRunTime.equals(this.convergenceInfo(), state.convergenceInfo())) return false;
            Option<ConvergenceReason> option = this.convergenceReason();
            Option<ConvergenceReason> option2 = state.convergenceReason();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 11;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToDouble((double)this._2());
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToDouble((double)this._4());
                    break;
                }
                case 4: {
                    object = this._5();
                    break;
                }
                case 5: {
                    object = BoxesRunTime.boxToInteger((int)this._6());
                    break;
                }
                case 6: {
                    object = BoxesRunTime.boxToDouble((double)this._7());
                    break;
                }
                case 7: {
                    object = this._8();
                    break;
                }
                case 8: {
                    object = this._9();
                    break;
                }
                case 9: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._10());
                    break;
                }
                case 10: {
                    object = this._11();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "x";
                    break;
                }
                case 1: {
                    string = "value";
                    break;
                }
                case 2: {
                    string = "grad";
                    break;
                }
                case 3: {
                    string = "adjustedValue";
                    break;
                }
                case 4: {
                    string = "adjustedGradient";
                    break;
                }
                case 5: {
                    string = "iter";
                    break;
                }
                case 6: {
                    string = "initialAdjVal";
                    break;
                }
                case 7: {
                    string = "history";
                    break;
                }
                case 8: {
                    string = "convergenceInfo";
                    break;
                }
                case 9: {
                    string = "searchFailed";
                    break;
                }
                case 10: {
                    string = "convergenceReason";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public T x() {
            return (T)this.x;
        }

        public double value() {
            return this.value;
        }

        public T grad() {
            return (T)this.grad;
        }

        public double adjustedValue() {
            return this.adjustedValue;
        }

        public T adjustedGradient() {
            return (T)this.adjustedGradient;
        }

        public int iter() {
            return this.iter;
        }

        public double initialAdjVal() {
            return this.initialAdjVal;
        }

        public History history() {
            return (History)this.history;
        }

        public ConvergenceInfo convergenceInfo() {
            return (ConvergenceInfo)this.convergenceInfo;
        }

        public boolean searchFailed() {
            return this.searchFailed;
        }

        public Option<ConvergenceReason> convergenceReason() {
            return this.convergenceReason;
        }

        public void convergenceReason_$eq(Option<ConvergenceReason> x$1) {
            this.convergenceReason = x$1;
        }

        public <T, ConvergenceInfo, History> State<T, ConvergenceInfo, History> copy(T x, double value, T grad, double adjustedValue, T adjustedGradient, int iter, double initialAdjVal, History history, ConvergenceInfo convergenceInfo, boolean searchFailed, Option<ConvergenceReason> convergenceReason) {
            return new State<T, ConvergenceInfo, History>(x, value, grad, adjustedValue, adjustedGradient, iter, initialAdjVal, history, convergenceInfo, searchFailed, convergenceReason);
        }

        public <T, ConvergenceInfo, History> T copy$default$1() {
            return this.x();
        }

        public double copy$default$2() {
            return this.value();
        }

        public <T, ConvergenceInfo, History> T copy$default$3() {
            return this.grad();
        }

        public double copy$default$4() {
            return this.adjustedValue();
        }

        public <T, ConvergenceInfo, History> T copy$default$5() {
            return this.adjustedGradient();
        }

        public int copy$default$6() {
            return this.iter();
        }

        public double copy$default$7() {
            return this.initialAdjVal();
        }

        public <T, ConvergenceInfo, History> History copy$default$8() {
            return this.history();
        }

        public <T, ConvergenceInfo, History> ConvergenceInfo copy$default$9() {
            return this.convergenceInfo();
        }

        public boolean copy$default$10() {
            return this.searchFailed();
        }

        public <T, ConvergenceInfo, History> Option<ConvergenceReason> copy$default$11() {
            return this.convergenceReason();
        }

        public T _1() {
            return this.x();
        }

        public double _2() {
            return this.value();
        }

        public T _3() {
            return this.grad();
        }

        public double _4() {
            return this.adjustedValue();
        }

        public T _5() {
            return this.adjustedGradient();
        }

        public int _6() {
            return this.iter();
        }

        public double _7() {
            return this.initialAdjVal();
        }

        public History _8() {
            return this.history();
        }

        public ConvergenceInfo _9() {
            return this.convergenceInfo();
        }

        public boolean _10() {
            return this.searchFailed();
        }

        public Option<ConvergenceReason> _11() {
            return this.convergenceReason();
        }
    }
}

