/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize;

import breeze.generic.UFunc;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.norm$;
import breeze.linalg.operators.OpMulMatrix$;
import breeze.math.MutableVectorField;
import breeze.optimize.DiffFunction;
import breeze.optimize.Minimizer;
import breeze.optimize.NaNHistory;
import breeze.optimize.SecondOrderFunction;
import breeze.optimize.TruncatedNewtonMinimizer$;
import breeze.optimize.TruncatedNewtonMinimizer$History$;
import breeze.optimize.TruncatedNewtonMinimizer$State$;
import breeze.optimize.linear.ConjugateGradient;
import breeze.util.Implicits$;
import breeze.util.LazyLogger;
import breeze.util.SerializableLogging;
import java.io.Serializable;
import scala.Conversion;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.IndexedSeqOps;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Seq;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class TruncatedNewtonMinimizer<T, H>
implements Minimizer<T, SecondOrderFunction<T, H>>,
SerializableLogging {
    private volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;
    public final int breeze$optimize$TruncatedNewtonMinimizer$$maxIterations;
    public final double breeze$optimize$TruncatedNewtonMinimizer$$tolerance;
    private final double l2Regularization;
    private final int m;
    public final MutableVectorField<T, Object> breeze$optimize$TruncatedNewtonMinimizer$$space;
    private final UFunc.UImpl2<OpMulMatrix$, H, T, T> mult;
    public final TruncatedNewtonMinimizer$State$ State$lzy1;
    private final double eta0;
    private final double eta1;
    private final double eta2;
    private final double sigma1;
    private final double sigma2;
    private final double sigma3;
    public final TruncatedNewtonMinimizer$History$ History$lzy1;

    public static int $lessinit$greater$default$1() {
        return TruncatedNewtonMinimizer$.MODULE$.$lessinit$greater$default$1();
    }

    public static double $lessinit$greater$default$2() {
        return TruncatedNewtonMinimizer$.MODULE$.$lessinit$greater$default$2();
    }

    public static double $lessinit$greater$default$3() {
        return TruncatedNewtonMinimizer$.MODULE$.$lessinit$greater$default$3();
    }

    public static int $lessinit$greater$default$4() {
        return TruncatedNewtonMinimizer$.MODULE$.$lessinit$greater$default$4();
    }

    public <T, H> TruncatedNewtonMinimizer(int maxIterations, double tolerance, double l2Regularization, int m, MutableVectorField<T, Object> space, UFunc.UImpl2<OpMulMatrix$, H, T, T> mult) {
        this.breeze$optimize$TruncatedNewtonMinimizer$$maxIterations = maxIterations;
        this.breeze$optimize$TruncatedNewtonMinimizer$$tolerance = tolerance;
        this.l2Regularization = l2Regularization;
        this.m = m;
        this.breeze$optimize$TruncatedNewtonMinimizer$$space = space;
        this.mult = mult;
        this.State$lzy1 = new TruncatedNewtonMinimizer$State$(this);
        this.History$lzy1 = new TruncatedNewtonMinimizer$History$(this);
        SerializableLogging.$init$(this);
        this.eta0 = 1.0E-4;
        this.eta1 = 0.25;
        this.eta2 = 0.75;
        this.sigma1 = 0.25;
        this.sigma2 = 0.5;
        this.sigma3 = 4.0;
    }

    @Override
    public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
        return this.breeze$util$SerializableLogging$$_the_logger;
    }

    @Override
    public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
        this.breeze$util$SerializableLogging$$_the_logger = x$1;
    }

    @Override
    public T minimize(SecondOrderFunction<T, H> f, T initial) {
        return ((State)Implicits$.MODULE$.scEnrichIterator(Implicits$.MODULE$.scEnrichIterator((Iterator)this.iterations(f, initial)).takeUpToWhere((Function1 & Serializable)_$1 -> _$1.converged())).last()).x();
    }

    public final TruncatedNewtonMinimizer$State$ State() {
        return this.State$lzy1;
    }

    private State initialState(SecondOrderFunction<T, H> f, T initial) {
        Tuple3<Object, T, H> tuple3 = f.calculate2(initial);
        if (tuple3 == null) {
            throw new MatchError(tuple3);
        }
        double v = BoxesRunTime.unboxToDouble((Object)tuple3._1());
        Object grad = tuple3._2();
        Object h = tuple3._3();
        Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)v), grad, h);
        double v2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
        Object grad2 = tuple32._2();
        Object h2 = tuple32._3();
        Object adjgrad = ((NumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(grad2)).$plus(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(initial)).$times(BoxesRunTime.boxToDouble((double)this.l2Regularization), this.breeze$optimize$TruncatedNewtonMinimizer$$space.mulVS_M()), this.breeze$optimize$TruncatedNewtonMinimizer$$space.addVV());
        double initDelta = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(adjgrad, this.breeze$optimize$TruncatedNewtonMinimizer$$space.normImpl()));
        double adjfval = v2 + 0.5 * this.l2Regularization * BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(initial)).dot(initial, this.breeze$optimize$TruncatedNewtonMinimizer$$space.dotVV()));
        boolean f_too_small = adjfval < -1.0E32;
        return this.State().apply(0, initDelta, initDelta, initial, v2, grad2, h2, adjfval, adjgrad, f_too_small, true, this.initialHistory(f, initial));
    }

    public Iterator<State> iterations(SecondOrderFunction<T, H> f, T initial) {
        return scala.package$.MODULE$.Iterator().iterate((Object)this.initialState(f, initial), (Function1 & Serializable)state -> {
            State state2;
            double alpha;
            double d = 0.1 * BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(state.adjGrad(), this.breeze$optimize$TruncatedNewtonMinimizer$$space.normImpl()));
            ConjugateGradient cg = new ConjugateGradient(state.delta(), 400, this.l2Regularization, d, this.breeze$optimize$TruncatedNewtonMinimizer$$space, this.mult);
            T initStep = this.chooseDescentDirection((State)state);
            Tuple2<T, T> tuple2 = cg.minimizeAndReturnResidual(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(state.adjGrad())).unary_$minus(this.breeze$optimize$TruncatedNewtonMinimizer$$space.neg()), state.h(), initStep);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Object step = tuple2._1();
            Object residual = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply(step, residual);
            Object step2 = tuple22._1();
            Object residual2 = tuple22._2();
            Object x_new = ((NumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(state.x())).$plus(step2, this.breeze$optimize$TruncatedNewtonMinimizer$$space.addVV());
            double gs = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(state.adjGrad())).dot(step2, this.breeze$optimize$TruncatedNewtonMinimizer$$space.dotVV()));
            double predictedReduction = -0.5 * (gs - BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(step2)).dot(residual2, this.breeze$optimize$TruncatedNewtonMinimizer$$space.dotVV())));
            Tuple3 tuple3 = f.calculate2(x_new);
            if (tuple3 == null) {
                throw new MatchError(tuple3);
            }
            double newv = BoxesRunTime.unboxToDouble((Object)tuple3._1());
            Object newg = tuple3._2();
            Object newh = tuple3._3();
            Tuple3 tuple32 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)newv), newg, newh);
            double newv2 = BoxesRunTime.unboxToDouble((Object)tuple32._1());
            Object newg2 = tuple32._2();
            Object newh2 = tuple32._3();
            Object adjNewG = ((NumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(newg2)).$plus(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(x_new)).$times(BoxesRunTime.boxToDouble((double)this.l2Regularization), this.breeze$optimize$TruncatedNewtonMinimizer$$space.mulVS_M()), this.breeze$optimize$TruncatedNewtonMinimizer$$space.addVV());
            double adjNewV = newv2 + 0.5 * this.l2Regularization * BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(x_new)).dot(x_new, this.breeze$optimize$TruncatedNewtonMinimizer$$space.dotVV()));
            double actualReduction = state.adjFval() - adjNewV;
            double stepNorm = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(step2, this.breeze$optimize$TruncatedNewtonMinimizer$$space.normImpl()));
            double newDelta = state.iter() == 1 ? RichDouble$.MODULE$.min$extension(Predef$.MODULE$.doubleWrapper(state.delta()), stepNorm * (double)3) : state.delta();
            double d2 = alpha = -actualReduction <= gs ? this.sigma3 : RichDouble$.MODULE$.max$extension(Predef$.MODULE$.doubleWrapper(this.sigma1), -0.5 * (gs / (-actualReduction - gs)));
            double d3 = actualReduction < this.eta0 * predictedReduction ? package$.MODULE$.min(package$.MODULE$.max(alpha, this.sigma1) * stepNorm, this.sigma2 * newDelta) : (actualReduction < this.eta1 * predictedReduction ? package$.MODULE$.max(this.sigma1 * newDelta, package$.MODULE$.min(alpha * stepNorm, this.sigma2 * newDelta)) : (newDelta = actualReduction < this.eta2 * predictedReduction ? package$.MODULE$.max(this.sigma1 * newDelta, package$.MODULE$.min(alpha * stepNorm, this.sigma3 * newDelta)) : package$.MODULE$.max(newDelta, package$.MODULE$.min((double)10 * stepNorm, this.sigma3 * newDelta))));
            if (actualReduction > this.eta0 * predictedReduction) {
                this.logger().info(() -> this.iterations$$anonfun$2$$anonfun$1(state, residual2, predictedReduction, adjNewG, adjNewV, actualReduction));
                boolean stop_cond = adjNewV < -1.0E32 || package$.MODULE$.abs(actualReduction) <= package$.MODULE$.abs(adjNewV) * 1.0E-12 && package$.MODULE$.abs(predictedReduction) <= package$.MODULE$.abs(adjNewV) * 1.0E-12;
                History newHistory = this.updateHistory((T)x_new, (T)adjNewG, adjNewV, (State)state);
                int this_iter = state.accept() ? state.iter() + 1 : state.iter();
                state2 = this.State().apply(this_iter, state.initialGNorm(), newDelta, x_new, newv2, newg2, newh2, adjNewV, adjNewG, stop_cond, true, newHistory);
            } else {
                int this_iter = state.accept() ? state.iter() + 1 : state.iter();
                boolean stop_cond = state.adjFval() < -1.0E32 || package$.MODULE$.abs(actualReduction) <= package$.MODULE$.abs(state.adjFval()) * 1.0E-12 && package$.MODULE$.abs(predictedReduction) <= package$.MODULE$.abs(state.adjFval()) * 1.0E-12;
                this.logger().info(() -> this.iterations$$anonfun$3$$anonfun$2(state, residual2, predictedReduction, actualReduction));
                double d4 = newDelta;
                double d5 = state.copy$default$2();
                Object object = state.copy$default$4();
                double d6 = state.copy$default$5();
                Object object2 = state.copy$default$6();
                Object object3 = state.copy$default$7();
                double d7 = state.copy$default$8();
                Object object4 = state.copy$default$9();
                History history = state.copy$default$12();
                state2 = state.copy(this_iter, d5, d4, object, d6, object2, object3, d7, object4, stop_cond, false, history);
            }
            return state2;
        });
    }

    public final TruncatedNewtonMinimizer$History$ History() {
        return this.History$lzy1;
    }

    public History initialHistory(DiffFunction<T> f, T x) {
        return new History(this, this.History().$lessinit$greater$default$1(), this.History().$lessinit$greater$default$2());
    }

    public T chooseDescentDirection(State state) {
        Object grad = state.adjGrad();
        IndexedSeq memStep = state.history().memStep();
        IndexedSeq memGradDelta = state.history().memGradDelta();
        double diag2 = memStep.size() > 0 ? this.computeDiagScale(memStep.head(), memGradDelta.head()) : 1.0 / BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(grad, this.breeze$optimize$TruncatedNewtonMinimizer$$space.normImpl()));
        Object dir = this.breeze$optimize$TruncatedNewtonMinimizer$$space.copy().apply(grad);
        double[] as = new double[this.m];
        double[] rho = new double[this.m];
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(memStep.length() - 1), 0).by(-1).foreach((Function1 & Serializable)i -> this.chooseDescentDirection$$anonfun$1(memStep, memGradDelta, dir, as, rho, BoxesRunTime.unboxToInt((Object)i)));
        ((NumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(dir)).$times$eq(BoxesRunTime.boxToDouble((double)diag2), this.breeze$optimize$TruncatedNewtonMinimizer$$space.mulIntoVS());
        RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), memStep.length()).foreach((Function1 & Serializable)i -> this.chooseDescentDirection$$anonfun$2(memStep, memGradDelta, dir, as, rho, BoxesRunTime.unboxToInt((Object)i)));
        ((NumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(dir)).$times$eq(BoxesRunTime.boxToDouble((double)-1.0), this.breeze$optimize$TruncatedNewtonMinimizer$$space.mulIntoVS());
        return (T)dir;
    }

    private double computeDiagScale(T prevStep, T prevGradStep) {
        double sy = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(prevStep)).dot(prevGradStep, this.breeze$optimize$TruncatedNewtonMinimizer$$space.dotVV()));
        double yy = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(prevGradStep)).dot(prevGradStep, this.breeze$optimize$TruncatedNewtonMinimizer$$space.dotVV()));
        if (sy < 0.0 || Predef$.MODULE$.double2Double(sy).isNaN()) {
            throw new NaNHistory();
        }
        return sy / yy;
    }

    public History updateHistory(T newX, T newGrad, double newVal, State oldState) {
        Object gradDelta = ((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(newGrad)).$minus$colon$minus(oldState.adjGrad(), this.breeze$optimize$TruncatedNewtonMinimizer$$space.subVV());
        Object step = ((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(newX)).$minus(oldState.x(), this.breeze$optimize$TruncatedNewtonMinimizer$$space.subVV());
        IndexedSeq memStep = (IndexedSeq)((IndexedSeqOps)oldState.history().memStep().$plus$colon(step)).take(this.m);
        IndexedSeq memGradDelta = (IndexedSeq)((IndexedSeqOps)oldState.history().memGradDelta().$plus$colon(gradDelta)).take(this.m);
        return new History(this, memStep, memGradDelta);
    }

    private final String iterations$$anonfun$2$$anonfun$1(State state$1, Object residual$1, double predictedReduction$1, Object adjNewG$1, double adjNewV$1, double actualReduction$1) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Accept %d d=%.2E newv=%.4E newG=%.4E resNorm=%.2E pred=%.2E actual=%.2E"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)state$1.iter()), BoxesRunTime.boxToDouble((double)state$1.delta()), BoxesRunTime.boxToDouble((double)adjNewV$1), norm$.MODULE$.apply(adjNewG$1, this.breeze$optimize$TruncatedNewtonMinimizer$$space.normImpl()), norm$.MODULE$.apply(residual$1, this.breeze$optimize$TruncatedNewtonMinimizer$$space.normImpl()), BoxesRunTime.boxToDouble((double)predictedReduction$1), BoxesRunTime.boxToDouble((double)actualReduction$1)}));
    }

    private final String iterations$$anonfun$3$$anonfun$2(State state$2, Object residual$2, double predictedReduction$2, double actualReduction$2) {
        return StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Reject %d d=%.2f resNorm=%.2f pred=%.2f actual=%.2f"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)state$2.iter()), BoxesRunTime.boxToDouble((double)state$2.delta()), norm$.MODULE$.apply(residual$2, this.breeze$optimize$TruncatedNewtonMinimizer$$space.normImpl()), BoxesRunTime.boxToDouble((double)predictedReduction$2), BoxesRunTime.boxToDouble((double)actualReduction$2)}));
    }

    private final /* synthetic */ Object chooseDescentDirection$$anonfun$1(IndexedSeq memStep$1, IndexedSeq memGradDelta$1, Object dir$1, double[] as$1, double[] rho$1, int i) {
        rho$1[i] = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(memStep$1.apply(i))).dot(memGradDelta$1.apply(i), this.breeze$optimize$TruncatedNewtonMinimizer$$space.dotVV()));
        as$1[i] = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(memStep$1.apply(i))).dot(dir$1, this.breeze$optimize$TruncatedNewtonMinimizer$$space.dotVV())) / rho$1[i];
        if (Predef$.MODULE$.double2Double(as$1[i]).isNaN()) {
            throw new NaNHistory();
        }
        return ((NumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(dir$1)).$minus$eq(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(memGradDelta$1.apply(i))).$times(BoxesRunTime.boxToDouble((double)as$1[i]), this.breeze$optimize$TruncatedNewtonMinimizer$$space.mulVS_M()), this.breeze$optimize$TruncatedNewtonMinimizer$$space.subIntoVV());
    }

    private final /* synthetic */ Object chooseDescentDirection$$anonfun$2(IndexedSeq memStep$2, IndexedSeq memGradDelta$2, Object dir$2, double[] as$2, double[] rho$2, int i) {
        double beta = BoxesRunTime.unboxToDouble(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(memGradDelta$2.apply(i))).dot(dir$2, this.breeze$optimize$TruncatedNewtonMinimizer$$space.dotVV())) / rho$2[i];
        return ((NumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(dir$2)).$plus$eq(((ImmutableNumericOps)((Conversion)this.breeze$optimize$TruncatedNewtonMinimizer$$space.hasOps()).apply(memStep$2.apply(i))).$times(BoxesRunTime.boxToDouble((double)(as$2[i] - beta)), this.breeze$optimize$TruncatedNewtonMinimizer$$space.mulVS_M()), this.breeze$optimize$TruncatedNewtonMinimizer$$space.addIntoVV());
    }

    public class History
    implements Product,
    Serializable {
        private final IndexedSeq memStep;
        private final IndexedSeq memGradDelta;
        private final TruncatedNewtonMinimizer<T, H> $outer;

        public History(TruncatedNewtonMinimizer $outer, IndexedSeq<T> memStep, IndexedSeq<T> memGradDelta) {
            this.memStep = memStep;
            this.memGradDelta = memGradDelta;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof History)) return false;
            if (((History)object).breeze$optimize$TruncatedNewtonMinimizer$History$$$outer() != this.$outer) return false;
            History history = (History)object;
            IndexedSeq indexedSeq = this.memStep();
            IndexedSeq indexedSeq2 = history.memStep();
            if (indexedSeq == null) {
                if (indexedSeq2 != null) {
                    return false;
                }
            } else if (!indexedSeq.equals(indexedSeq2)) return false;
            IndexedSeq indexedSeq3 = this.memGradDelta();
            IndexedSeq indexedSeq4 = history.memGradDelta();
            if (indexedSeq3 == null) {
                if (indexedSeq4 != null) {
                    return false;
                }
            } else if (!indexedSeq3.equals(indexedSeq4)) return false;
            if (!history.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof History;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "History";
        }

        public Object productElement(int n) {
            IndexedSeq indexedSeq;
            int n2 = n;
            if (0 == n2) {
                indexedSeq = this._1();
            } else if (1 == n2) {
                indexedSeq = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return indexedSeq;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "memStep";
            } else if (1 == n2) {
                string = "memGradDelta";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public IndexedSeq<T> memStep() {
            return this.memStep;
        }

        public IndexedSeq<T> memGradDelta() {
            return this.memGradDelta;
        }

        public History copy(IndexedSeq<T> memStep, IndexedSeq<T> memGradDelta) {
            return new History(this.$outer, memStep, memGradDelta);
        }

        public IndexedSeq<T> copy$default$1() {
            return this.memStep();
        }

        public IndexedSeq<T> copy$default$2() {
            return this.memGradDelta();
        }

        public IndexedSeq<T> _1() {
            return this.memStep();
        }

        public IndexedSeq<T> _2() {
            return this.memGradDelta();
        }

        public final TruncatedNewtonMinimizer<T, H> breeze$optimize$TruncatedNewtonMinimizer$History$$$outer() {
            return this.$outer;
        }
    }

    public class State
    implements Product,
    Serializable {
        private final int iter;
        private final double initialGNorm;
        private final double delta;
        private final Object x;
        private final double fval;
        private final Object grad;
        private final Object h;
        private final double adjFval;
        private final Object adjGrad;
        private final boolean stop;
        private final boolean accept;
        private final History history;
        private final TruncatedNewtonMinimizer<T, H> $outer;

        public State(TruncatedNewtonMinimizer $outer, int iter, double initialGNorm, double delta, T x, double fval, T grad, H h, double adjFval, T adjGrad, boolean stop, boolean accept, History history) {
            this.iter = iter;
            this.initialGNorm = initialGNorm;
            this.delta = delta;
            this.x = x;
            this.fval = fval;
            this.grad = grad;
            this.h = h;
            this.adjFval = adjFval;
            this.adjGrad = adjGrad;
            this.stop = stop;
            this.accept = accept;
            this.history = history;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)this.iter());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.initialGNorm()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.delta()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.x()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.fval()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.grad()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.h()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.adjFval()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.adjGrad()));
            n = Statics.mix((int)n, (int)(this.stop() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)(this.accept() ? 1231 : 1237));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.history()));
            return Statics.finalizeHash((int)n, (int)12);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            if (((State)object).breeze$optimize$TruncatedNewtonMinimizer$State$$$outer() != this.$outer) return false;
            State state = (State)object;
            if (this.iter() != state.iter()) return false;
            if (this.initialGNorm() != state.initialGNorm()) return false;
            if (this.delta() != state.delta()) return false;
            if (this.fval() != state.fval()) return false;
            if (this.adjFval() != state.adjFval()) return false;
            if (this.stop() != state.stop()) return false;
            if (this.accept() != state.accept()) return false;
            if (!BoxesRunTime.equals(this.x(), state.x())) return false;
            if (!BoxesRunTime.equals(this.grad(), state.grad())) return false;
            if (!BoxesRunTime.equals(this.h(), state.h())) return false;
            if (!BoxesRunTime.equals(this.adjGrad(), state.adjGrad())) return false;
            History history = this.history();
            History history2 = state.history();
            if (history == null) {
                if (history2 != null) {
                    return false;
                }
            } else if (!((Object)history).equals(history2)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 12;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = BoxesRunTime.boxToInteger((int)this._1());
                    break;
                }
                case 1: {
                    object = BoxesRunTime.boxToDouble((double)this._2());
                    break;
                }
                case 2: {
                    object = BoxesRunTime.boxToDouble((double)this._3());
                    break;
                }
                case 3: {
                    object = this._4();
                    break;
                }
                case 4: {
                    object = BoxesRunTime.boxToDouble((double)this._5());
                    break;
                }
                case 5: {
                    object = this._6();
                    break;
                }
                case 6: {
                    object = this._7();
                    break;
                }
                case 7: {
                    object = BoxesRunTime.boxToDouble((double)this._8());
                    break;
                }
                case 8: {
                    object = this._9();
                    break;
                }
                case 9: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._10());
                    break;
                }
                case 10: {
                    object = BoxesRunTime.boxToBoolean((boolean)this._11());
                    break;
                }
                case 11: {
                    object = this._12();
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "iter";
                    break;
                }
                case 1: {
                    string = "initialGNorm";
                    break;
                }
                case 2: {
                    string = "delta";
                    break;
                }
                case 3: {
                    string = "x";
                    break;
                }
                case 4: {
                    string = "fval";
                    break;
                }
                case 5: {
                    string = "grad";
                    break;
                }
                case 6: {
                    string = "h";
                    break;
                }
                case 7: {
                    string = "adjFval";
                    break;
                }
                case 8: {
                    string = "adjGrad";
                    break;
                }
                case 9: {
                    string = "stop";
                    break;
                }
                case 10: {
                    string = "accept";
                    break;
                }
                case 11: {
                    string = "history";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public int iter() {
            return this.iter;
        }

        public double initialGNorm() {
            return this.initialGNorm;
        }

        public double delta() {
            return this.delta;
        }

        public T x() {
            return this.x;
        }

        public double fval() {
            return this.fval;
        }

        public T grad() {
            return this.grad;
        }

        public H h() {
            return this.h;
        }

        public double adjFval() {
            return this.adjFval;
        }

        public T adjGrad() {
            return this.adjGrad;
        }

        public boolean stop() {
            return this.stop;
        }

        public boolean accept() {
            return this.accept;
        }

        public History history() {
            return this.history;
        }

        public boolean converged() {
            return this.iter() >= this.$outer.breeze$optimize$TruncatedNewtonMinimizer$$maxIterations && this.$outer.breeze$optimize$TruncatedNewtonMinimizer$$maxIterations > 0 && this.accept() || BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(this.adjGrad(), this.$outer.breeze$optimize$TruncatedNewtonMinimizer$$space.normImpl())) <= this.$outer.breeze$optimize$TruncatedNewtonMinimizer$$tolerance * this.initialGNorm() || this.stop();
        }

        public State copy(int iter, double initialGNorm, double delta, T x, double fval, T grad, H h, double adjFval, T adjGrad, boolean stop, boolean accept, History history) {
            return new State(this.$outer, iter, initialGNorm, delta, x, fval, grad, h, adjFval, adjGrad, stop, accept, history);
        }

        public int copy$default$1() {
            return this.iter();
        }

        public double copy$default$2() {
            return this.initialGNorm();
        }

        public double copy$default$3() {
            return this.delta();
        }

        public Object copy$default$4() {
            return this.x();
        }

        public double copy$default$5() {
            return this.fval();
        }

        public Object copy$default$6() {
            return this.grad();
        }

        public Object copy$default$7() {
            return this.h();
        }

        public double copy$default$8() {
            return this.adjFval();
        }

        public Object copy$default$9() {
            return this.adjGrad();
        }

        public boolean copy$default$10() {
            return this.stop();
        }

        public boolean copy$default$11() {
            return this.accept();
        }

        public History copy$default$12() {
            return this.history();
        }

        public int _1() {
            return this.iter();
        }

        public double _2() {
            return this.initialGNorm();
        }

        public double _3() {
            return this.delta();
        }

        public T _4() {
            return this.x();
        }

        public double _5() {
            return this.fval();
        }

        public T _6() {
            return this.grad();
        }

        public H _7() {
            return this.h();
        }

        public double _8() {
            return this.adjFval();
        }

        public T _9() {
            return this.adjGrad();
        }

        public boolean _10() {
            return this.stop();
        }

        public boolean _11() {
            return this.accept();
        }

        public History _12() {
            return this.history();
        }

        public final TruncatedNewtonMinimizer<T, H> breeze$optimize$TruncatedNewtonMinimizer$State$$$outer() {
            return this.$outer;
        }
    }
}

