/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.linear;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.Vector;
import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import breeze.numerics.package$abs$;
import breeze.numerics.package$abs$absDoubleImpl$;
import breeze.optimize.linear.PowerMethod$;
import breeze.optimize.linear.PowerMethod$State$;
import breeze.optimize.proximal.QuadraticMinimizer$;
import breeze.storage.Zero$;
import breeze.util.Implicits$;
import breeze.util.LazyLogger;
import breeze.util.SerializableLogging;
import java.io.Serializable;
import scala.Function1;
import scala.Predef$;
import scala.Product;
import scala.collection.Iterator;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class PowerMethod
implements SerializableLogging {
    private volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;
    private final int maxIters;
    private final double tolerance;
    public final PowerMethod$State$ State$lzy1;

    public static PowerMethod inverse(int n, double d) {
        return PowerMethod$.MODULE$.inverse(n, d);
    }

    public static int $lessinit$greater$default$1() {
        return PowerMethod$.MODULE$.$lessinit$greater$default$1();
    }

    public static int inverse$default$1() {
        return PowerMethod$.MODULE$.inverse$default$1();
    }

    public static double $lessinit$greater$default$2() {
        return PowerMethod$.MODULE$.$lessinit$greater$default$2();
    }

    public static double inverse$default$2() {
        return PowerMethod$.MODULE$.inverse$default$2();
    }

    public PowerMethod(int maxIters, double tolerance) {
        this.maxIters = maxIters;
        this.tolerance = tolerance;
        this.State$lzy1 = new PowerMethod$State$(this);
        SerializableLogging.$init$(this);
    }

    @Override
    public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
        return this.breeze$util$SerializableLogging$$_the_logger;
    }

    @Override
    public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
        this.breeze$util$SerializableLogging$$_the_logger = x$1;
    }

    public final PowerMethod$State$ State() {
        return this.State$lzy1;
    }

    public DenseVector<Object> normalize(DenseVector<Object> ynorm, DenseVector<Object> y) {
        double normInit = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(y, norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))));
        ynorm.$colon$eq(y, HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
        return (DenseVector)ynorm.$times$eq(BoxesRunTime.boxToDouble((double)(1.0 / normInit)), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
    }

    public State initialState(int n) {
        Vector ynorm = DenseVector$.MODULE$.zeros(n, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        Vector ay = DenseVector$.MODULE$.zeros(n, ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
        return this.State().apply(0.0, (DenseVector)ynorm, (DenseVector)ay, 0, false);
    }

    public State reset(DenseMatrix A, DenseVector y, State init) {
        Predef$.MODULE$.require(init.eigenVector().length() == y.length(), PowerMethod::reset$$anonfun$1);
        this.normalize(init.eigenVector(), y);
        QuadraticMinimizer$.MODULE$.gemv(1.0, A, init.eigenVector(), 0.0, init.ay());
        double lambda = this.nextEigen(init.eigenVector(), init.ay());
        return this.State().apply(lambda, init.eigenVector(), init.ay(), 0, false);
    }

    /*
     * WARNING - void declaration
     */
    public double nextEigen(DenseVector eigenVector, DenseVector ay) {
        void var3_3;
        double lambda = BoxesRunTime.unboxToDouble((Object)eigenVector.dot(ay, (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
        eigenVector.$colon$eq(ay, HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
        double norm1 = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(ay, norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))));
        eigenVector.$times$eq(BoxesRunTime.boxToDouble((double)(1.0 / norm1)), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
        if (lambda < 0.0) {
            eigenVector.$times$eq(BoxesRunTime.boxToDouble((double)-1.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
        }
        return (double)var3_3;
    }

    public Iterator<State> iterations(DenseMatrix<Object> A, DenseVector<Object> y) {
        State init = this.initialState(y.length());
        return this.iterations(A, y, init);
    }

    public Iterator<State> iterations(DenseMatrix<Object> A, DenseVector<Object> y, State initialState) {
        return Implicits$.MODULE$.scEnrichIterator(package$.MODULE$.Iterator().iterate((Object)this.reset(A, y, initialState), (Function1 & Serializable)state -> {
            QuadraticMinimizer$.MODULE$.gemv(1.0, A, state.eigenVector(), 0.0, state.ay());
            double lambda = this.nextEigen(state.eigenVector(), state.ay());
            double val_dif = BoxesRunTime.unboxToDouble((Object)package$abs$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(lambda - state.eigenValue())), (UFunc.UImpl)package$abs$absDoubleImpl$.MODULE$));
            return val_dif <= this.tolerance || state.iter() > this.maxIters ? this.State().apply(lambda, state.eigenVector(), state.ay(), state.iter() + 1, true) : this.State().apply(lambda, state.eigenVector(), state.ay(), state.iter() + 1, false);
        })).takeUpToWhere((Function1 & Serializable)_$1 -> _$1.converged());
    }

    public State iterateAndReturnState(DenseMatrix A, DenseVector y) {
        return (State)Implicits$.MODULE$.scEnrichIterator((Iterator)this.iterations(A, y)).last();
    }

    public double eigen(DenseMatrix A, DenseVector y) {
        return this.iterateAndReturnState(A, y).eigenValue();
    }

    private static final String reset$$anonfun$1() {
        return "PowerMethod:reset mismatch in state dimension";
    }

    public class State
    implements Product,
    Serializable {
        private final double eigenValue;
        private final DenseVector eigenVector;
        private final DenseVector ay;
        private final int iter;
        private final boolean converged;
        private final PowerMethod $outer;

        public State(PowerMethod $outer, double eigenValue, DenseVector eigenVector, DenseVector ay, int iter, boolean converged) {
            this.eigenValue = eigenValue;
            this.eigenVector = eigenVector;
            this.ay = ay;
            this.iter = iter;
            this.converged = converged;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.eigenValue()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.eigenVector()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.ay()));
            n = Statics.mix((int)n, (int)this.iter());
            n = Statics.mix((int)n, (int)(this.converged() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)5);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            if (((State)object).breeze$optimize$linear$PowerMethod$State$$$outer() != this.$outer) return false;
            State state = (State)object;
            if (this.eigenValue() != state.eigenValue()) return false;
            if (this.iter() != state.iter()) return false;
            if (this.converged() != state.converged()) return false;
            DenseVector denseVector = this.eigenVector();
            DenseVector denseVector2 = state.eigenVector();
            if (denseVector == null) {
                if (denseVector2 != null) {
                    return false;
                }
            } else if (!((Object)denseVector).equals(denseVector2)) return false;
            DenseVector denseVector3 = this.ay();
            DenseVector denseVector4 = state.ay();
            if (denseVector3 == null) {
                if (denseVector4 != null) {
                    return false;
                }
            } else if (!((Object)denseVector3).equals(denseVector4)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 5;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    serializable = BoxesRunTime.boxToDouble((double)this._1());
                    break;
                }
                case 1: {
                    serializable = this._2();
                    break;
                }
                case 2: {
                    serializable = this._3();
                    break;
                }
                case 3: {
                    serializable = BoxesRunTime.boxToInteger((int)this._4());
                    break;
                }
                case 4: {
                    serializable = BoxesRunTime.boxToBoolean((boolean)this._5());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return serializable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "eigenValue";
                    break;
                }
                case 1: {
                    string = "eigenVector";
                    break;
                }
                case 2: {
                    string = "ay";
                    break;
                }
                case 3: {
                    string = "iter";
                    break;
                }
                case 4: {
                    string = "converged";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public double eigenValue() {
            return this.eigenValue;
        }

        public DenseVector eigenVector() {
            return this.eigenVector;
        }

        public DenseVector ay() {
            return this.ay;
        }

        public int iter() {
            return this.iter;
        }

        public boolean converged() {
            return this.converged;
        }

        public State copy(double eigenValue, DenseVector eigenVector, DenseVector ay, int iter, boolean converged) {
            return new State(this.$outer, eigenValue, eigenVector, ay, iter, converged);
        }

        public double copy$default$1() {
            return this.eigenValue();
        }

        public DenseVector copy$default$2() {
            return this.eigenVector();
        }

        public DenseVector copy$default$3() {
            return this.ay();
        }

        public int copy$default$4() {
            return this.iter();
        }

        public boolean copy$default$5() {
            return this.converged();
        }

        public double _1() {
            return this.eigenValue();
        }

        public DenseVector _2() {
            return this.eigenVector();
        }

        public DenseVector _3() {
            return this.ay();
        }

        public int _4() {
            return this.iter();
        }

        public boolean _5() {
            return this.converged();
        }

        public final PowerMethod breeze$optimize$linear$PowerMethod$State$$$outer() {
            return this.$outer;
        }
    }
}

