/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.proximal;

import breeze.generic.UFunc;
import breeze.linalg.DenseMatrix;
import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.Tensor;
import breeze.linalg.Vector;
import breeze.linalg.operators.HasOps$;
import breeze.optimize.DiffFunction;
import breeze.optimize.proximal.LogisticGenerator$;
import breeze.optimize.proximal.LogisticGenerator$Cost$;
import breeze.storage.Zero$;
import java.io.Serializable;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public final class LogisticGenerator {
    public static DiffFunction<DenseVector<Object>> apply(int n) {
        return LogisticGenerator$.MODULE$.apply(n);
    }

    public static class Cost
    implements DiffFunction<DenseVector<Object>>,
    Product,
    Serializable {
        private final DenseMatrix data;
        private final DenseVector labels;

        public static Cost fromProduct(Product product2) {
            return LogisticGenerator$Cost$.MODULE$.fromProduct(product2);
        }

        public static Cost unapply(Cost cost) {
            return LogisticGenerator$Cost$.MODULE$.unapply(cost);
        }

        public Cost(DenseMatrix<Object> data, DenseVector<Object> labels) {
            this.data = data;
            this.labels = labels;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Cost)) return false;
            Cost cost = (Cost)object;
            DenseMatrix<Object> denseMatrix = this.data();
            DenseMatrix<Object> denseMatrix2 = cost.data();
            if (denseMatrix == null) {
                if (denseMatrix2 != null) {
                    return false;
                }
            } else if (!((Object)denseMatrix).equals(denseMatrix2)) return false;
            DenseVector<Object> denseVector = this.labels();
            DenseVector<Object> denseVector2 = cost.labels();
            if (denseVector == null) {
                if (denseVector2 != null) {
                    return false;
                }
            } else if (!((Object)denseVector).equals(denseVector2)) return false;
            if (!cost.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof Cost;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "Cost";
        }

        public Object productElement(int n) {
            Tensor tensor;
            int n2 = n;
            if (0 == n2) {
                tensor = this._1();
            } else if (1 == n2) {
                tensor = this._2();
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return tensor;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            if (0 == n2) {
                string = "data";
            } else if (1 == n2) {
                string = "labels";
            } else {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return string;
        }

        public DenseMatrix<Object> data() {
            return this.data;
        }

        public DenseVector<Object> labels() {
            return this.labels;
        }

        @Override
        public Tuple2<Object, DenseVector<Object>> calculate(DenseVector<Object> x) {
            Vector cumGradient = DenseVector$.MODULE$.zeros(x.length(), ClassTag$.MODULE$.apply(Double.TYPE), Zero$.MODULE$.DoubleZero());
            double cumLoss = 0.0;
            for (int i = 0; i < this.data().rows(); ++i) {
                DenseVector brzData = (DenseVector)((ImmutableNumericOps)this.data().apply(BoxesRunTime.boxToInteger((int)i), scala.package$.MODULE$.$colon$colon(), HasOps$.MODULE$.canSliceRow())).t(HasOps$.MODULE$.canUntranspose());
                double margin = -1.0 * BoxesRunTime.unboxToDouble((Object)x.dot(brzData, (UFunc.UImpl2)HasOps$.MODULE$.canDotD()));
                double gradientMultiplier = 1.0 / (1.0 + package$.MODULE$.exp(margin)) - BoxesRunTime.unboxToDouble((Object)this.labels().apply(i));
                DenseVector gradient = (DenseVector)brzData.$times(BoxesRunTime.boxToDouble((double)gradientMultiplier), HasOps$.MODULE$.impl_Op_DV_S_eq_DV_Double_OpMulMatrix());
                double loss = BoxesRunTime.unboxToDouble((Object)this.labels().apply(i)) > 0.0 ? package$.MODULE$.log1p(package$.MODULE$.exp(margin)) : package$.MODULE$.log1p(package$.MODULE$.exp(margin)) - margin;
                ((DenseVector)cumGradient).$plus$eq(gradient, HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
                cumLoss += loss;
            }
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)cumLoss), (Object)cumGradient);
        }

        public Cost copy(DenseMatrix<Object> data, DenseVector<Object> labels) {
            return new Cost(data, labels);
        }

        public DenseMatrix<Object> copy$default$1() {
            return this.data();
        }

        public DenseVector<Object> copy$default$2() {
            return this.labels();
        }

        public DenseMatrix<Object> _1() {
            return this.data();
        }

        public DenseVector<Object> _2() {
            return this.labels();
        }
    }
}

