/*
 * Decompiled with CFR 0.152.
 */
package breeze.optimize.proximal;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.linalg.ImmutableNumericOps;
import breeze.linalg.NumericOps;
import breeze.linalg.Vector;
import breeze.linalg.max$;
import breeze.linalg.norm$;
import breeze.linalg.operators.HasOps$;
import breeze.math.MutableInnerProductModule;
import breeze.optimize.DiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.LBFGS;
import breeze.optimize.proximal.NonlinearMinimizer$;
import breeze.optimize.proximal.NonlinearMinimizer$Projection$;
import breeze.optimize.proximal.NonlinearMinimizer$ProximalPrimal$;
import breeze.optimize.proximal.NonlinearMinimizer$State$;
import breeze.optimize.proximal.Proximal;
import breeze.util.Implicits$;
import breeze.util.LazyLogger;
import breeze.util.SerializableLogging;
import java.io.Serializable;
import scala.Conversion;
import scala.Enumeration;
import scala.Function1;
import scala.Int$;
import scala.MatchError;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterator;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

public class NonlinearMinimizer
implements SerializableLogging {
    private volatile transient LazyLogger breeze$util$SerializableLogging$$_the_logger;
    private final Proximal proximal;
    private final int maxIters;
    private final double rho;
    private final double alpha;
    private final double abstol;
    private final double reltol;
    private final LBFGS lbfgs;
    public final NonlinearMinimizer$State$ State$lzy1;

    public static FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> apply(int n, Enumeration.Value value, double d, boolean bl) {
        return NonlinearMinimizer$.MODULE$.apply(n, value, d, bl);
    }

    public static void main(String[] stringArray) {
        NonlinearMinimizer$.MODULE$.main(stringArray);
    }

    public static FirstOrderMinimizer<DenseVector<Object>, DiffFunction<DenseVector<Object>>> project(Proximal proximal, int n, int n2, double d, boolean bl) {
        return NonlinearMinimizer$.MODULE$.project(proximal, n, n2, d, bl);
    }

    public static int $lessinit$greater$default$2() {
        return NonlinearMinimizer$.MODULE$.$lessinit$greater$default$2();
    }

    public static int project$default$2() {
        return NonlinearMinimizer$.MODULE$.project$default$2();
    }

    public static int $lessinit$greater$default$3() {
        return NonlinearMinimizer$.MODULE$.$lessinit$greater$default$3();
    }

    public static int project$default$3() {
        return NonlinearMinimizer$.MODULE$.project$default$3();
    }

    public static int $lessinit$greater$default$4() {
        return NonlinearMinimizer$.MODULE$.$lessinit$greater$default$4();
    }

    public static boolean apply$default$4() {
        return NonlinearMinimizer$.MODULE$.apply$default$4();
    }

    public static double project$default$4() {
        return NonlinearMinimizer$.MODULE$.project$default$4();
    }

    public static double $lessinit$greater$default$5() {
        return NonlinearMinimizer$.MODULE$.$lessinit$greater$default$5();
    }

    public static boolean project$default$5() {
        return NonlinearMinimizer$.MODULE$.project$default$5();
    }

    public static double $lessinit$greater$default$6() {
        return NonlinearMinimizer$.MODULE$.$lessinit$greater$default$6();
    }

    public static double $lessinit$greater$default$7() {
        return NonlinearMinimizer$.MODULE$.$lessinit$greater$default$7();
    }

    public static double $lessinit$greater$default$8() {
        return NonlinearMinimizer$.MODULE$.$lessinit$greater$default$8();
    }

    public NonlinearMinimizer(Proximal proximal, int maxIters, int innerIters, int bfgsMemory, double rho, double alpha, double abstol, double reltol) {
        this.proximal = proximal;
        this.maxIters = maxIters;
        this.rho = rho;
        this.alpha = alpha;
        this.abstol = abstol;
        this.reltol = reltol;
        this.State$lzy1 = new NonlinearMinimizer$State$(this);
        SerializableLogging.$init$(this);
        this.lbfgs = new LBFGS(innerIters, bfgsMemory, abstol, DenseVector$.MODULE$.space_Double());
    }

    @Override
    public LazyLogger breeze$util$SerializableLogging$$_the_logger() {
        return this.breeze$util$SerializableLogging$$_the_logger;
    }

    @Override
    public void breeze$util$SerializableLogging$$_the_logger_$eq(LazyLogger x$1) {
        this.breeze$util$SerializableLogging$$_the_logger = x$1;
    }

    public LBFGS<DenseVector<Object>> lbfgs() {
        return this.lbfgs;
    }

    public final NonlinearMinimizer$State$ State() {
        return this.State$lzy1;
    }

    private State initialState(DiffFunction<DenseVector<Object>> primal, DenseVector<Object> init) {
        Vector z = init.copy();
        Vector u = init.copy();
        Vector xHat = init.copy();
        Vector zOld = init.copy();
        Vector residual = init.copy();
        Vector s = init.copy();
        FirstOrderMinimizer.State<Vector, Object, Object> resultState = this.lbfgs().minimizeAndReturnState(primal, (DenseVector<Object>)xHat);
        int admmIters = this.maxIters < 0 ? BoxesRunTime.unboxToInt((Object)max$.MODULE$.apply(BoxesRunTime.boxToInteger((int)400), BoxesRunTime.boxToInteger((int)(20 * ((DenseVector)z).length())), max$.MODULE$.maxImpl2_Int())) : this.maxIters;
        return this.State().apply(resultState, (DenseVector)u, (DenseVector)z, (DenseVector)xHat, (DenseVector)zOld, (DenseVector)residual, (DenseVector)s, admmIters, 0, false);
    }

    public Iterator<State> iterations(DiffFunction<DenseVector<Object>> primal, DenseVector<Object> init) {
        return Implicits$.MODULE$.scEnrichIterator(scala.package$.MODULE$.Iterator().iterate((Object)this.initialState(primal, init), (Function1 & Serializable)state -> {
            double scale = package$.MODULE$.sqrt(Int$.MODULE$.int2double(init.size())) * this.abstol;
            ProximalPrimal<DenseVector> proxPrimal = NonlinearMinimizer$ProximalPrimal$.MODULE$.apply(primal, state.u(), state.z(), this.rho, DenseVector$.MODULE$.space_Double());
            FirstOrderMinimizer.State resultState = this.lbfgs().minimizeAndReturnState(proxPrimal, (DenseVector<Object>)state.bfgsState().x());
            state.zOld().$colon$eq(state.z(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            state.zOld().$times$eq(BoxesRunTime.boxToDouble((double)(1.0 - this.alpha)), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
            state.xHat().$colon$eq(resultState.x(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            state.xHat().$times$eq(BoxesRunTime.boxToDouble((double)this.alpha), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
            state.xHat().$plus$eq(state.zOld(), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
            state.zOld().$colon$eq(state.z(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            state.z().$colon$eq(state.xHat(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            state.z().$plus$eq(state.u(), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
            this.proximal.prox(state.z(), this.rho);
            state.xHat().$minus$eq(state.z(), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Double());
            state.u().$plus$eq(state.xHat(), HasOps$.MODULE$.impl_OpAdd_InPlace_DV_DV_Double());
            state.residual().$colon$eq(resultState.x(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            state.residual().$minus$eq(state.z(), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Double());
            double residualNorm = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(state.residual(), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))));
            state.s().$colon$eq(state.z(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            state.s().$minus$eq(state.zOld(), HasOps$.MODULE$.impl_OpSub_InPlace_DV_DV_Double());
            state.s().$times$eq(BoxesRunTime.boxToDouble((double)(-this.rho)), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
            double sNorm = BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(state.s(), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))));
            state.residual().$colon$eq(state.z(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            state.residual().$times$eq(BoxesRunTime.boxToDouble((double)-1.0), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
            state.s().$colon$eq(state.u(), HasOps$.MODULE$.impl_Op_InPlace_DV_DV_Double_OpSet());
            state.s().$times$eq(BoxesRunTime.boxToDouble((double)this.rho), HasOps$.MODULE$.impl_Op_InPlace_DV_S_Double_OpMulScalar());
            double epsPrimal = scale + this.reltol * BoxesRunTime.unboxToDouble((Object)max$.MODULE$.apply(norm$.MODULE$.apply(resultState.x(), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))), norm$.MODULE$.apply(state.residual(), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))), max$.MODULE$.maxImpl2_Double()));
            double epsDual = scale + this.reltol * BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(state.s(), norm$.MODULE$.normDoubleToNormalNorm(norm$.MODULE$.canNorm(HasOps$.MODULE$.DV_canIterateValues(), norm$.MODULE$.scalarNorm_Double()))));
            return residualNorm < epsPrimal && sNorm < epsDual || state.iter() > state.admmIters() ? this.State().apply(resultState, state.u(), state.z(), state.xHat(), state.zOld(), state.residual(), state.s(), state.admmIters(), state.iter() + 1, true) : this.State().apply(resultState, state.u(), state.z(), state.xHat(), state.zOld(), state.residual(), state.s(), state.admmIters(), state.iter() + 1, false);
        })).takeUpToWhere((Function1 & Serializable)_$1 -> _$1.converged());
    }

    public DenseVector<Object> minimize(DiffFunction<DenseVector<Object>> primal, DenseVector<Object> init) {
        return this.minimizeAndReturnState(primal, init).z();
    }

    public State minimizeAndReturnState(DiffFunction<DenseVector<Object>> primal, DenseVector<Object> init) {
        return (State)Implicits$.MODULE$.scEnrichIterator((Iterator)this.iterations(primal, init)).last();
    }

    public static class Projection
    implements Product,
    Serializable {
        private final Proximal proximal;

        public static Projection apply(Proximal proximal) {
            return NonlinearMinimizer$Projection$.MODULE$.apply(proximal);
        }

        public static Projection fromProduct(Product product2) {
            return NonlinearMinimizer$Projection$.MODULE$.fromProduct(product2);
        }

        public static Projection unapply(Projection projection) {
            return NonlinearMinimizer$Projection$.MODULE$.unapply(projection);
        }

        public Projection(Proximal proximal) {
            this.proximal = proximal;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof Projection)) return false;
            Projection projection = (Projection)object;
            Proximal proximal = this.proximal();
            Proximal proximal2 = projection.proximal();
            if (proximal == null) {
                if (proximal2 != null) {
                    return false;
                }
            } else if (!proximal.equals(proximal2)) return false;
            if (!projection.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof Projection;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "Projection";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return this._1();
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 != n2) {
                throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
            }
            return "proximal";
        }

        public Proximal proximal() {
            return this.proximal;
        }

        public DenseVector project(DenseVector x) {
            this.proximal().prox(x, this.proximal().prox$default$2());
            return x;
        }

        public Projection copy(Proximal proximal) {
            return new Projection(proximal);
        }

        public Proximal copy$default$1() {
            return this.proximal();
        }

        public Proximal _1() {
            return this.proximal();
        }
    }

    public static class ProximalPrimal<T>
    implements DiffFunction<T>,
    Product,
    Serializable {
        private final DiffFunction primal;
        private final Object u;
        private final Object z;
        private final double rho;
        private final MutableInnerProductModule<T, Object> space;

        public static <T> ProximalPrimal<T> unapply(ProximalPrimal<T> proximalPrimal) {
            return NonlinearMinimizer$ProximalPrimal$.MODULE$.unapply(proximalPrimal);
        }

        public <T> ProximalPrimal(DiffFunction<T> primal, T u, T z, double rho, MutableInnerProductModule<T, Object> space) {
            this.primal = primal;
            this.u = u;
            this.z = z;
            this.rho = rho;
            this.space = space;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash(this.primal()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.u()));
            n = Statics.mix((int)n, (int)Statics.anyHash(this.z()));
            n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.rho()));
            return Statics.finalizeHash((int)n, (int)4);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ProximalPrimal)) return false;
            ProximalPrimal proximalPrimal = (ProximalPrimal)object;
            if (this.rho() != proximalPrimal.rho()) return false;
            DiffFunction<T> diffFunction = this.primal();
            DiffFunction<T> diffFunction2 = proximalPrimal.primal();
            if (diffFunction == null) {
                if (diffFunction2 != null) {
                    return false;
                }
            } else if (!diffFunction.equals(diffFunction2)) return false;
            if (!BoxesRunTime.equals(this.u(), proximalPrimal.u())) return false;
            if (!BoxesRunTime.equals(this.z(), proximalPrimal.z())) return false;
            if (!proximalPrimal.canEqual(this)) return false;
            return true;
        }

        public boolean canEqual(Object that) {
            return that instanceof ProximalPrimal;
        }

        public int productArity() {
            return 4;
        }

        public String productPrefix() {
            return "ProximalPrimal";
        }

        public Object productElement(int n) {
            Object object;
            int n2 = n;
            switch (n2) {
                case 0: {
                    object = this._1();
                    break;
                }
                case 1: {
                    object = this._2();
                    break;
                }
                case 2: {
                    object = this._3();
                    break;
                }
                case 3: {
                    object = BoxesRunTime.boxToDouble((double)this._4());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return object;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "primal";
                    break;
                }
                case 1: {
                    string = "u";
                    break;
                }
                case 2: {
                    string = "z";
                    break;
                }
                case 3: {
                    string = "rho";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public DiffFunction<T> primal() {
            return this.primal;
        }

        public T u() {
            return (T)this.u;
        }

        public T z() {
            return (T)this.z;
        }

        public double rho() {
            return this.rho;
        }

        @Override
        public Tuple2<Object, T> calculate(T x) {
            Tuple2<Object, T> tuple2 = this.primal().calculate(x);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            double f = BoxesRunTime.unboxToDouble((Object)tuple2._1());
            Object g = tuple2._2();
            Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)f), g);
            double f2 = BoxesRunTime.unboxToDouble((Object)tuple22._1());
            Object g2 = tuple22._2();
            Object scale = ((NumericOps)((Conversion)this.space.hasOps()).apply(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(x)).$minus(this.z(), this.space.subVV()))).$plus(this.u(), this.space.addVV());
            double proxObj = f2 + 0.5 * this.rho() * package$.MODULE$.pow(BoxesRunTime.unboxToDouble((Object)norm$.MODULE$.apply(scale, this.space.normImpl())), 2.0);
            Object proxGrad = ((NumericOps)((Conversion)this.space.hasOps()).apply(g2)).$plus(((ImmutableNumericOps)((Conversion)this.space.hasOps()).apply(scale)).$times$colon$times(BoxesRunTime.boxToDouble((double)this.rho()), this.space.mulVS()), this.space.addVV());
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToDouble((double)proxObj), proxGrad);
        }

        public <T> ProximalPrimal<T> copy(DiffFunction<T> primal, T u, T z, double rho, MutableInnerProductModule<T, Object> space) {
            return new ProximalPrimal<T>(primal, u, z, rho, space);
        }

        public <T> DiffFunction<T> copy$default$1() {
            return this.primal();
        }

        public <T> T copy$default$2() {
            return this.u();
        }

        public <T> T copy$default$3() {
            return this.z();
        }

        public double copy$default$4() {
            return this.rho();
        }

        public DiffFunction<T> _1() {
            return this.primal();
        }

        public T _2() {
            return this.u();
        }

        public T _3() {
            return this.z();
        }

        public double _4() {
            return this.rho();
        }
    }

    public class State
    implements Product,
    Serializable {
        private final FirstOrderMinimizer.State bfgsState;
        private final DenseVector u;
        private final DenseVector z;
        private final DenseVector xHat;
        private final DenseVector zOld;
        private final DenseVector residual;
        private final DenseVector s;
        private final int admmIters;
        private final int iter;
        private final boolean converged;
        private final NonlinearMinimizer $outer;

        public State(NonlinearMinimizer $outer, FirstOrderMinimizer.State bfgsState, DenseVector u, DenseVector z, DenseVector xHat, DenseVector zOld, DenseVector residual, DenseVector s, int admmIters, int iter, boolean converged) {
            this.bfgsState = bfgsState;
            this.u = u;
            this.z = z;
            this.xHat = xHat;
            this.zOld = zOld;
            this.residual = residual;
            this.s = s;
            this.admmIters = admmIters;
            this.iter = iter;
            this.converged = converged;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.bfgsState()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.u()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.z()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.xHat()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.zOld()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.residual()));
            n = Statics.mix((int)n, (int)Statics.anyHash((Object)this.s()));
            n = Statics.mix((int)n, (int)this.admmIters());
            n = Statics.mix((int)n, (int)this.iter());
            n = Statics.mix((int)n, (int)(this.converged() ? 1231 : 1237));
            return Statics.finalizeHash((int)n, (int)10);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof State)) return false;
            if (((State)object).breeze$optimize$proximal$NonlinearMinimizer$State$$$outer() != this.$outer) return false;
            State state = (State)object;
            if (this.admmIters() != state.admmIters()) return false;
            if (this.iter() != state.iter()) return false;
            if (this.converged() != state.converged()) return false;
            FirstOrderMinimizer.State state2 = this.bfgsState();
            FirstOrderMinimizer.State state3 = state.bfgsState();
            if (state2 == null) {
                if (state3 != null) {
                    return false;
                }
            } else if (!((Object)state2).equals(state3)) return false;
            DenseVector denseVector = this.u();
            DenseVector denseVector2 = state.u();
            if (denseVector == null) {
                if (denseVector2 != null) {
                    return false;
                }
            } else if (!((Object)denseVector).equals(denseVector2)) return false;
            DenseVector denseVector3 = this.z();
            DenseVector denseVector4 = state.z();
            if (denseVector3 == null) {
                if (denseVector4 != null) {
                    return false;
                }
            } else if (!((Object)denseVector3).equals(denseVector4)) return false;
            DenseVector denseVector5 = this.xHat();
            DenseVector denseVector6 = state.xHat();
            if (denseVector5 == null) {
                if (denseVector6 != null) {
                    return false;
                }
            } else if (!((Object)denseVector5).equals(denseVector6)) return false;
            DenseVector denseVector7 = this.zOld();
            DenseVector denseVector8 = state.zOld();
            if (denseVector7 == null) {
                if (denseVector8 != null) {
                    return false;
                }
            } else if (!((Object)denseVector7).equals(denseVector8)) return false;
            DenseVector denseVector9 = this.residual();
            DenseVector denseVector10 = state.residual();
            if (denseVector9 == null) {
                if (denseVector10 != null) {
                    return false;
                }
            } else if (!((Object)denseVector9).equals(denseVector10)) return false;
            DenseVector denseVector11 = this.s();
            DenseVector denseVector12 = state.s();
            if (denseVector11 == null) {
                if (denseVector12 != null) {
                    return false;
                }
            } else if (!((Object)denseVector11).equals(denseVector12)) return false;
            if (!state.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof State;
        }

        public int productArity() {
            return 10;
        }

        public String productPrefix() {
            return "State";
        }

        public Object productElement(int n) {
            Serializable serializable;
            int n2 = n;
            switch (n2) {
                case 0: {
                    serializable = this._1();
                    break;
                }
                case 1: {
                    serializable = this._2();
                    break;
                }
                case 2: {
                    serializable = this._3();
                    break;
                }
                case 3: {
                    serializable = this._4();
                    break;
                }
                case 4: {
                    serializable = this._5();
                    break;
                }
                case 5: {
                    serializable = this._6();
                    break;
                }
                case 6: {
                    serializable = this._7();
                    break;
                }
                case 7: {
                    serializable = BoxesRunTime.boxToInteger((int)this._8());
                    break;
                }
                case 8: {
                    serializable = BoxesRunTime.boxToInteger((int)this._9());
                    break;
                }
                case 9: {
                    serializable = BoxesRunTime.boxToBoolean((boolean)this._10());
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return serializable;
        }

        public String productElementName(int n) {
            String string;
            int n2 = n;
            switch (n2) {
                case 0: {
                    string = "bfgsState";
                    break;
                }
                case 1: {
                    string = "u";
                    break;
                }
                case 2: {
                    string = "z";
                    break;
                }
                case 3: {
                    string = "xHat";
                    break;
                }
                case 4: {
                    string = "zOld";
                    break;
                }
                case 5: {
                    string = "residual";
                    break;
                }
                case 6: {
                    string = "s";
                    break;
                }
                case 7: {
                    string = "admmIters";
                    break;
                }
                case 8: {
                    string = "iter";
                    break;
                }
                case 9: {
                    string = "converged";
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
                }
            }
            return string;
        }

        public FirstOrderMinimizer.State bfgsState() {
            return this.bfgsState;
        }

        public DenseVector u() {
            return this.u;
        }

        public DenseVector z() {
            return this.z;
        }

        public DenseVector xHat() {
            return this.xHat;
        }

        public DenseVector zOld() {
            return this.zOld;
        }

        public DenseVector residual() {
            return this.residual;
        }

        public DenseVector s() {
            return this.s;
        }

        public int admmIters() {
            return this.admmIters;
        }

        public int iter() {
            return this.iter;
        }

        public boolean converged() {
            return this.converged;
        }

        public State copy(FirstOrderMinimizer.State bfgsState, DenseVector u, DenseVector z, DenseVector xHat, DenseVector zOld, DenseVector residual, DenseVector s, int admmIters, int iter, boolean converged) {
            return new State(this.$outer, bfgsState, u, z, xHat, zOld, residual, s, admmIters, iter, converged);
        }

        public FirstOrderMinimizer.State copy$default$1() {
            return this.bfgsState();
        }

        public DenseVector copy$default$2() {
            return this.u();
        }

        public DenseVector copy$default$3() {
            return this.z();
        }

        public DenseVector copy$default$4() {
            return this.xHat();
        }

        public DenseVector copy$default$5() {
            return this.zOld();
        }

        public DenseVector copy$default$6() {
            return this.residual();
        }

        public DenseVector copy$default$7() {
            return this.s();
        }

        public int copy$default$8() {
            return this.admmIters();
        }

        public int copy$default$9() {
            return this.iter();
        }

        public boolean copy$default$10() {
            return this.converged();
        }

        public FirstOrderMinimizer.State _1() {
            return this.bfgsState();
        }

        public DenseVector _2() {
            return this.u();
        }

        public DenseVector _3() {
            return this.z();
        }

        public DenseVector _4() {
            return this.xHat();
        }

        public DenseVector _5() {
            return this.zOld();
        }

        public DenseVector _6() {
            return this.residual();
        }

        public DenseVector _7() {
            return this.s();
        }

        public int _8() {
            return this.admmIters();
        }

        public int _9() {
            return this.iter();
        }

        public boolean _10() {
            return this.converged();
        }

        public final NonlinearMinimizer breeze$optimize$proximal$NonlinearMinimizer$State$$$outer() {
            return this.$outer;
        }
    }
}

