/*
 * Decompiled with CFR 0.152.
 */
package breeze.stats.distributions;

import breeze.generic.UFunc;
import breeze.numerics.package$lgamma$;
import breeze.numerics.package$lgamma$lgammaImplDouble$;
import breeze.numerics.package$lgamma$lgammaImplInt$;
import breeze.numerics.package$logI$;
import breeze.numerics.package$logI$logIBoolImpl$;
import breeze.stats.distributions.Binomial$;
import breeze.stats.distributions.DiscreteDistr;
import breeze.stats.distributions.Moments;
import breeze.stats.distributions.RandBasis;
import scala.Int$;
import scala.Predef$;
import scala.Product;
import scala.math.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Statics;

public class Binomial
implements DiscreteDistr<Object>,
Moments<Object, Object>,
Product {
    private final int n;
    private final double p;
    private final RandBasis rand;
    private final double pp;
    private final double nfact;
    private final double plog;
    private final double pclog;
    private final double sq;

    public static Binomial unapply(Binomial binomial) {
        return Binomial$.MODULE$.unapply(binomial);
    }

    public Binomial(int n, double p, RandBasis rand) {
        this.n = n;
        this.p = p;
        this.rand = rand;
        Predef$.MODULE$.require(n > 0, Binomial::$init$$$anonfun$1);
        Predef$.MODULE$.require(p >= 0.0, Binomial::$init$$$anonfun$2);
        this.pp = p <= 0.5 ? p : 1.0 - p;
        this.nfact = BoxesRunTime.unboxToDouble((Object)package$lgamma$.MODULE$.apply(BoxesRunTime.boxToDouble((double)((double)n + 1.0)), (UFunc.UImpl)package$lgamma$lgammaImplDouble$.MODULE$));
        double pc = 1.0 - this.pp;
        this.plog = package$.MODULE$.log(this.pp);
        this.pclog = package$.MODULE$.log(pc);
        this.sq = package$.MODULE$.sqrt(2.0 * ((double)n * this.pp) * pc);
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix((int)n, (int)this.productPrefix().hashCode());
        n = Statics.mix((int)n, (int)this.n());
        n = Statics.mix((int)n, (int)Statics.doubleHash((double)this.p()));
        return Statics.finalizeHash((int)n, (int)2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof Binomial)) return false;
        Binomial binomial = (Binomial)object;
        if (this.n() != binomial.n()) return false;
        if (this.p() != binomial.p()) return false;
        if (!binomial.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof Binomial;
    }

    public int productArity() {
        return 2;
    }

    public String productPrefix() {
        return "Binomial";
    }

    public Object productElement(int n) {
        Number number;
        int n2 = n;
        if (0 == n2) {
            number = BoxesRunTime.boxToInteger((int)this._1());
        } else if (1 == n2) {
            number = BoxesRunTime.boxToDouble((double)this._2());
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return number;
    }

    public String productElementName(int n) {
        String string;
        int n2 = n;
        if (0 == n2) {
            string = "n";
        } else if (1 == n2) {
            string = "p";
        } else {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return string;
    }

    public int n() {
        return this.n;
    }

    public double p() {
        return this.p;
    }

    @Override
    public double probabilityOf(int k) {
        return package$.MODULE$.exp(this.logProbabilityOf(k));
    }

    public String toString() {
        return "Binomial(" + this.n() + ", " + this.p() + ")";
    }

    @Override
    public double logProbabilityOf(int k) {
        Predef$.MODULE$.require(this.n() >= k);
        Predef$.MODULE$.require(k >= 0);
        return this.p() == 0.0 ? BoxesRunTime.unboxToDouble((Object)package$logI$.MODULE$.apply(BoxesRunTime.boxToBoolean((k == 0 ? 1 : 0) != 0), (UFunc.UImpl)package$logI$logIBoolImpl$.MODULE$)) : (this.p() == 1.0 ? BoxesRunTime.unboxToDouble((Object)package$logI$.MODULE$.apply(BoxesRunTime.boxToBoolean((k == this.n() ? 1 : 0) != 0), (UFunc.UImpl)package$logI$logIBoolImpl$.MODULE$)) : BoxesRunTime.unboxToDouble((Object)package$lgamma$.MODULE$.apply(BoxesRunTime.boxToInteger((int)(this.n() + 1)), (UFunc.UImpl)package$lgamma$lgammaImplInt$.MODULE$)) - BoxesRunTime.unboxToDouble((Object)package$lgamma$.MODULE$.apply(BoxesRunTime.boxToInteger((int)(k + 1)), (UFunc.UImpl)package$lgamma$lgammaImplInt$.MODULE$)) - BoxesRunTime.unboxToDouble((Object)package$lgamma$.MODULE$.apply(BoxesRunTime.boxToInteger((int)(this.n() - k + 1)), (UFunc.UImpl)package$lgamma$lgammaImplInt$.MODULE$)) + (double)k * package$.MODULE$.log(this.p()) + (double)(this.n() - k) * package$.MODULE$.log(1.0 - this.p()));
    }

    @Override
    public int draw() {
        double bnl = 0.0;
        if (this.n() < 25) {
            for (int j = 0; j < this.n(); ++j) {
                if (!(BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw()) < this.pp)) continue;
                bnl += 1.0;
            }
        } else if ((double)this.n() * this.pp < 1.0) {
            double g = package$.MODULE$.exp((double)(-this.n()) * this.pp);
            double t = 1.0;
            int j = 0;
            boolean ok = true;
            while (j < this.n() && ok) {
                if ((t *= BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw())) < g) {
                    ok = false;
                    continue;
                }
                ++j;
            }
            bnl = j <= this.n() ? Int$.MODULE$.int2double(j) : Int$.MODULE$.int2double(this.n());
        } else {
            double y = 1.0;
            double t = 1.0;
            boolean continueOuter = true;
            while (continueOuter) {
                boolean continueInner = true;
                while (continueInner) {
                    double angle = Math.PI * BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw());
                    y = package$.MODULE$.tan(angle);
                    bnl = this.sq * y + (double)this.n() * this.pp;
                    continueInner = bnl < 0.0 || bnl >= (double)this.n() + 1.0;
                }
                bnl = package$.MODULE$.floor(bnl);
                t = 1.2 * this.sq * (1.0 + y * y) * package$.MODULE$.exp(this.nfact - BoxesRunTime.unboxToDouble((Object)package$lgamma$.MODULE$.apply(BoxesRunTime.boxToDouble((double)(bnl + 1.0)), (UFunc.UImpl)package$lgamma$lgammaImplDouble$.MODULE$)) - BoxesRunTime.unboxToDouble((Object)package$lgamma$.MODULE$.apply(BoxesRunTime.boxToDouble((double)((double)this.n() - bnl + 1.0)), (UFunc.UImpl)package$lgamma$lgammaImplDouble$.MODULE$)) + bnl * this.plog + ((double)this.n() - bnl) * this.pclog);
                continueOuter = BoxesRunTime.unboxToDouble((Object)this.rand.uniform().draw()) > t;
            }
        }
        if (this.p() != this.pp) {
            bnl = (double)this.n() - bnl;
        }
        return (int)bnl;
    }

    @Override
    public double mean() {
        return (double)this.n() * this.p();
    }

    @Override
    public double variance() {
        return this.mean() * (1.0 - this.p());
    }

    @Override
    public double mode() {
        return package$.MODULE$.floor((double)(this.n() + 1) * this.p());
    }

    @Override
    public double entropy() {
        return 0.5 * package$.MODULE$.log(Math.PI * 2 * this.variance());
    }

    public Binomial copy(int n, double p, RandBasis rand) {
        return new Binomial(n, p, rand);
    }

    public int copy$default$1() {
        return this.n();
    }

    public double copy$default$2() {
        return this.p();
    }

    public int _1() {
        return this.n();
    }

    public double _2() {
        return this.p();
    }

    private static final String $init$$$anonfun$1() {
        return "n must be positive!";
    }

    private static final String $init$$$anonfun$2() {
        return "p must be non-negative!";
    }
}

