/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package chalk.tools.cmdline.coref;

import java.io.IOException;

import chalk.tools.cmdline.AbstractTrainerTool;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.coref.CoreferencerTrainerTool.TrainerToolParams;
import chalk.tools.cmdline.params.TrainingToolParams;
import chalk.tools.coref.CorefSample;
import chalk.tools.coref.CorefTrainer;


public class CoreferencerTrainerTool extends AbstractTrainerTool<CorefSample, TrainerToolParams> {

  interface TrainerToolParams extends TrainingParams, TrainingToolParams {
  }
  
  public CoreferencerTrainerTool() {
    super(CorefSample.class, TrainerToolParams.class);
  }

  @Override
  public void run(String format, String[] args) {
    
    super.run(format, args);
    
    try {
      CorefTrainer.train(params.getModel().toString(), sampleStream, true, true);
    } catch (IOException e) {
      throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " +
          e.getMessage(), e);
    }
  }
  
}
