/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package chalk.tools.cmdline.tokenizer;

import chalk.tools.cmdline.AbstractBasicCmdLineTool;
import chalk.tools.cmdline.CLI;

public final class SimpleTokenizerTool extends AbstractBasicCmdLineTool {

  public String getShortDescription() {
    return "character class tokenizer";
  }
  
  public String getHelp() {
    return "Usage: " + CLI.CMD + " " + getName() + " < sentences";
  }

  @Override
  public boolean hasParams() {
    return false;
  }

  public void run(String[] args) {
    if (args.length != 0) {
      System.out.println(getHelp());
    } else {
    
      CommandLineTokenizer tokenizer =
        new CommandLineTokenizer(chalk.tools.tokenize.SimpleTokenizer.INSTANCE);

      tokenizer.process();
    }
  }
}
