/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.chunker;

import chalk.tools.util.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class ChunkSample {
    private final List<String> sentence;
    private final List<String> tags;
    private final List<String> preds;

    public ChunkSample(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        ChunkSample.validateArguments(stringArray.length, stringArray2.length, stringArray3.length);
        this.sentence = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(stringArray)));
        this.tags = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(stringArray2)));
        this.preds = Collections.unmodifiableList(new ArrayList<String>(Arrays.asList(stringArray3)));
    }

    public ChunkSample(List<String> list, List<String> list2, List<String> list3) {
        ChunkSample.validateArguments(list.size(), list2.size(), list3.size());
        this.sentence = Collections.unmodifiableList(new ArrayList<String>(list));
        this.tags = Collections.unmodifiableList(new ArrayList<String>(list2));
        this.preds = Collections.unmodifiableList(new ArrayList<String>(list3));
    }

    public String[] getSentence() {
        return this.sentence.toArray(new String[this.sentence.size()]);
    }

    public String[] getTags() {
        return this.tags.toArray(new String[this.tags.size()]);
    }

    public String[] getPreds() {
        return this.preds.toArray(new String[this.preds.size()]);
    }

    public Span[] getPhrasesAsSpanList() {
        return ChunkSample.phrasesAsSpanList(this.getSentence(), this.getTags(), this.getPreds());
    }

    public static Span[] phrasesAsSpanList(String[] stringArray, String[] stringArray2, String[] stringArray3) {
        ChunkSample.validateArguments(stringArray.length, stringArray2.length, stringArray3.length);
        ArrayList<Span> arrayList = new ArrayList<Span>(stringArray.length);
        String string = "";
        int n = 0;
        boolean bl = false;
        int n2 = stringArray3.length;
        for (int i = 0; i < n2; ++i) {
            String string2 = stringArray3[i];
            if (string2.startsWith("B-") || !string2.equals("I-" + string) && !string2.equals("O")) {
                if (bl) {
                    arrayList.add(new Span(n, i, string));
                }
                n = i;
                string = string2.substring(2);
                bl = true;
                continue;
            }
            if (string2.equals("I-" + string) || !bl) continue;
            arrayList.add(new Span(n, i, string));
            bl = false;
            string = "";
        }
        if (bl) {
            arrayList.add(new Span(n, stringArray3.length, string));
        }
        return arrayList.toArray(new Span[arrayList.size()]);
    }

    private static void validateArguments(int n, int n2, int n3) throws IllegalArgumentException {
        if (n != n2 || n2 != n3) {
            throw new IllegalArgumentException("All arrays must have the same length: sentenceSize: " + n + ", tagsSize: " + n2 + ", predsSize: " + n3 + "!");
        }
    }

    public String nicePrint() {
        int n;
        Span[] spanArray = this.getPhrasesAsSpanList();
        StringBuilder stringBuilder = new StringBuilder(" ");
        for (n = 0; n < this.sentence.size(); ++n) {
            for (int i = 0; i < spanArray.length; ++i) {
                if (spanArray[i].getStart() == n) {
                    stringBuilder.append("[").append(spanArray[i].getType()).append(" ");
                }
                if (spanArray[i].getEnd() != n) continue;
                stringBuilder.append("]").append(' ');
            }
            stringBuilder.append(this.sentence.get(n)).append("_").append(this.tags.get(n)).append(' ');
        }
        if (this.sentence.size() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        for (n = 0; n < spanArray.length; ++n) {
            if (spanArray[n].getEnd() != this.sentence.size()) continue;
            stringBuilder.append(']');
        }
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.preds.size(); ++i) {
            stringBuilder.append(this.sentence.get(i)).append(" ").append(this.tags.get(i)).append(" ").append(this.preds.get(i)).append("\n");
        }
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof ChunkSample) {
            ChunkSample chunkSample = (ChunkSample)object;
            return Arrays.equals(this.getSentence(), chunkSample.getSentence()) && Arrays.equals(this.getTags(), chunkSample.getTags()) && Arrays.equals(this.getPreds(), chunkSample.getPreds());
        }
        return false;
    }
}

