/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.chunker;

import chalk.tools.chunker.ChunkSample;
import chalk.tools.chunker.ChunkerContextGenerator;
import chalk.tools.chunker.DefaultChunkerContextGenerator;
import chalk.tools.util.ObjectStream;
import java.io.IOException;
import nak.model.AbstractEventStream;
import nak.model.Event;

public class ChunkerEventStream
extends AbstractEventStream {
    private ChunkerContextGenerator cg;
    private ObjectStream<ChunkSample> data;
    private Event[] events;
    private int ei;

    public ChunkerEventStream(ObjectStream<ChunkSample> objectStream, ChunkerContextGenerator chunkerContextGenerator) {
        this.cg = chunkerContextGenerator;
        this.data = objectStream;
        this.ei = 0;
        this.addNewEvents();
    }

    public ChunkerEventStream(ObjectStream<ChunkSample> objectStream) {
        this(objectStream, new DefaultChunkerContextGenerator());
    }

    public Event next() {
        this.hasNext();
        return this.events[this.ei++];
    }

    public boolean hasNext() {
        if (this.ei == this.events.length) {
            this.addNewEvents();
            this.ei = 0;
        }
        return this.ei < this.events.length;
    }

    private void addNewEvents() {
        ChunkSample chunkSample;
        try {
            chunkSample = this.data.read();
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        if (chunkSample != null) {
            this.events = new Event[chunkSample.getSentence().length];
            String[] stringArray = chunkSample.getSentence();
            String[] stringArray2 = chunkSample.getTags();
            String[] stringArray3 = chunkSample.getPreds();
            int n = this.events.length;
            for (int i = 0; i < n; ++i) {
                this.events[i] = new Event(stringArray3[i], this.cg.getContext(i, stringArray, stringArray2, stringArray3));
            }
        } else {
            this.events = new Event[0];
        }
    }
}

