/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.chunker;

import chalk.tools.chunker.ChunkSample;
import chalk.tools.chunker.Chunker;
import chalk.tools.chunker.ChunkerContextGenerator;
import chalk.tools.chunker.ChunkerEventStream;
import chalk.tools.chunker.ChunkerFactory;
import chalk.tools.chunker.ChunkerModel;
import chalk.tools.chunker.DefaultChunkerContextGenerator;
import chalk.tools.util.BeamSearch;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.Sequence;
import chalk.tools.util.SequenceValidator;
import chalk.tools.util.Span;
import chalk.tools.util.TrainingParameters;
import chalk.tools.util.model.ModelUtil;
import java.io.IOException;
import java.io.ObjectStreamException;
import java.util.HashMap;
import java.util.List;
import nak.model.AbstractModel;
import nak.model.EventStream;
import nak.model.MaxentModel;
import nak.model.TrainUtil;

public class ChunkerME
implements Chunker {
    public static final int DEFAULT_BEAM_SIZE = 10;
    protected BeamSearch<String> beam;
    private Sequence bestSequence;
    protected MaxentModel model;

    public ChunkerME(ChunkerModel chunkerModel, int n, SequenceValidator<String> sequenceValidator, ChunkerContextGenerator chunkerContextGenerator) {
        this.model = chunkerModel.getChunkerModel();
        this.beam = new BeamSearch<String>(n, chunkerContextGenerator, this.model, sequenceValidator, 0);
    }

    public ChunkerME(ChunkerModel chunkerModel, int n, SequenceValidator<String> sequenceValidator) {
        this(chunkerModel, n, sequenceValidator, new DefaultChunkerContextGenerator());
    }

    public ChunkerME(ChunkerModel chunkerModel, int n) {
        this.model = chunkerModel.getChunkerModel();
        ChunkerContextGenerator chunkerContextGenerator = chunkerModel.getFactory().getContextGenerator();
        SequenceValidator<String> sequenceValidator = chunkerModel.getFactory().getSequenceValidator();
        this.beam = new BeamSearch<String>(n, chunkerContextGenerator, this.model, sequenceValidator, 0);
    }

    public ChunkerME(ChunkerModel chunkerModel) {
        this(chunkerModel, 10);
    }

    @Deprecated
    public ChunkerME(MaxentModel maxentModel) {
        this(maxentModel, new DefaultChunkerContextGenerator(), 10);
    }

    @Deprecated
    public ChunkerME(MaxentModel maxentModel, ChunkerContextGenerator chunkerContextGenerator) {
        this(maxentModel, chunkerContextGenerator, 10);
    }

    @Deprecated
    public ChunkerME(MaxentModel maxentModel, ChunkerContextGenerator chunkerContextGenerator, int n) {
        this.beam = new BeamSearch<String>(n, chunkerContextGenerator, maxentModel);
        this.model = maxentModel;
    }

    @Override
    @Deprecated
    public List<String> chunk(List<String> list, List<String> list2) {
        this.bestSequence = this.beam.bestSequence((String[])list.toArray(new String[list.size()]), new Object[]{list2.toArray(new String[list2.size()])});
        return this.bestSequence.getOutcomes();
    }

    @Override
    public String[] chunk(String[] stringArray, String[] stringArray2) {
        this.bestSequence = this.beam.bestSequence((String[])stringArray, new Object[]{stringArray2});
        List<String> list = this.bestSequence.getOutcomes();
        return list.toArray(new String[list.size()]);
    }

    @Override
    public Span[] chunkAsSpans(String[] stringArray, String[] stringArray2) {
        String[] stringArray3 = this.chunk(stringArray, stringArray2);
        return ChunkSample.phrasesAsSpanList(stringArray, stringArray2, stringArray3);
    }

    @Override
    @Deprecated
    public Sequence[] topKSequences(List<String> list, List<String> list2) {
        return this.topKSequences(list.toArray(new String[list.size()]), list2.toArray(new String[list2.size()]));
    }

    @Override
    public Sequence[] topKSequences(String[] stringArray, String[] stringArray2) {
        return this.beam.bestSequences(10, (String[])stringArray, new Object[]{stringArray2});
    }

    @Override
    public Sequence[] topKSequences(String[] stringArray, String[] stringArray2, double d) {
        return this.beam.bestSequences(10, (String[])stringArray, new Object[]{stringArray2}, d);
    }

    public void probs(double[] dArray) {
        this.bestSequence.getProbs(dArray);
    }

    public double[] probs() {
        return this.bestSequence.getProbs();
    }

    public static ChunkerModel train(String string, ObjectStream<ChunkSample> objectStream, TrainingParameters trainingParameters, ChunkerFactory chunkerFactory) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ChunkerEventStream chunkerEventStream = new ChunkerEventStream(objectStream, chunkerFactory.getContextGenerator());
        AbstractModel abstractModel = TrainUtil.train((EventStream)chunkerEventStream, trainingParameters.getSettings(), hashMap);
        return new ChunkerModel(string, abstractModel, hashMap, chunkerFactory);
    }

    public static ChunkerModel train(String string, ObjectStream<ChunkSample> objectStream, ChunkerContextGenerator chunkerContextGenerator, TrainingParameters trainingParameters) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        ChunkerEventStream chunkerEventStream = new ChunkerEventStream(objectStream, chunkerContextGenerator);
        AbstractModel abstractModel = TrainUtil.train((EventStream)chunkerEventStream, trainingParameters.getSettings(), hashMap);
        return new ChunkerModel(string, abstractModel, hashMap);
    }

    public static ChunkerModel train(String string, ObjectStream<ChunkSample> objectStream, int n, int n2, ChunkerContextGenerator chunkerContextGenerator) throws IOException {
        return ChunkerME.train(string, objectStream, chunkerContextGenerator, ModelUtil.createTrainingParameters(n2, n));
    }

    @Deprecated
    public static ChunkerModel train(String string, ObjectStream<ChunkSample> objectStream, int n, int n2) throws IOException, ObjectStreamException {
        return ChunkerME.train(string, objectStream, n, n2, new DefaultChunkerContextGenerator());
    }
}

