/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline;

import chalk.tools.cmdline.AbstractCmdLineTool;
import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.ObjectStreamFactory;
import chalk.tools.cmdline.StreamFactoryRegistry;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.TypedCmdLineTool;
import java.util.Map;

public abstract class AbstractTypedTool<T>
extends AbstractCmdLineTool
implements TypedCmdLineTool {
    protected final Class<T> type;

    protected AbstractTypedTool(Class<T> clazz) {
        this.type = clazz;
    }

    protected ObjectStreamFactory<T> getStreamFactory(String string) {
        ObjectStreamFactory<T> objectStreamFactory = StreamFactoryRegistry.getFactory(this.type, string);
        if (null != objectStreamFactory) {
            return objectStreamFactory;
        }
        throw new TerminateToolException(1, "Format " + string + " is not found.\n" + this.getHelp());
    }

    protected <A> void validateAllArgs(String[] stringArray, Class<A> clazz, String string) {
        ObjectStreamFactory<T> objectStreamFactory = this.getStreamFactory(string);
        String string2 = ArgumentParser.validateArgumentsLoudly(stringArray, clazz, objectStreamFactory.getParameters());
        if (null != string2) {
            throw new TerminateToolException(1, string2 + "\n" + this.getHelp(string));
        }
    }

    protected void validateFactoryArgs(ObjectStreamFactory<T> objectStreamFactory, String[] stringArray) {
        String string = ArgumentParser.validateArgumentsLoudly(stringArray, objectStreamFactory.getParameters());
        if (null != string) {
            throw new TerminateToolException(1, "Format parameters are invalid: " + string + "\n" + "Usage: " + ArgumentParser.createUsage(objectStreamFactory.getParameters()));
        }
    }

    protected <A> String getBasicHelp(Class<A> ... classArray) {
        Map<String, ObjectStreamFactory<T>> map = StreamFactoryRegistry.getFactories(this.type);
        String string = " ";
        if (1 < map.size()) {
            StringBuilder stringBuilder = new StringBuilder();
            for (String string2 : map.keySet()) {
                if ("opennlp".equals(string2)) continue;
                stringBuilder.append(".").append(string2).append("|");
            }
            string = "[" + stringBuilder.substring(0, stringBuilder.length() - 1) + "] ";
        }
        return "Usage: chalk " + this.getName() + string + ArgumentParser.createUsage(classArray);
    }

    @Override
    public String getHelp() {
        return this.getHelp("");
    }
}

