/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline;

import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import java.io.File;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class ArgumentParser {
    private static final Map<Class<?>, ArgumentFactory> argumentFactories;

    private ArgumentParser() {
    }

    private static <T> void checkProxyInterfaces(Class<T> ... classArray) {
        for (Class<T> clazz : classArray) {
            if (null == clazz) continue;
            if (!clazz.isInterface()) {
                throw new IllegalArgumentException("proxy interface is not an interface!");
            }
            Method[] methodArray = clazz.getMethods();
            if (methodArray.length == 0) {
                throw new IllegalArgumentException("proxy interface must at least declare one method!");
            }
            for (Method method : methodArray) {
                if (!method.getName().startsWith("get") && method.getName().length() > 3) {
                    throw new IllegalArgumentException(method.getName() + " method name does not start with 'get'!");
                }
                if (method.getParameterTypes().length != 0) {
                    throw new IllegalArgumentException(method.getName() + " method must have zero parameters but has " + method.getParameterTypes().length + "!");
                }
                Class<?> clazz2 = method.getReturnType();
                Set<Class<?>> set = argumentFactories.keySet();
                if (set.contains(clazz2)) continue;
                throw new IllegalArgumentException(method.getName() + " method must have compatible return type! Got " + clazz2 + ", expected one of " + set);
            }
        }
    }

    private static String methodNameToParameter(String string) {
        char[] cArray = string.toCharArray();
        cArray[3] = Character.toLowerCase(cArray[3]);
        String string2 = "-" + new String(cArray).substring(3);
        return string2;
    }

    public static <T> String createUsage(Class<T> clazz) {
        return ArgumentParser.createUsage(new Class[]{clazz});
    }

    public static <T> String createUsage(Class<T> ... classArray) {
        ArgumentParser.checkProxyInterfaces(classArray);
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder stringBuilder2 = new StringBuilder();
        for (Class<T> clazz : classArray) {
            if (null == clazz) continue;
            for (Method method : clazz.getMethods()) {
                ParameterDescription parameterDescription = method.getAnnotation(ParameterDescription.class);
                OptionalParameter optionalParameter = method.getAnnotation(OptionalParameter.class);
                if (parameterDescription == null) continue;
                String string = ArgumentParser.methodNameToParameter(method.getName());
                if (optionalParameter != null) {
                    stringBuilder.append('[');
                }
                stringBuilder.append(string).append(' ').append(parameterDescription.valueName());
                stringBuilder2.append('\t').append(string).append(' ').append(parameterDescription.valueName()).append('\n');
                if (parameterDescription.description() != null && parameterDescription.description().length() > 0) {
                    stringBuilder2.append("\t\t").append(parameterDescription.description()).append('\n');
                }
                if (optionalParameter != null) {
                    stringBuilder.append(']');
                }
                stringBuilder.append(' ');
            }
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        if (stringBuilder2.length() > 0) {
            stringBuilder2.setLength(stringBuilder2.length() - 1);
            stringBuilder.append("\n\nArguments description:\n").append(stringBuilder2.toString());
        }
        return stringBuilder.toString();
    }

    public static <T> boolean validateArguments(String[] stringArray, Class<T> clazz) {
        return ArgumentParser.validateArguments(stringArray, new Class[]{clazz});
    }

    public static <T> boolean validateArguments(String[] stringArray, Class<T> ... classArray) {
        return null == ArgumentParser.validateArgumentsLoudly(stringArray, classArray);
    }

    public static <T> String validateArgumentsLoudly(String[] stringArray, Class<T> clazz) {
        return ArgumentParser.validateArgumentsLoudly(stringArray, new Class[]{clazz});
    }

    public static <T> String validateArgumentsLoudly(String[] stringArray, Class<T> ... classArray) {
        if (stringArray.length % 2 != 0) {
            return "Number of parameters must be always be even";
        }
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(stringArray));
        for (Class<T> clazz : classArray) {
            for (Method method : clazz.getMethods()) {
                String string = ArgumentParser.methodNameToParameter(method.getName());
                int n2 = CmdLineUtil.getParameterIndex(string, stringArray);
                String string2 = CmdLineUtil.getParameter(string, stringArray);
                if (string2 == null) {
                    OptionalParameter optionalParameter = method.getAnnotation(OptionalParameter.class);
                    if (optionalParameter == null) {
                        if (-1 < n2) {
                            return "Missing mandatory parameter value: " + string;
                        }
                        return "Missing mandatory parameter: " + string;
                    }
                    arrayList.remove("-" + string);
                    continue;
                }
                arrayList.remove(string);
                arrayList.remove(string2);
                ++n;
            }
        }
        if (stringArray.length / 2 > n) {
            return "Unrecognized parameters encountered: " + ((Object)arrayList).toString();
        }
        return null;
    }

    public static <T> T parse(String[] stringArray, Class<T> clazz) {
        ArgumentParser.checkProxyInterfaces(clazz);
        if (!ArgumentParser.validateArguments(stringArray, clazz)) {
            throw new IllegalArgumentException("Passed args must be valid!");
        }
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        for (Method method : clazz.getMethods()) {
            Object object;
            Object object2;
            String string = ArgumentParser.methodNameToParameter(method.getName());
            String string2 = CmdLineUtil.getParameter(string, stringArray);
            if (string2 == null) {
                object2 = method.getAnnotation(OptionalParameter.class);
                string2 = object2.defaultValue().length() > 0 ? object2.defaultValue() : null;
            }
            object2 = method.getReturnType();
            if (string2 != null) {
                ArgumentFactory argumentFactory = argumentFactories.get(object2);
                if (argumentFactory == null) {
                    throw new IllegalStateException("factory for '" + object2 + "' must not be null");
                }
                object = argumentFactory.parseArgument(method, string, string2);
            } else {
                object = null;
            }
            hashMap.put(method.getName(), object);
        }
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)new ArgumentProxy(hashMap));
    }

    public static <T> String[] filter(String[] stringArray, Class<T> clazz) {
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        for (Method method : clazz.getMethods()) {
            String string = ArgumentParser.methodNameToParameter(method.getName());
            int n = CmdLineUtil.getParameterIndex(string, stringArray);
            if (-1 >= n) continue;
            arrayList.add(string);
            String string2 = CmdLineUtil.getParameter(string, stringArray);
            if (null == string2) continue;
            arrayList.add(string2);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    static {
        HashMap<Class<Charset>, ArgumentFactory> hashMap = new HashMap<Class<Charset>, ArgumentFactory>();
        hashMap.put(Integer.class, new IntegerArgumentFactory());
        hashMap.put(Boolean.class, new BooleanArgumentFactory());
        hashMap.put(String.class, new StringArgumentFactory());
        hashMap.put(File.class, new FileArgumentFactory());
        hashMap.put(Charset.class, new CharsetArgumentFactory());
        argumentFactories = Collections.unmodifiableMap(hashMap);
    }

    private static class ArgumentProxy
    implements InvocationHandler {
        private final Map<String, Object> arguments;

        ArgumentProxy(Map<String, Object> map) {
            this.arguments = map;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            if (objectArray != null) {
                throw new IllegalStateException();
            }
            return this.arguments.get(method.getName());
        }
    }

    private static class CharsetArgumentFactory
    implements ArgumentFactory {
        private CharsetArgumentFactory() {
        }

        @Override
        public Object parseArgument(Method method, String string, String string2) {
            try {
                if ("DEFAULT_CHARSET".equals(string2)) {
                    return Charset.defaultCharset();
                }
                if (Charset.isSupported(string2)) {
                    return Charset.forName(string2);
                }
                throw new TerminateToolException(1, String.format("Invalid argument: %s %s \n", string, string2) + "Encoding not supported on this platform.");
            }
            catch (IllegalCharsetNameException illegalCharsetNameException) {
                throw new TerminateToolException(1, String.format("Invalid argument: %s %s \n", string, string2) + "Illegal encoding name.");
            }
        }
    }

    private static class FileArgumentFactory
    implements ArgumentFactory {
        private FileArgumentFactory() {
        }

        @Override
        public Object parseArgument(Method method, String string, String string2) {
            return new File(string2);
        }
    }

    private static class StringArgumentFactory
    implements ArgumentFactory {
        private StringArgumentFactory() {
        }

        @Override
        public Object parseArgument(Method method, String string, String string2) {
            return string2;
        }
    }

    private static class BooleanArgumentFactory
    implements ArgumentFactory {
        private BooleanArgumentFactory() {
        }

        @Override
        public Object parseArgument(Method method, String string, String string2) {
            return Boolean.parseBoolean(string2);
        }
    }

    private static class IntegerArgumentFactory
    implements ArgumentFactory {
        private IntegerArgumentFactory() {
        }

        @Override
        public Object parseArgument(Method method, String string, String string2) {
            Integer n;
            try {
                n = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                throw new TerminateToolException(1, String.format("Invalid argument: %s %s \n", string, string2) + "Value must be an integer!", numberFormatException);
            }
            return n;
        }
    }

    private static interface ArgumentFactory {
        public static final String INVALID_ARG = "Invalid argument: %s %s \n";

        public Object parseArgument(Method var1, String var2, String var3);
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface ParameterDescription {
        public String valueName();

        public String description() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface OptionalParameter {
        public static final String DEFAULT_CHARSET = "DEFAULT_CHARSET";

        public String defaultValue() default "";
    }
}

