/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline;

import chalk.tools.cmdline.AbstractCmdLineTool;
import chalk.tools.cmdline.BasicCmdLineTool;
import chalk.tools.cmdline.CmdLineTool;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.TypedCmdLineTool;
import chalk.tools.cmdline.chunker.ChunkerConverterTool;
import chalk.tools.cmdline.chunker.ChunkerCrossValidatorTool;
import chalk.tools.cmdline.chunker.ChunkerEvaluatorTool;
import chalk.tools.cmdline.chunker.ChunkerMETool;
import chalk.tools.cmdline.chunker.ChunkerTrainerTool;
import chalk.tools.cmdline.coref.CoreferenceConverterTool;
import chalk.tools.cmdline.coref.CoreferencerTool;
import chalk.tools.cmdline.coref.CoreferencerTrainerTool;
import chalk.tools.cmdline.dictionary.DictionaryBuilderTool;
import chalk.tools.cmdline.doccat.DoccatConverterTool;
import chalk.tools.cmdline.doccat.DoccatTool;
import chalk.tools.cmdline.doccat.DoccatTrainerTool;
import chalk.tools.cmdline.namefind.CensusDictionaryCreatorTool;
import chalk.tools.cmdline.namefind.TokenNameFinderConverterTool;
import chalk.tools.cmdline.namefind.TokenNameFinderCrossValidatorTool;
import chalk.tools.cmdline.namefind.TokenNameFinderEvaluatorTool;
import chalk.tools.cmdline.namefind.TokenNameFinderTool;
import chalk.tools.cmdline.namefind.TokenNameFinderTrainerTool;
import chalk.tools.cmdline.parser.BuildModelUpdaterTool;
import chalk.tools.cmdline.parser.CheckModelUpdaterTool;
import chalk.tools.cmdline.parser.ParserConverterTool;
import chalk.tools.cmdline.parser.ParserTool;
import chalk.tools.cmdline.parser.ParserTrainerTool;
import chalk.tools.cmdline.parser.TaggerModelReplacerTool;
import chalk.tools.cmdline.postag.POSTaggerConverterTool;
import chalk.tools.cmdline.postag.POSTaggerCrossValidatorTool;
import chalk.tools.cmdline.postag.POSTaggerEvaluatorTool;
import chalk.tools.cmdline.postag.POSTaggerTool;
import chalk.tools.cmdline.postag.POSTaggerTrainerTool;
import chalk.tools.cmdline.sentdetect.SentenceDetectorConverterTool;
import chalk.tools.cmdline.sentdetect.SentenceDetectorCrossValidatorTool;
import chalk.tools.cmdline.sentdetect.SentenceDetectorEvaluatorTool;
import chalk.tools.cmdline.sentdetect.SentenceDetectorTool;
import chalk.tools.cmdline.sentdetect.SentenceDetectorTrainerTool;
import chalk.tools.cmdline.tokenizer.DictionaryDetokenizerTool;
import chalk.tools.cmdline.tokenizer.SimpleTokenizerTool;
import chalk.tools.cmdline.tokenizer.TokenizerConverterTool;
import chalk.tools.cmdline.tokenizer.TokenizerCrossValidatorTool;
import chalk.tools.cmdline.tokenizer.TokenizerMEEvaluatorTool;
import chalk.tools.cmdline.tokenizer.TokenizerMETool;
import chalk.tools.cmdline.tokenizer.TokenizerTrainerTool;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public final class CLI {
    public static final String CMD = "chalk";
    private static Map<String, CmdLineTool> toolLookupMap = new LinkedHashMap<String, CmdLineTool>();

    public static Set<String> getToolNames() {
        return toolLookupMap.keySet();
    }

    private static void usage() {
        System.out.println(CMD);
        System.out.println("Usage: chalk TOOL");
        System.out.println("where TOOL is one of:");
        int n = -1;
        for (String object : toolLookupMap.keySet()) {
            if (object.length() <= n) continue;
            n = object.length();
        }
        n += 4;
        for (CmdLineTool cmdLineTool : toolLookupMap.values()) {
            System.out.print("  " + cmdLineTool.getName());
            for (int i = 0; i < Math.abs(cmdLineTool.getName().length() - n); ++i) {
                System.out.print(" ");
            }
            System.out.println(cmdLineTool.getShortDescription());
        }
        System.out.println("All tools print help when invoked with help parameter");
        System.out.println("Example: opennlp SimpleTokenizer help");
    }

    public static void main(String[] stringArray) {
        block14: {
            if (stringArray.length == 0) {
                CLI.usage();
                System.exit(0);
            }
            String[] stringArray2 = new String[stringArray.length - 1];
            System.arraycopy(stringArray, 1, stringArray2, 0, stringArray2.length);
            String string = stringArray[0];
            String string2 = "opennlp";
            int n = string.indexOf(".");
            if (-1 < n) {
                string2 = string.substring(n + 1);
                string = string.substring(0, n);
            }
            CmdLineTool cmdLineTool = toolLookupMap.get(string);
            try {
                if (null == cmdLineTool) {
                    throw new TerminateToolException(1, "Tool " + string + " is not found.");
                }
                if (0 == stringArray2.length && cmdLineTool.hasParams() || 0 < stringArray2.length && "help".equals(stringArray2[0])) {
                    if (cmdLineTool instanceof TypedCmdLineTool) {
                        System.out.println(((TypedCmdLineTool)cmdLineTool).getHelp(string2));
                    } else if (cmdLineTool instanceof BasicCmdLineTool) {
                        System.out.println(cmdLineTool.getHelp());
                    }
                    System.exit(0);
                }
                if (cmdLineTool instanceof TypedCmdLineTool) {
                    ((TypedCmdLineTool)cmdLineTool).run(string2, stringArray2);
                    break block14;
                }
                if (cmdLineTool instanceof BasicCmdLineTool) {
                    if (-1 == n) {
                        ((BasicCmdLineTool)cmdLineTool).run(stringArray2);
                        break block14;
                    }
                    throw new TerminateToolException(1, "Tool " + string + " does not support formats.");
                }
                throw new TerminateToolException(1, "Tool " + string + " is not supported.");
            }
            catch (TerminateToolException terminateToolException) {
                if (terminateToolException.getMessage() != null) {
                    System.err.println(terminateToolException.getMessage());
                }
                if (terminateToolException.getCause() != null) {
                    System.err.println(terminateToolException.getCause().getMessage());
                    terminateToolException.getCause().printStackTrace(System.err);
                }
                System.exit(terminateToolException.getCode());
            }
        }
    }

    static {
        LinkedList<AbstractCmdLineTool> linkedList = new LinkedList<AbstractCmdLineTool>();
        linkedList.add(new DoccatTool());
        linkedList.add(new DoccatTrainerTool());
        linkedList.add(new DoccatConverterTool());
        linkedList.add(new DictionaryBuilderTool());
        linkedList.add(new SimpleTokenizerTool());
        linkedList.add(new TokenizerMETool());
        linkedList.add(new TokenizerTrainerTool());
        linkedList.add(new TokenizerMEEvaluatorTool());
        linkedList.add(new TokenizerCrossValidatorTool());
        linkedList.add(new TokenizerConverterTool());
        linkedList.add(new DictionaryDetokenizerTool());
        linkedList.add(new SentenceDetectorTool());
        linkedList.add(new SentenceDetectorTrainerTool());
        linkedList.add(new SentenceDetectorEvaluatorTool());
        linkedList.add(new SentenceDetectorCrossValidatorTool());
        linkedList.add(new SentenceDetectorConverterTool());
        linkedList.add(new TokenNameFinderTool());
        linkedList.add(new TokenNameFinderTrainerTool());
        linkedList.add(new TokenNameFinderEvaluatorTool());
        linkedList.add(new TokenNameFinderCrossValidatorTool());
        linkedList.add(new TokenNameFinderConverterTool());
        linkedList.add(new CensusDictionaryCreatorTool());
        linkedList.add(new POSTaggerTool());
        linkedList.add(new POSTaggerTrainerTool());
        linkedList.add(new POSTaggerEvaluatorTool());
        linkedList.add(new POSTaggerCrossValidatorTool());
        linkedList.add(new POSTaggerConverterTool());
        linkedList.add(new ChunkerMETool());
        linkedList.add(new ChunkerTrainerTool());
        linkedList.add(new ChunkerEvaluatorTool());
        linkedList.add(new ChunkerCrossValidatorTool());
        linkedList.add(new ChunkerConverterTool());
        linkedList.add(new ParserTool());
        linkedList.add(new ParserTrainerTool());
        linkedList.add(new ParserConverterTool());
        linkedList.add(new BuildModelUpdaterTool());
        linkedList.add(new CheckModelUpdaterTool());
        linkedList.add(new TaggerModelReplacerTool());
        linkedList.add(new CoreferencerTool());
        linkedList.add(new CoreferencerTrainerTool());
        linkedList.add(new CoreferenceConverterTool());
        for (CmdLineTool cmdLineTool : linkedList) {
            toolLookupMap.put(cmdLineTool.getName(), cmdLineTool);
        }
        toolLookupMap = Collections.unmodifiableMap(toolLookupMap);
    }
}

