/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline;

import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.util.TrainingParameters;
import chalk.tools.util.model.BaseModel;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import nak.model.TrainUtil;

public final class CmdLineUtil {
    static final int IO_BUFFER_SIZE = 0x100000;

    private CmdLineUtil() {
    }

    public static void checkInputFile(String string, File file) {
        String string2 = null;
        if (file.isDirectory()) {
            string2 = "The " + string + " file is a directory!";
        } else if (!file.exists()) {
            string2 = "The " + string + " file does not exist!";
        } else if (!file.canRead()) {
            string2 = "No permissions to read the " + string + " file!";
        }
        if (null != string2) {
            throw new TerminateToolException(-1, string2 + " Path: " + file.getAbsolutePath());
        }
    }

    public static void checkOutputFile(String string, File file) {
        String string2 = null;
        if (file.exists()) {
            if (file.isDirectory()) {
                string2 = "The " + string + " file is a directory!";
            } else if (file.isFile()) {
                if (!file.canWrite()) {
                    string2 = "No permissions to write the " + string + " file!";
                }
            } else {
                string2 = "The " + string + " file is not a normal file!";
            }
        } else {
            File file2 = file.getAbsoluteFile().getParentFile();
            if (file2 != null && file2.exists()) {
                if (!file2.canWrite()) {
                    string2 = "No permissions to create the " + string + " file!";
                }
            } else {
                string2 = "The parent directory of the " + string + " file does not exist, " + "please create it first!";
            }
        }
        if (null != string2) {
            throw new TerminateToolException(-1, string2 + " Path: " + file.getAbsolutePath());
        }
    }

    public static FileInputStream openInFile(File file) {
        try {
            return new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TerminateToolException(-1, "File '" + file + "' cannot be found", fileNotFoundException);
        }
    }

    public static void writeModel(String string, File file, BaseModel baseModel) {
        CmdLineUtil.checkOutputFile(string + " model", file);
        System.err.print("Writing " + string + " model ... ");
        long l = System.currentTimeMillis();
        OutputStream outputStream = null;
        try {
            outputStream = new BufferedOutputStream(new FileOutputStream(file), 0x100000);
            baseModel.serialize(outputStream);
        }
        catch (IOException iOException) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "Error during writing model file '" + file + "'", iOException);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {
                    System.err.println("Failed to properly close model file '" + file + "': " + iOException.getMessage());
                }
            }
        }
        long l2 = System.currentTimeMillis() - l;
        System.err.printf("done (%.3fs)\n", (double)l2 / 1000.0);
        System.err.println();
        System.err.println("Wrote " + string + " model to");
        System.err.println("path: " + file.getAbsolutePath());
        System.err.println();
    }

    public static int getParameterIndex(String string, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].startsWith("-") || !stringArray[i].equals(string)) continue;
            return i;
        }
        return -1;
    }

    public static String getParameter(String string, String[] stringArray) {
        int n = CmdLineUtil.getParameterIndex(string, stringArray);
        if (-1 < n && ++n < stringArray.length) {
            return stringArray[n];
        }
        return null;
    }

    public static Integer getIntParameter(String string, String[] stringArray) {
        String string2 = CmdLineUtil.getParameter(string, stringArray);
        try {
            if (string2 != null) {
                return Integer.parseInt(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static Double getDoubleParameter(String string, String[] stringArray) {
        String string2 = CmdLineUtil.getParameter(string, stringArray);
        try {
            if (string2 != null) {
                return Double.parseDouble(string2);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return null;
    }

    public static void checkLanguageCode(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(Arrays.asList(Locale.getISOLanguages()));
        arrayList.add("x-unspecified");
        if (!arrayList.contains(string)) {
            throw new TerminateToolException(1, "Unknown language code " + string + ", " + "must be an ISO 639 code!");
        }
    }

    public static boolean containsParam(String string, String[] stringArray) {
        for (String string2 : stringArray) {
            if (!string2.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static void handleStdinIoError(IOException iOException) {
        throw new TerminateToolException(-1, "IO Error while reading from stdin: " + iOException.getMessage(), iOException);
    }

    public static TrainingParameters loadTrainingParameters(String string, boolean bl) {
        TrainingParameters trainingParameters = null;
        if (string != null) {
            CmdLineUtil.checkInputFile("Training Parameter", new File(string));
            InputStream inputStream = null;
            try {
                inputStream = new FileInputStream(new File(string));
                trainingParameters = new TrainingParameters(inputStream);
            }
            catch (IOException iOException) {
                throw new TerminateToolException(-1, "Error during parameters loading: " + iOException.getMessage(), iOException);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {}
            }
            if (!TrainUtil.isValid(trainingParameters.getSettings())) {
                throw new TerminateToolException(1, "Training parameters file '" + string + "' is invalid!");
            }
            if (!bl && TrainUtil.isSequenceTraining(trainingParameters.getSettings())) {
                throw new TerminateToolException(1, "Sequence training is not supported!");
            }
        }
        return trainingParameters;
    }
}

