/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline;

import chalk.tools.util.Span;
import chalk.tools.util.eval.EvaluationMonitor;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;

public abstract class DetailedFMeasureListener<T>
implements EvaluationMonitor<T> {
    private int samples = 0;
    private Stats generalStats = new Stats();
    private Map<String, Stats> statsForOutcome = new HashMap<String, Stats>();
    private static final String PERCENT = "% 7.2f%%";
    private static final String FORMAT = "%12s: precision: % 7.2f%%;  recall: % 7.2f%%; F1: % 7.2f%%.";
    private static final String FORMAT_EXTRA = "%12s: precision: % 7.2f%%;  recall: % 7.2f%%; F1: % 7.2f%%. [target: %3d; tp: %3d; fp: %3d]";

    protected abstract Span[] asSpanArray(T var1);

    @Override
    public void correctlyClassified(T t, T t2) {
        Span[] spanArray;
        ++this.samples;
        for (Span span : spanArray = this.asSpanArray(t)) {
            this.addTruePositive(span.getType());
        }
    }

    @Override
    public void missclassified(T t, T t2) {
        ++this.samples;
        Span[] spanArray = this.asSpanArray(t);
        Span[] spanArray2 = this.asSpanArray(t2);
        HashSet<Span> hashSet = new HashSet<Span>(Arrays.asList(spanArray));
        HashSet<Span> hashSet2 = new HashSet<Span>(Arrays.asList(spanArray2));
        for (Span span : hashSet) {
            if (hashSet2.contains(span)) {
                this.addTruePositive(span.getType());
                continue;
            }
            this.addFalseNegative(span.getType());
        }
        for (Span span : hashSet2) {
            if (hashSet.contains(span)) continue;
            this.addFalsePositive(span.getType());
        }
    }

    private void addTruePositive(String string) {
        Stats stats = this.initStatsForOutcomeAndGet(string);
        stats.incrementTruePositive();
        stats.incrementTarget();
        this.generalStats.incrementTruePositive();
        this.generalStats.incrementTarget();
    }

    private void addFalsePositive(String string) {
        Stats stats = this.initStatsForOutcomeAndGet(string);
        stats.incrementFalsePositive();
        this.generalStats.incrementFalsePositive();
    }

    private void addFalseNegative(String string) {
        Stats stats = this.initStatsForOutcomeAndGet(string);
        stats.incrementTarget();
        this.generalStats.incrementTarget();
    }

    private Stats initStatsForOutcomeAndGet(String string) {
        if (!this.statsForOutcome.containsKey(string)) {
            this.statsForOutcome.put(string, new Stats());
        }
        return this.statsForOutcome.get(string);
    }

    public String createReport() {
        return this.createReport(Locale.getDefault());
    }

    public String createReport(Locale locale) {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.generalStats.getTruePositives();
        int n2 = this.generalStats.getFalsePositives() + n;
        stringBuilder.append("Evaluated " + this.samples + " samples with " + this.generalStats.getTarget() + " entities; found: " + n2 + " entities; correct: " + n + ".\n");
        stringBuilder.append(String.format(locale, FORMAT, "TOTAL", this.zeroOrPositive(this.generalStats.getPrecisionScore() * 100.0), this.zeroOrPositive(this.generalStats.getRecallScore() * 100.0), this.zeroOrPositive(this.generalStats.getFMeasure() * 100.0)));
        stringBuilder.append("\n");
        TreeSet<String> treeSet = new TreeSet<String>(new F1Comparator());
        treeSet.addAll(this.statsForOutcome.keySet());
        for (String string : treeSet) {
            stringBuilder.append(String.format(locale, FORMAT_EXTRA, string, this.zeroOrPositive(this.statsForOutcome.get(string).getPrecisionScore() * 100.0), this.zeroOrPositive(this.statsForOutcome.get(string).getRecallScore() * 100.0), this.zeroOrPositive(this.statsForOutcome.get(string).getFMeasure() * 100.0), this.statsForOutcome.get(string).getTarget(), this.statsForOutcome.get(string).getTruePositives(), this.statsForOutcome.get(string).getFalsePositives()));
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    public String toString() {
        return this.createReport();
    }

    private double zeroOrPositive(double d) {
        if (d < 0.0) {
            return 0.0;
        }
        return d;
    }

    private class Stats {
        private int falsePositiveCounter = 0;
        private int truePositiveCounter = 0;
        private int targetCounter = 0;

        private Stats() {
        }

        public void incrementFalsePositive() {
            ++this.falsePositiveCounter;
        }

        public void incrementTruePositive() {
            ++this.truePositiveCounter;
        }

        public void incrementTarget() {
            ++this.targetCounter;
        }

        public int getFalsePositives() {
            return this.falsePositiveCounter;
        }

        public int getTruePositives() {
            return this.truePositiveCounter;
        }

        public int getTarget() {
            return this.targetCounter;
        }

        public double getPrecisionScore() {
            int n = this.getTruePositives();
            int n2 = n + this.getFalsePositives();
            return n2 > 0 ? (double)n / (double)n2 : 0.0;
        }

        public double getRecallScore() {
            int n = this.getTarget();
            int n2 = this.getTruePositives();
            return n > 0 ? (double)n2 / (double)n : 0.0;
        }

        public double getFMeasure() {
            if (this.getPrecisionScore() + this.getRecallScore() > 0.0) {
                return 2.0 * (this.getPrecisionScore() * this.getRecallScore()) / (this.getPrecisionScore() + this.getRecallScore());
            }
            return -1.0;
        }
    }

    private class F1Comparator
    implements Comparator<String> {
        private F1Comparator() {
        }

        @Override
        public int compare(String string, String string2) {
            if (string.equals(string2)) {
                return 0;
            }
            double d = 0.0;
            double d2 = 0.0;
            if (DetailedFMeasureListener.this.statsForOutcome.containsKey(string)) {
                d += ((Stats)DetailedFMeasureListener.this.statsForOutcome.get(string)).getFMeasure();
            }
            if (DetailedFMeasureListener.this.statsForOutcome.containsKey(string2)) {
                d2 += ((Stats)DetailedFMeasureListener.this.statsForOutcome.get(string2)).getFMeasure();
            }
            if ((d = DetailedFMeasureListener.this.zeroOrPositive(d)) + (d2 = DetailedFMeasureListener.this.zeroOrPositive(d2)) > 0.0) {
                if (d > d2) {
                    return -1;
                }
                return 1;
            }
            return string.compareTo(string2);
        }
    }
}

