/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline;

import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.util.InvalidFormatException;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public abstract class ModelLoader<T> {
    private final String modelName;

    protected ModelLoader(String string) {
        if (string == null) {
            throw new IllegalArgumentException("modelName must not be null!");
        }
        this.modelName = string;
    }

    protected abstract T loadModel(InputStream var1) throws IOException, InvalidFormatException;

    public T load(File file) {
        T t;
        long l = System.currentTimeMillis();
        CmdLineUtil.checkInputFile(this.modelName + " model", file);
        System.err.print("Loading " + this.modelName + " model ... ");
        BufferedInputStream bufferedInputStream = new BufferedInputStream(CmdLineUtil.openInFile(file), 0x100000);
        try {
            t = this.loadModel(bufferedInputStream);
        }
        catch (InvalidFormatException invalidFormatException) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "Model has invalid format", invalidFormatException);
        }
        catch (IOException iOException) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while loading model file '" + file + "'", iOException);
        }
        finally {
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {}
        }
        long l2 = System.currentTimeMillis() - l;
        System.err.printf("done (%.3fs)\n", (double)l2 / 1000.0);
        return t;
    }
}

