/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline;

import java.io.PrintStream;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class PerformanceMonitor {
    private ScheduledExecutorService scheduler = Executors.newScheduledThreadPool(1);
    private final String unit;
    private ScheduledFuture<?> beeperHandle;
    private volatile long startTime = -1L;
    private volatile int counter;
    private final PrintStream out;

    public PerformanceMonitor(PrintStream printStream, String string) {
        this.out = printStream;
        this.unit = string;
    }

    public PerformanceMonitor(String string) {
        this(System.out, string);
    }

    public boolean isStarted() {
        return this.startTime != -1L;
    }

    public void incrementCounter(int n) {
        if (!this.isStarted()) {
            throw new IllegalStateException("Must be started first!");
        }
        if (n < 0) {
            throw new IllegalArgumentException("increment must be zero or positive but was " + n + "!");
        }
        this.counter += n;
    }

    public void incrementCounter() {
        this.incrementCounter(1);
    }

    public void start() {
        if (this.isStarted()) {
            throw new IllegalStateException("Already started!");
        }
        this.startTime = System.currentTimeMillis();
    }

    public void startAndPrintThroughput() {
        this.start();
        Runnable runnable = new Runnable(){
            private long lastTimeStamp;
            private int lastCount;
            {
                this.lastTimeStamp = PerformanceMonitor.this.startTime;
                this.lastCount = PerformanceMonitor.this.counter;
            }

            @Override
            public void run() {
                int n = PerformanceMonitor.this.counter - this.lastCount;
                long l = System.currentTimeMillis() - this.lastTimeStamp;
                double d = l > 0L ? (double)n / ((double)l / 1000.0) : 0.0;
                long l2 = System.currentTimeMillis() - PerformanceMonitor.this.startTime;
                double d2 = l2 > 0L ? (double)PerformanceMonitor.this.counter / ((double)l2 / 1000.0) : 0.0;
                PerformanceMonitor.this.out.printf("current: %.1f " + PerformanceMonitor.this.unit + "/s avg: %.1f " + PerformanceMonitor.this.unit + "/s total: %d " + PerformanceMonitor.this.unit + "%n", d, d2, PerformanceMonitor.this.counter);
                this.lastTimeStamp = System.currentTimeMillis();
                this.lastCount = PerformanceMonitor.this.counter;
            }
        };
        this.beeperHandle = this.scheduler.scheduleAtFixedRate(runnable, 1L, 1L, TimeUnit.SECONDS);
    }

    public void stopAndPrintFinalResult() {
        if (!this.isStarted()) {
            throw new IllegalStateException("Must be started first!");
        }
        if (this.beeperHandle != null) {
            this.beeperHandle.cancel(false);
        }
        this.scheduler.shutdown();
        long l = System.currentTimeMillis() - this.startTime;
        double d = l > 0L ? (double)this.counter / ((double)l / 1000.0) : 0.0;
        this.out.println();
        this.out.println();
        this.out.printf("Average: %.1f " + this.unit + "/s %n", d);
        this.out.println("Total: " + this.counter + " " + this.unit);
        this.out.println("Runtime: " + (double)l / 1000.0 + "s");
    }
}

