/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.chunker;

import chalk.tools.chunker.ChunkSample;
import chalk.tools.chunker.ChunkerEvaluationMonitor;
import chalk.tools.chunker.ChunkerEvaluator;
import chalk.tools.chunker.ChunkerME;
import chalk.tools.chunker.ChunkerModel;
import chalk.tools.cmdline.AbstractEvaluatorTool;
import chalk.tools.cmdline.PerformanceMonitor;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.chunker.ChunkEvaluationErrorListener;
import chalk.tools.cmdline.chunker.ChunkerDetailedFMeasureListener;
import chalk.tools.cmdline.chunker.ChunkerModelLoader;
import chalk.tools.cmdline.params.DetailedFMeasureEvaluatorParams;
import chalk.tools.cmdline.params.EvaluatorParams;
import chalk.tools.util.ObjectStream;
import java.io.IOException;
import java.util.LinkedList;

public final class ChunkerEvaluatorTool
extends AbstractEvaluatorTool<ChunkSample, EvalToolParams> {
    public ChunkerEvaluatorTool() {
        super(ChunkSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the Chunker model with the reference data";
    }

    @Override
    public void run(String string, String[] stringArray) {
        super.run(string, stringArray);
        ChunkerModel chunkerModel = (ChunkerModel)new ChunkerModelLoader().load(((EvalToolParams)this.params).getModel());
        LinkedList<ChunkerEvaluationMonitor> linkedList = new LinkedList<ChunkerEvaluationMonitor>();
        ChunkerDetailedFMeasureListener chunkerDetailedFMeasureListener = null;
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            linkedList.add(new ChunkEvaluationErrorListener());
        }
        if (((EvalToolParams)this.params).getDetailedF().booleanValue()) {
            chunkerDetailedFMeasureListener = new ChunkerDetailedFMeasureListener();
            linkedList.add(chunkerDetailedFMeasureListener);
        }
        ChunkerEvaluator chunkerEvaluator = new ChunkerEvaluator(new ChunkerME(chunkerModel, 10), linkedList.toArray(new ChunkerEvaluationMonitor[linkedList.size()]));
        final PerformanceMonitor performanceMonitor = new PerformanceMonitor("sent");
        ObjectStream<ChunkSample> objectStream = new ObjectStream<ChunkSample>(){

            @Override
            public ChunkSample read() throws IOException {
                performanceMonitor.incrementCounter();
                return (ChunkSample)ChunkerEvaluatorTool.this.sampleStream.read();
            }

            @Override
            public void reset() throws IOException {
                ChunkerEvaluatorTool.this.sampleStream.reset();
            }

            @Override
            public void close() throws IOException {
                ChunkerEvaluatorTool.this.sampleStream.close();
            }
        };
        performanceMonitor.startAndPrintThroughput();
        try {
            chunkerEvaluator.evaluate(objectStream);
        }
        catch (IOException iOException) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while reading test data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                objectStream.close();
            }
            catch (IOException iOException) {}
        }
        performanceMonitor.stopAndPrintFinalResult();
        System.out.println();
        if (chunkerDetailedFMeasureListener == null) {
            System.out.println(chunkerEvaluator.getFMeasure());
        } else {
            System.out.println(chunkerDetailedFMeasureListener.toString());
        }
    }

    static interface EvalToolParams
    extends EvaluatorParams,
    DetailedFMeasureEvaluatorParams {
    }
}

