/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.chunker;

import chalk.tools.chunker.ChunkSample;
import chalk.tools.chunker.ChunkerME;
import chalk.tools.chunker.ChunkerModel;
import chalk.tools.cmdline.AbstractBasicCmdLineTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.PerformanceMonitor;
import chalk.tools.cmdline.chunker.ChunkerModelLoader;
import chalk.tools.postag.POSSample;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.PlainTextByLineStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class ChunkerMETool
extends AbstractBasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "learnable chunker";
    }

    @Override
    public String getHelp() {
        return "Usage: chalk " + this.getName() + " model < sentences";
    }

    @Override
    public void run(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println(this.getHelp());
        } else {
            ChunkerModel chunkerModel = (ChunkerModel)new ChunkerModelLoader().load(new File(stringArray[0]));
            ChunkerME chunkerME = new ChunkerME(chunkerModel, 10);
            PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
            PerformanceMonitor performanceMonitor = new PerformanceMonitor(System.err, "sent");
            performanceMonitor.start();
            try {
                String string;
                while ((string = (String)plainTextByLineStream.read()) != null) {
                    POSSample pOSSample;
                    try {
                        pOSSample = POSSample.parse(string);
                    }
                    catch (InvalidFormatException invalidFormatException) {
                        System.err.println("Invalid format:");
                        System.err.println(string);
                        continue;
                    }
                    String[] stringArray2 = chunkerME.chunk(pOSSample.getSentence(), pOSSample.getTags());
                    System.out.println(new ChunkSample(pOSSample.getSentence(), pOSSample.getTags(), stringArray2).nicePrint());
                    performanceMonitor.incrementCounter();
                }
            }
            catch (IOException iOException) {
                CmdLineUtil.handleStdinIoError(iOException);
            }
            performanceMonitor.stopAndPrintFinalResult();
        }
    }
}

