/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.coref;

import chalk.tools.cmdline.AbstractBasicCmdLineTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.PerformanceMonitor;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.LinkerMode;
import chalk.tools.coref.mention.DefaultParse;
import chalk.tools.coref.mention.Mention;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.lang.english.TreebankLinker;
import chalk.tools.parser.Parse;
import chalk.tools.util.PlainTextByLineStream;
import chalk.tools.util.Span;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CoreferencerTool
extends AbstractBasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "learnable noun phrase coreferencer";
    }

    @Override
    public void run(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println(this.getHelp());
        } else {
            TreebankLinker treebankLinker;
            try {
                treebankLinker = new TreebankLinker(stringArray[0], LinkerMode.TEST);
            }
            catch (IOException iOException) {
                throw new TerminateToolException(-1, "Failed to load all coreferencer models!", iOException);
            }
            PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
            PerformanceMonitor performanceMonitor = new PerformanceMonitor(System.err, "parses");
            performanceMonitor.start();
            try {
                String string;
                int n = 0;
                ArrayList<Mention> arrayList = new ArrayList<Mention>();
                ArrayList<Parse> arrayList2 = new ArrayList<Parse>();
                while ((string = (String)plainTextByLineStream.read()) != null) {
                    DiscourseEntity[] discourseEntityArray;
                    if (string.equals("")) {
                        discourseEntityArray = treebankLinker.getEntities(arrayList.toArray(new Mention[arrayList.size()]));
                        new CorefParse(arrayList2, discourseEntityArray).show();
                        n = 0;
                        arrayList.clear();
                        arrayList2.clear();
                    } else {
                        discourseEntityArray = Parse.parseParse(string);
                        arrayList2.add((Parse)discourseEntityArray);
                        Mention[] mentionArray = treebankLinker.getMentionFinder().getMentions(new DefaultParse((Parse)discourseEntityArray, n));
                        int n2 = mentionArray.length;
                        for (int i = 0; i < n2; ++i) {
                            if (mentionArray[i].getParse() != null) continue;
                            Parse parse = new Parse(discourseEntityArray.getText(), mentionArray[i].getSpan(), "NML", 1.0, 0);
                            discourseEntityArray.insert(parse);
                            mentionArray[i].setParse(new DefaultParse(parse, n));
                        }
                        arrayList.addAll(Arrays.asList(mentionArray));
                        ++n;
                    }
                    performanceMonitor.incrementCounter();
                }
            }
            catch (IOException iOException) {
                CmdLineUtil.handleStdinIoError(iOException);
            }
            performanceMonitor.stopAndPrintFinalResult();
        }
    }

    @Override
    public String getHelp() {
        return "Usage: chalk " + this.getName() + " model_directory < parses";
    }

    class CorefParse {
        private Map<Parse, Integer> parseMap;
        private List<Parse> parses;

        public CorefParse(List<Parse> list, DiscourseEntity[] discourseEntityArray) {
            this.parses = list;
            this.parseMap = new HashMap<Parse, Integer>();
            int n = discourseEntityArray.length;
            for (int i = 0; i < n; ++i) {
                if (discourseEntityArray[i].getNumMentions() <= 1) continue;
                Iterator<MentionContext> iterator = discourseEntityArray[i].getMentions();
                while (iterator.hasNext()) {
                    MentionContext mentionContext = iterator.next();
                    Parse parse = ((DefaultParse)mentionContext.getParse()).getParse();
                    this.parseMap.put(parse, i + 1);
                }
            }
        }

        public void show() {
            int n = this.parses.size();
            for (int i = 0; i < n; ++i) {
                Parse parse = this.parses.get(i);
                this.show(parse);
                System.out.println();
            }
        }

        private void show(Parse parse) {
            int n = parse.getSpan().getStart();
            if (!parse.getType().equals("TK")) {
                System.out.print("(");
                System.out.print(parse.getType());
                if (this.parseMap.containsKey(parse)) {
                    System.out.print("#" + this.parseMap.get(parse));
                }
                System.out.print(" ");
            }
            for (Parse parse2 : parse.getChildren()) {
                Span span = parse2.getSpan();
                if (n < span.getStart()) {
                    System.out.print(parse.getText().substring(n, span.getStart()));
                }
                this.show(parse2);
                n = span.getEnd();
            }
            System.out.print(parse.getText().substring(n, parse.getSpan().getEnd()));
            if (!parse.getType().equals("TK")) {
                System.out.print(")");
            }
        }
    }
}

