/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.dictionary;

import chalk.tools.cmdline.AbstractBasicCmdLineTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.dictionary.DictionaryBuilderParams;
import chalk.tools.dictionary.Dictionary;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class DictionaryBuilderTool
extends AbstractBasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "builds a new dictionary";
    }

    @Override
    public String getHelp() {
        return this.getBasicHelp(Params.class);
    }

    @Override
    public void run(String[] stringArray) {
        Params params = this.validateAndParseParams(stringArray, Params.class);
        File file = params.getInputFile();
        File file2 = params.getOutputFile();
        Charset charset = params.getEncoding();
        CmdLineUtil.checkInputFile("dictionary input file", file);
        CmdLineUtil.checkOutputFile("dictionary output file", file2);
        InputStreamReader inputStreamReader = null;
        OutputStream outputStream = null;
        try {
            inputStreamReader = new InputStreamReader((InputStream)new FileInputStream(file), charset);
            outputStream = new FileOutputStream(file2);
            Dictionary dictionary = Dictionary.parseOneEntryPerLine(inputStreamReader);
            dictionary.serialize(outputStream);
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                inputStreamReader.close();
                outputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    static interface Params
    extends DictionaryBuilderParams {
    }
}

