/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.doccat;

import chalk.tools.cmdline.AbstractBasicCmdLineTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.PerformanceMonitor;
import chalk.tools.cmdline.doccat.DoccatModelLoader;
import chalk.tools.doccat.DoccatModel;
import chalk.tools.doccat.DocumentCategorizerME;
import chalk.tools.doccat.DocumentSample;
import chalk.tools.util.ParagraphStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public class DoccatTool
extends AbstractBasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "learnable document categorizer";
    }

    @Override
    public String getHelp() {
        return "Usage: chalk " + this.getName() + " model < documents";
    }

    @Override
    public void run(String[] stringArray) {
        if (0 == stringArray.length) {
            System.out.println(this.getHelp());
        } else {
            DoccatModel doccatModel = (DoccatModel)new DoccatModelLoader().load(new File(stringArray[0]));
            DocumentCategorizerME documentCategorizerME = new DocumentCategorizerME(doccatModel);
            ParagraphStream paragraphStream = new ParagraphStream(new PlainTextByLineStream(new InputStreamReader(System.in)));
            PerformanceMonitor performanceMonitor = new PerformanceMonitor(System.err, "doc");
            performanceMonitor.start();
            try {
                String string;
                while ((string = (String)paragraphStream.read()) != null) {
                    double[] dArray = documentCategorizerME.categorize(string);
                    String string2 = documentCategorizerME.getBestCategory(dArray);
                    DocumentSample documentSample = new DocumentSample(string2, string);
                    System.out.println(documentSample.toString());
                    performanceMonitor.incrementCounter();
                }
            }
            catch (IOException iOException) {
                CmdLineUtil.handleStdinIoError(iOException);
            }
            performanceMonitor.stopAndPrintFinalResult();
        }
    }
}

