/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.doccat;

import chalk.tools.cmdline.AbstractTrainerTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.doccat.TrainingParams;
import chalk.tools.cmdline.params.TrainingToolParams;
import chalk.tools.doccat.DoccatModel;
import chalk.tools.doccat.DocumentCategorizerME;
import chalk.tools.doccat.DocumentSample;
import chalk.tools.doccat.FeatureGenerator;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.model.ModelUtil;
import java.io.File;
import java.io.IOException;

public class DoccatTrainerTool
extends AbstractTrainerTool<DocumentSample, TrainerToolParams> {
    public DoccatTrainerTool() {
        super(DocumentSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable document categorizer";
    }

    @Override
    public void run(String string, String[] stringArray) {
        DoccatModel doccatModel;
        super.run(string, stringArray);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((TrainerToolParams)this.params).getIterations(), ((TrainerToolParams)this.params).getCutoff());
        }
        File file = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("document categorizer model", file);
        try {
            doccatModel = DocumentCategorizerME.train(this.factory.getLang(), (ObjectStream<DocumentSample>)this.sampleStream, this.mlParams, new FeatureGenerator[0]);
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("document categorizer", file, doccatModel);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

