/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.namefind;

import chalk.tools.cmdline.AbstractBasicCmdLineTool;
import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.dictionary.Dictionary;
import chalk.tools.formats.NameFinderCensus90NameStream;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.StringList;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class CensusDictionaryCreatorTool
extends AbstractBasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "Converts 1990 US Census names into a dictionary";
    }

    @Override
    public String getHelp() {
        return this.getBasicHelp(Parameters.class);
    }

    public static Dictionary createDictionary(ObjectStream<StringList> objectStream) throws IOException {
        Dictionary dictionary = new Dictionary(true);
        StringList stringList = objectStream.read();
        while (stringList != null) {
            if (!dictionary.contains(stringList)) {
                dictionary.put(stringList);
            }
            stringList = objectStream.read();
        }
        return dictionary;
    }

    @Override
    public void run(String[] stringArray) {
        Dictionary dictionary;
        Parameters parameters = this.validateAndParseParams(stringArray, Parameters.class);
        File file = new File(parameters.getCensusData());
        File file2 = new File(parameters.getDict());
        CmdLineUtil.checkInputFile("Name data", file);
        CmdLineUtil.checkOutputFile("Dictionary file", file2);
        FileInputStream fileInputStream = CmdLineUtil.openInFile(file);
        NameFinderCensus90NameStream nameFinderCensus90NameStream = new NameFinderCensus90NameStream(fileInputStream, Charset.forName(parameters.getEncoding()));
        try {
            System.out.println("Creating Dictionary...");
            dictionary = CensusDictionaryCreatorTool.createDictionary(nameFinderCensus90NameStream);
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                nameFinderCensus90NameStream.close();
            }
            catch (IOException iOException) {}
        }
        System.out.println("Saving Dictionary...");
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(file2);
            dictionary.serialize(fileOutputStream);
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while writing dictionary file: " + iOException.getMessage(), iOException);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    ((OutputStream)fileOutputStream).close();
                }
                catch (IOException iOException) {
                    throw new TerminateToolException(-1, "Attention: Failed to correctly write dictionary:" + iOException.getMessage(), iOException);
                }
            }
        }
    }

    static interface Parameters {
        @ArgumentParser.ParameterDescription(valueName="code")
        @ArgumentParser.OptionalParameter(defaultValue="en")
        public String getLang();

        @ArgumentParser.ParameterDescription(valueName="charsetName")
        @ArgumentParser.OptionalParameter(defaultValue="UTF-8")
        public String getEncoding();

        @ArgumentParser.ParameterDescription(valueName="censusDict")
        public String getCensusData();

        @ArgumentParser.ParameterDescription(valueName="dict")
        public String getDict();
    }
}

