/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.namefind;

import chalk.tools.cmdline.AbstractBasicCmdLineTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.PerformanceMonitor;
import chalk.tools.cmdline.namefind.TokenNameFinderModelLoader;
import chalk.tools.namefind.NameFinderME;
import chalk.tools.namefind.NameSample;
import chalk.tools.namefind.TokenNameFinderModel;
import chalk.tools.tokenize.WhitespaceTokenizer;
import chalk.tools.util.PlainTextByLineStream;
import chalk.tools.util.Span;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;

public final class TokenNameFinderTool
extends AbstractBasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "learnable name finder";
    }

    @Override
    public String getHelp() {
        return "Usage: chalk " + this.getName() + " model1 model2 ... modelN < sentences";
    }

    @Override
    public void run(String[] stringArray) {
        if (stringArray.length == 0) {
            System.out.println(this.getHelp());
        } else {
            Object object;
            NameFinderME[] nameFinderMEArray = new NameFinderME[stringArray.length];
            for (int i = 0; i < nameFinderMEArray.length; ++i) {
                object = (TokenNameFinderModel)new TokenNameFinderModelLoader().load(new File(stringArray[i]));
                nameFinderMEArray[i] = new NameFinderME((TokenNameFinderModel)object);
            }
            PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
            object = new PerformanceMonitor(System.err, "sent");
            ((PerformanceMonitor)object).start();
            try {
                String string;
                while ((string = (String)plainTextByLineStream.read()) != null) {
                    String[] stringArray2 = WhitespaceTokenizer.INSTANCE.tokenize(string);
                    if (stringArray2.length == 0) {
                        for (NameFinderME nameFinderME : nameFinderMEArray) {
                            nameFinderME.clearAdaptiveData();
                        }
                    }
                    ArrayList arrayList = new ArrayList();
                    for (NameFinderME nameFinderME : nameFinderMEArray) {
                        Collections.addAll(arrayList, nameFinderME.find(stringArray2));
                    }
                    Object[] objectArray = NameFinderME.dropOverlappingSpans(arrayList.toArray(new Span[arrayList.size()]));
                    NameSample nameSample = new NameSample(stringArray2, (Span[])objectArray, false);
                    System.out.println(nameSample.toString());
                    ((PerformanceMonitor)object).incrementCounter();
                }
            }
            catch (IOException iOException) {
                CmdLineUtil.handleStdinIoError(iOException);
            }
            ((PerformanceMonitor)object).stopAndPrintFinalResult();
        }
    }
}

