/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.namefind;

import chalk.tools.cmdline.AbstractTrainerTool;
import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.namefind.TrainingParams;
import chalk.tools.cmdline.params.TrainingToolParams;
import chalk.tools.namefind.NameFinderME;
import chalk.tools.namefind.NameSample;
import chalk.tools.namefind.NameSampleTypeFilter;
import chalk.tools.namefind.TokenNameFinderModel;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.model.ArtifactSerializer;
import chalk.tools.util.model.BaseModel;
import chalk.tools.util.model.ModelUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;

public final class TokenNameFinderTrainerTool
extends AbstractTrainerTool<NameSample, TrainerToolParams> {
    public TokenNameFinderTrainerTool() {
        super(NameSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable name finder";
    }

    static byte[] openFeatureGeneratorBytes(String string) {
        if (string != null) {
            return TokenNameFinderTrainerTool.openFeatureGeneratorBytes(new File(string));
        }
        return null;
    }

    static byte[] openFeatureGeneratorBytes(File file) {
        byte[] byArray = null;
        if (file != null) {
            FileInputStream fileInputStream = CmdLineUtil.openInFile(file);
            try {
                byArray = ModelUtil.read(fileInputStream);
            }
            catch (IOException iOException) {
                throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
            }
            finally {
                try {
                    ((InputStream)fileInputStream).close();
                }
                catch (IOException iOException) {}
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, Object> loadResources(File file) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        if (file != null) {
            File[] fileArray;
            Map<String, ArtifactSerializer> map = TokenNameFinderModel.createArtifactSerializers();
            for (File file2 : fileArray = file.listFiles()) {
                String string;
                ArtifactSerializer artifactSerializer;
                String string2 = file2.getName();
                int n = string2.lastIndexOf(46);
                if (n == -1 || (artifactSerializer = map.get(string = string2.substring(n + 1))) == null) continue;
                FileInputStream fileInputStream = CmdLineUtil.openInFile(file2);
                try {
                    hashMap.put(string2, artifactSerializer.create(fileInputStream));
                }
                catch (InvalidFormatException invalidFormatException) {
                    invalidFormatException.printStackTrace();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                finally {
                    try {
                        ((InputStream)fileInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return hashMap;
    }

    static Map<String, Object> loadResources(String string) {
        if (string != null) {
            File file = new File(string);
            return TokenNameFinderTrainerTool.loadResources(file);
        }
        return new HashMap<String, Object>();
    }

    @Override
    public void run(String string, String[] stringArray) {
        Object object;
        super.run(string, stringArray);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((TrainerToolParams)this.params).getIterations(), ((TrainerToolParams)this.params).getCutoff());
        }
        File file = ((TrainerToolParams)this.params).getModel();
        byte[] byArray = TokenNameFinderTrainerTool.openFeatureGeneratorBytes(((TrainerToolParams)this.params).getFeaturegen());
        Map<String, Object> map = TokenNameFinderTrainerTool.loadResources(((TrainerToolParams)this.params).getResources());
        CmdLineUtil.checkOutputFile("name finder model", file);
        if (((TrainerToolParams)this.params).getNameTypes() != null) {
            object = ((TrainerToolParams)this.params).getNameTypes().split(",");
            this.sampleStream = new NameSampleTypeFilter((String[])object, (ObjectStream<NameSample>)this.sampleStream);
        }
        try {
            object = NameFinderME.train(this.factory.getLang(), ((TrainerToolParams)this.params).getType(), (ObjectStream<NameSample>)this.sampleStream, this.mlParams, byArray, map);
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("name finder", file, (BaseModel)object);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
        @ArgumentParser.OptionalParameter
        @ArgumentParser.ParameterDescription(valueName="types", description="name types to use for training")
        public String getNameTypes();
    }
}

