/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.parser;

import chalk.tools.cmdline.AbstractTypedParamTool;
import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.ObjectStreamFactory;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.params.TrainingToolParams;
import chalk.tools.cmdline.parser.ParserModelLoader;
import chalk.tools.parser.Parse;
import chalk.tools.parser.ParserModel;
import chalk.tools.util.ObjectStream;
import java.io.File;
import java.io.IOException;

abstract class ModelUpdaterTool
extends AbstractTypedParamTool<Parse, ModelUpdaterParams> {
    protected ModelUpdaterTool() {
        super(Parse.class, ModelUpdaterParams.class);
    }

    protected abstract ParserModel trainAndUpdate(ParserModel var1, ObjectStream<Parse> var2, ModelUpdaterParams var3) throws IOException;

    @Override
    public final void run(String string, String[] stringArray) {
        ParserModel parserModel;
        ModelUpdaterParams modelUpdaterParams = this.validateAndParseParams(ArgumentParser.filter(stringArray, ModelUpdaterParams.class), ModelUpdaterParams.class);
        File file = modelUpdaterParams.getModel();
        ParserModel parserModel2 = (ParserModel)new ParserModelLoader().load(file);
        ObjectStreamFactory objectStreamFactory = this.getStreamFactory(string);
        String[] stringArray2 = ArgumentParser.filter(stringArray, objectStreamFactory.getParameters());
        this.validateFactoryArgs(objectStreamFactory, stringArray2);
        ObjectStream<Parse> objectStream = objectStreamFactory.create(stringArray2);
        try {
            parserModel = this.trainAndUpdate(parserModel2, objectStream, modelUpdaterParams);
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                objectStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("parser", file, parserModel);
    }

    static interface ModelUpdaterParams
    extends TrainingToolParams {
    }
}

