/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.parser;

import chalk.tools.cmdline.AbstractBasicCmdLineTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.PerformanceMonitor;
import chalk.tools.cmdline.parser.ParserModelLoader;
import chalk.tools.parser.Parse;
import chalk.tools.parser.Parser;
import chalk.tools.parser.ParserFactory;
import chalk.tools.parser.ParserModel;
import chalk.tools.util.PlainTextByLineStream;
import chalk.tools.util.Span;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.regex.Pattern;

public final class ParserTool
extends AbstractBasicCmdLineTool {
    private static Pattern untokenizedParenPattern1 = Pattern.compile("([^ ])([({)}])");
    private static Pattern untokenizedParenPattern2 = Pattern.compile("([({)}])([^ ])");

    @Override
    public String getShortDescription() {
        return "performs full syntactic parsing";
    }

    @Override
    public String getHelp() {
        return "Usage: chalk " + this.getName() + " [-bs n -ap n -k n] model < sentences \n" + "-bs n: Use a beam size of n.\n" + "-ap f: Advance outcomes in with at least f% of the probability mass.\n" + "-k n: Show the top n parses.  This will also display their log-probablities.";
    }

    public static Parse[] parseLine(String string, Parser parser, int n) {
        String string2;
        string = untokenizedParenPattern1.matcher(string).replaceAll("$1 $2");
        string = untokenizedParenPattern2.matcher(string).replaceAll("$1 $2");
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = stringTokenizer.nextToken();
            arrayList.add(string2);
            stringBuilder.append(string2).append(" ");
        }
        string2 = stringBuilder.substring(0, stringBuilder.length() - 1);
        Parse parse = new Parse(string2, new Span(0, string2.length()), "INC", 0.0, 0);
        int n2 = 0;
        int n3 = 0;
        for (String string3 : arrayList) {
            parse.insert(new Parse(string2, new Span(n2, n2 + string3.length()), "TK", 0.0, n3));
            n2 += string3.length() + 1;
            ++n3;
        }
        Parse[] parseArray = n == 1 ? new Parse[]{parser.parse(parse)} : parser.parse(parse, n);
        return parseArray;
    }

    @Override
    public void run(String[] stringArray) {
        if (stringArray.length < 1) {
            System.out.println(this.getHelp());
        } else {
            boolean bl;
            Integer n;
            ParserModel parserModel = (ParserModel)new ParserModelLoader().load(new File(stringArray[stringArray.length - 1]));
            Integer n2 = CmdLineUtil.getIntParameter("-bs", stringArray);
            if (n2 == null) {
                n2 = 20;
            }
            if ((n = CmdLineUtil.getIntParameter("-k", stringArray)) == null) {
                n = 1;
                bl = false;
            } else {
                bl = true;
            }
            Double d = CmdLineUtil.getDoubleParameter("-ap", stringArray);
            if (d == null) {
                d = 0.95;
            }
            Parser parser = ParserFactory.create(parserModel, n2, d);
            PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
            PerformanceMonitor performanceMonitor = new PerformanceMonitor(System.err, "sent");
            performanceMonitor.start();
            try {
                String string;
                while ((string = (String)plainTextByLineStream.read()) != null) {
                    if (string.length() == 0) {
                        System.out.println();
                        continue;
                    }
                    Parse[] parseArray = ParserTool.parseLine(string, parser, n);
                    int n3 = parseArray.length;
                    for (int i = 0; i < n3; ++i) {
                        if (bl) {
                            System.out.print(i + " " + parseArray[i].getProb() + " ");
                        }
                        parseArray[i].show();
                        performanceMonitor.incrementCounter();
                    }
                }
            }
            catch (IOException iOException) {
                CmdLineUtil.handleStdinIoError(iOException);
            }
            performanceMonitor.stopAndPrintFinalResult();
        }
    }
}

