/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.parser;

import chalk.tools.cmdline.AbstractTrainerTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.params.EncodingParameter;
import chalk.tools.cmdline.params.TrainingToolParams;
import chalk.tools.cmdline.parser.TrainingParams;
import chalk.tools.dictionary.Dictionary;
import chalk.tools.parser.Parse;
import chalk.tools.parser.ParserModel;
import chalk.tools.parser.ParserType;
import chalk.tools.parser.lang.en.HeadRules;
import chalk.tools.parser.treeinsert.Parser;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.model.ModelUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import nak.model.TrainUtil;

public final class ParserTrainerTool
extends AbstractTrainerTool<Parse, TrainerToolParams> {
    public ParserTrainerTool() {
        super(Parse.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "trains the learnable parser";
    }

    static Dictionary buildDictionary(ObjectStream<Parse> objectStream, chalk.tools.parser.HeadRules headRules, int n) {
        Dictionary dictionary;
        System.err.print("Building dictionary ...");
        try {
            dictionary = chalk.tools.parser.chunking.Parser.buildDictionary(objectStream, headRules, n);
        }
        catch (IOException iOException) {
            System.err.println("Error while building dictionary: " + iOException.getMessage());
            dictionary = null;
        }
        System.err.println("done");
        return dictionary;
    }

    static ParserType parseParserType(String string) {
        ParserType parserType = null;
        if (string != null && string.length() > 0 && (parserType = ParserType.parse(string)) == null) {
            throw new TerminateToolException(1, "ParserType training parameter '" + string + "' is invalid!");
        }
        return parserType;
    }

    @Override
    public void run(String string, String[] stringArray) {
        ParserModel parserModel;
        File file;
        block19: {
            super.run(string, stringArray);
            this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), true);
            if (this.mlParams != null) {
                if (!TrainUtil.isValid(this.mlParams.getSettings("build"))) {
                    throw new TerminateToolException(1, "Build training parameters are invalid!");
                }
                if (!TrainUtil.isValid(this.mlParams.getSettings("check"))) {
                    throw new TerminateToolException(1, "Check training parameters are invalid!");
                }
                if (!TrainUtil.isValid(this.mlParams.getSettings("attach"))) {
                    throw new TerminateToolException(1, "Attach training parameters are invalid!");
                }
                if (!TrainUtil.isValid(this.mlParams.getSettings("tagger"))) {
                    throw new TerminateToolException(1, "Tagger training parameters are invalid!");
                }
                if (!TrainUtil.isValid(this.mlParams.getSettings("chunker"))) {
                    throw new TerminateToolException(1, "Chunker training parameters are invalid!");
                }
            }
            if (this.mlParams == null) {
                this.mlParams = ModelUtil.createTrainingParameters(((TrainerToolParams)this.params).getIterations(), ((TrainerToolParams)this.params).getCutoff());
            }
            file = ((TrainerToolParams)this.params).getModel();
            CmdLineUtil.checkOutputFile("parser model", file);
            try {
                HeadRules headRules = new HeadRules(new InputStreamReader((InputStream)new FileInputStream(((TrainerToolParams)this.params).getHeadRules()), ((TrainerToolParams)this.params).getEncoding()));
                ParserType parserType = ParserTrainerTool.parseParserType(((TrainerToolParams)this.params).getParserType());
                if (((TrainerToolParams)this.params).getFun().booleanValue()) {
                    Parse.useFunctionTags(true);
                }
                if (ParserType.CHUNKING.equals((Object)parserType)) {
                    parserModel = chalk.tools.parser.chunking.Parser.train(this.factory.getLang(), this.sampleStream, headRules, this.mlParams);
                    break block19;
                }
                if (ParserType.TREEINSERT.equals((Object)parserType)) {
                    parserModel = Parser.train(this.factory.getLang(), this.sampleStream, headRules, this.mlParams);
                    break block19;
                }
                throw new IllegalStateException();
            }
            catch (IOException iOException) {
                throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
            }
            finally {
                try {
                    this.sampleStream.close();
                }
                catch (IOException iOException) {}
            }
        }
        CmdLineUtil.writeModel("parser", file, parserModel);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams,
    EncodingParameter {
    }
}

