/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.postag;

import chalk.tools.cmdline.AbstractEvaluatorTool;
import chalk.tools.cmdline.ArgumentParser;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.params.EvaluatorParams;
import chalk.tools.cmdline.postag.POSEvaluationErrorListener;
import chalk.tools.cmdline.postag.POSModelLoader;
import chalk.tools.cmdline.postag.POSTaggerFineGrainedReportListener;
import chalk.tools.postag.POSEvaluator;
import chalk.tools.postag.POSModel;
import chalk.tools.postag.POSSample;
import chalk.tools.postag.POSTaggerME;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class POSTaggerEvaluatorTool
extends AbstractEvaluatorTool<POSSample, EvalToolParams> {
    public POSTaggerEvaluatorTool() {
        super(POSSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "Measures the performance of the POS tagger model with the reference data";
    }

    @Override
    public void run(String string, String[] stringArray) {
        super.run(string, stringArray);
        POSModel pOSModel = (POSModel)new POSModelLoader().load(((EvalToolParams)this.params).getModel());
        POSEvaluationErrorListener pOSEvaluationErrorListener = null;
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            pOSEvaluationErrorListener = new POSEvaluationErrorListener();
        }
        POSTaggerFineGrainedReportListener pOSTaggerFineGrainedReportListener = null;
        File file = ((EvalToolParams)this.params).getReportOutputFile();
        FileOutputStream fileOutputStream = null;
        if (file != null) {
            CmdLineUtil.checkOutputFile("Report Output File", file);
            try {
                fileOutputStream = new FileOutputStream(file);
                pOSTaggerFineGrainedReportListener = new POSTaggerFineGrainedReportListener(fileOutputStream);
            }
            catch (FileNotFoundException fileNotFoundException) {
                throw new TerminateToolException(-1, "IO error while creating POS Tagger fine-grained report file: " + fileNotFoundException.getMessage());
            }
        }
        POSEvaluator pOSEvaluator = new POSEvaluator(new POSTaggerME(pOSModel), pOSEvaluationErrorListener, pOSTaggerFineGrainedReportListener);
        System.out.print("Evaluating ... ");
        try {
            pOSEvaluator.evaluate(this.sampleStream);
        }
        catch (IOException iOException) {
            System.err.println("failed");
            throw new TerminateToolException(-1, "IO error while reading test data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        System.out.println("done");
        if (pOSTaggerFineGrainedReportListener != null) {
            System.out.println("Writing fine-grained report to " + ((EvalToolParams)this.params).getReportOutputFile().getAbsolutePath());
            pOSTaggerFineGrainedReportListener.writeReport();
            try {
                ((OutputStream)fileOutputStream).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.println();
        System.out.println("Accuracy: " + pOSEvaluator.getWordAccuracy());
    }

    static interface EvalToolParams
    extends EvaluatorParams {
        @ArgumentParser.ParameterDescription(valueName="outputFile", description="the path of the fine-grained report file.")
        @ArgumentParser.OptionalParameter
        public File getReportOutputFile();
    }
}

