/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.postag;

import chalk.tools.postag.POSSample;
import chalk.tools.postag.POSTaggerEvaluationMonitor;
import chalk.tools.util.Span;
import chalk.tools.util.eval.FMeasure;
import chalk.tools.util.eval.Mean;
import java.io.OutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;

public class POSTaggerFineGrainedReportListener
implements POSTaggerEvaluationMonitor {
    private final PrintStream printStream;
    private final Stats stats = new Stats();
    private static final char[] alpha = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};

    public POSTaggerFineGrainedReportListener() {
        this(System.err);
    }

    public POSTaggerFineGrainedReportListener(OutputStream outputStream) {
        this.printStream = new PrintStream(outputStream);
    }

    @Override
    public void missclassified(POSSample pOSSample, POSSample pOSSample2) {
        this.stats.add(pOSSample, pOSSample2);
    }

    @Override
    public void correctlyClassified(POSSample pOSSample, POSSample pOSSample2) {
        this.stats.add(pOSSample, pOSSample2);
    }

    public void writeReport() {
        this.printGeneralStatistics();
        this.printTokenErrorRank();
        this.printTokenOcurrenciesRank();
        this.printTagsErrorRank();
        this.printGeneralConfusionTable();
        this.printDetailedConfusionMatrix();
    }

    public long getNumberOfSentences() {
        return this.stats.getNumberOfSentences();
    }

    public double getAverageSentenceSize() {
        return this.stats.getAverageSentenceSize();
    }

    public int getMinSentenceSize() {
        return this.stats.getMinSentenceSize();
    }

    public int getMaxSentenceSize() {
        return this.stats.getMaxSentenceSize();
    }

    public int getNumberOfTags() {
        return this.stats.getNumberOfTags();
    }

    public double getAccuracy() {
        return this.stats.getAccuracy();
    }

    public double getTokenAccuracy(String string) {
        return this.stats.getTokenAccuracy(string);
    }

    public SortedSet<String> getTokensOrderedByFrequency() {
        return this.stats.getTokensOrderedByFrequency();
    }

    public int getTokenFrequency(String string) {
        return this.stats.getTokenFrequency(string);
    }

    public int getTokenErrors(String string) {
        return this.stats.getTokenErrors(string);
    }

    public SortedSet<String> getTokensOrderedByNumberOfErrors() {
        return this.stats.getTokensOrderedByNumberOfErrors();
    }

    public SortedSet<String> getTagsOrderedByErrors() {
        return this.stats.getTagsOrderedByErrors();
    }

    public int getTagFrequency(String string) {
        return this.stats.getTagFrequency(string);
    }

    public int getTagErrors(String string) {
        return this.stats.getTagErrors(string);
    }

    public double getTagPrecision(String string) {
        return this.stats.getTagPrecision(string);
    }

    public double getTagRecall(String string) {
        return this.stats.getTagRecall(string);
    }

    public double getTagFMeasure(String string) {
        return this.stats.getTagFMeasure(string);
    }

    public SortedSet<String> getConfusionMatrixTagset() {
        return this.stats.getConfusionMatrixTagset();
    }

    public SortedSet<String> getConfusionMatrixTagset(String string) {
        return this.stats.getConfusionMatrixTagset(string);
    }

    public double[][] getConfusionMatrix() {
        return this.stats.getConfusionMatrix();
    }

    public double[][] getConfusionMatrix(String string) {
        return this.stats.getConfusionMatrix(string);
    }

    private String matrixToString(SortedSet<String> sortedSet, double[][] dArray, boolean bl) {
        int n;
        int n2 = 0;
        String[] stringArray = sortedSet.toArray(new String[sortedSet.size()]);
        StringBuilder stringBuilder = new StringBuilder();
        int n3 = Integer.MIN_VALUE;
        String[][] stringArray2 = new String[dArray.length][dArray[0].length];
        for (int i = 0; i < dArray.length; ++i) {
            int n4;
            for (n4 = 0; n4 < dArray[i].length - 1; ++n4) {
                String string = stringArray2[i][n4] = dArray[i][n4] > 0.0 ? Integer.toString((int)dArray[i][n4]) : ".";
                if (n3 >= stringArray2[i][n4].length()) continue;
                n3 = stringArray2[i][n4].length();
            }
            stringArray2[i][n4] = MessageFormat.format("{0,number,#.##%}", dArray[i][n4]);
            if (dArray[i][n4] != 1.0 || !bl) continue;
            n2 = i + 1;
        }
        String string = "%" + (n3 + 2) + "s ";
        String string2 = "%" + (n3 + 2) + "s ";
        String string3 = " %" + (n3 + 2) + "s";
        for (n = n2; n < sortedSet.size(); ++n) {
            stringBuilder.append(String.format(string, POSTaggerFineGrainedReportListener.generateAlphaLabel(n - n2).trim()));
        }
        stringBuilder.append("| Accuracy | <-- classified as\n");
        for (n = n2; n < dArray.length; ++n) {
            int n5;
            for (n5 = n2; n5 < dArray[n].length - 1; ++n5) {
                if (n == n5) {
                    String string4 = "<" + stringArray2[n][n5] + ">";
                    stringBuilder.append(String.format(string3, string4));
                    continue;
                }
                stringBuilder.append(String.format(string2, stringArray2[n][n5]));
            }
            stringBuilder.append(String.format("|   %-6s |   %3s = ", stringArray2[n][n5], POSTaggerFineGrainedReportListener.generateAlphaLabel(n - n2))).append(stringArray[n]);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }

    private void printGeneralStatistics() {
        this.printHeader("Evaluation summary");
        this.printStream.append(String.format("%21s: %6s", "Number of sentences", Long.toString(this.getNumberOfSentences()))).append("\n");
        this.printStream.append(String.format("%21s: %6s", "Min sentence size", this.getMinSentenceSize())).append("\n");
        this.printStream.append(String.format("%21s: %6s", "Max sentence size", this.getMaxSentenceSize())).append("\n");
        this.printStream.append(String.format("%21s: %6s", "Average sentence size", MessageFormat.format("{0,number,#.##}", this.getAverageSentenceSize()))).append("\n");
        this.printStream.append(String.format("%21s: %6s", "Tags count", this.getNumberOfTags())).append("\n");
        this.printStream.append(String.format("%21s: %6s", "Accuracy", MessageFormat.format("{0,number,#.##%}", this.getAccuracy()))).append("\n");
        this.printFooter("Evaluation Corpus Statistics");
    }

    private void printTokenOcurrenciesRank() {
        this.printHeader("Most frequent tokens");
        SortedSet<String> sortedSet = this.getTokensOrderedByFrequency();
        int n = 5;
        int n2 = 0;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext() && n2++ < 20) {
            String string = (String)iterator.next();
            if (string.length() <= n) continue;
            n = string.length();
        }
        int n3 = n + 19;
        String string = "| %3s | %6s | %" + n + "s |";
        this.printLine(n3);
        this.printStream.append(String.format(string, "Pos", "Count", "Token")).append("\n");
        this.printLine(n3);
        n2 = 0;
        iterator = sortedSet.iterator();
        while (iterator.hasNext() && n2++ < 20) {
            String string2 = (String)iterator.next();
            int n4 = this.getTokenFrequency(string2);
            this.printStream.append(String.format(string, n2, n4, string2)).append("\n");
        }
        this.printLine(n3);
        this.printFooter("Most frequent tokens");
    }

    private void printTokenErrorRank() {
        this.printHeader("Tokens with the highest number of errors");
        this.printStream.append("\n");
        SortedSet<String> sortedSet = this.getTokensOrderedByNumberOfErrors();
        int n = 5;
        int n2 = 0;
        Iterator iterator = sortedSet.iterator();
        while (iterator.hasNext() && n2++ < 20) {
            String string = (String)iterator.next();
            if (string.length() <= n) continue;
            n = string.length();
        }
        int n3 = 31 + n;
        String string = "| %" + n + "s | %6s | %5s | %7s |\n";
        this.printLine(n3);
        this.printStream.append(String.format(string, "Token", "Errors", "Count", "% Err"));
        this.printLine(n3);
        n2 = 0;
        iterator = sortedSet.iterator();
        while (iterator.hasNext() && n2++ < 20) {
            String string2 = (String)iterator.next();
            int n4 = this.getTokenFrequency(string2);
            int n5 = this.getTokenErrors(string2);
            String string3 = MessageFormat.format("{0,number,#.##%}", (double)n5 / (double)n4);
            this.printStream.append(String.format(string, string2, n5, n4, string3));
        }
        this.printLine(n3);
        this.printFooter("Tokens with the highest number of errors");
    }

    private void printTagsErrorRank() {
        String string2;
        this.printHeader("Detailed Accuracy By Tag");
        SortedSet<String> sortedSet = this.getTagsOrderedByErrors();
        this.printStream.append("\n");
        int n = 3;
        for (String string2 : sortedSet) {
            if (string2.length() <= n) continue;
            n = string2.length();
        }
        int n2 = 65 + n;
        string2 = "| %" + n + "s | %6s | %6s | %7s | %9s | %6s | %9s |\n";
        String string3 = "| %" + n + "s | %6s | %6s | %-7s | %-9s | %-6s | %-9s |\n";
        this.printLine(n2);
        this.printStream.append(String.format(string2, "Tag", "Errors", "Count", "% Err", "Precision", "Recall", "F-Measure"));
        this.printLine(n2);
        for (String string4 : sortedSet) {
            int n3 = this.getTagFrequency(string4);
            int n4 = this.getTagErrors(string4);
            String string5 = MessageFormat.format("{0,number,#.###}", (double)n4 / (double)n3);
            double d = this.getTagPrecision(string4);
            double d2 = this.getTagRecall(string4);
            double d3 = this.getTagFMeasure(string4);
            this.printStream.append(String.format(string3, string4, n4, n3, string5, MessageFormat.format("{0,number,#.###}", d > 0.0 ? d : 0.0), MessageFormat.format("{0,number,#.###}", d2 > 0.0 ? d2 : 0.0), MessageFormat.format("{0,number,#.###}", d3 > 0.0 ? d3 : 0.0)));
        }
        this.printLine(n2);
        this.printFooter("Tags with the highest number of errors");
    }

    private void printGeneralConfusionTable() {
        this.printHeader("Confusion matrix");
        SortedSet<String> sortedSet = this.getConfusionMatrixTagset();
        double[][] dArray = this.getConfusionMatrix();
        this.printStream.append("\nTags with 100% accuracy: ");
        int n = 0;
        for (String string : sortedSet) {
            if (dArray[n][dArray[0].length - 1] == 1.0) {
                this.printStream.append(string).append(" (").append(Integer.toString((int)dArray[n][n])).append(") ");
            }
            ++n;
        }
        this.printStream.append("\n\n");
        this.printStream.append(this.matrixToString(sortedSet, dArray, true));
        this.printFooter("Confusion matrix");
    }

    private void printDetailedConfusionMatrix() {
        this.printHeader("Confusion matrix for tokens");
        this.printStream.append("  sorted by number of errors\n");
        SortedSet<String> sortedSet = this.getTokensOrderedByNumberOfErrors();
        for (String string : sortedSet) {
            double d = this.getTokenAccuracy(string);
            if (!(d < 1.0)) continue;
            this.printStream.append("\n[").append(string).append("]\n").append(String.format("%12s: %-8s", "Accuracy", MessageFormat.format("{0,number,#.##%}", d))).append("\n");
            this.printStream.append(String.format("%12s: %-8s", "Ocurrencies", Integer.toString(this.getTokenFrequency(string)))).append("\n");
            this.printStream.append(String.format("%12s: %-8s", "Errors", Integer.toString(this.getTokenErrors(string)))).append("\n");
            SortedSet<String> sortedSet2 = this.getConfusionMatrixTagset(string);
            double[][] dArray = this.getConfusionMatrix(string);
            this.printStream.append(this.matrixToString(sortedSet2, dArray, false));
        }
        this.printFooter("Confusion matrix for tokens");
    }

    private void printHeader(String string) {
        this.printStream.append("=== ").append(string).append(" ===\n");
    }

    private void printFooter(String string) {
        this.printStream.append("\n<-end> ").append(string).append("\n\n");
    }

    private void printLine(int n) {
        for (int i = 0; i < n; ++i) {
            this.printStream.append("-");
        }
        this.printStream.append("\n");
    }

    private static final String generateAlphaLabel(int n) {
        char[] cArray = new char[3];
        for (int i = 2; i >= 0; --i) {
            cArray[i] = alpha[n % alpha.length];
            if ((n = n / alpha.length - 1) < 0) break;
        }
        return new String(cArray);
    }

    private static class Counter {
        private int c = 0;

        private Counter() {
        }

        public void increment() {
            ++this.c;
        }

        public int value() {
            return this.c;
        }
    }

    private static class ConfusionMatrixLine {
        private Map<String, Counter> line = new HashMap<String, Counter>();
        private String ref;
        private int total = 0;
        private int correct = 0;
        private double acc = -1.0;

        public ConfusionMatrixLine(String string) {
            this.ref = string;
        }

        public void increment(String string) {
            ++this.total;
            if (string.equals(this.ref)) {
                ++this.correct;
            }
            if (!this.line.containsKey(string)) {
                this.line.put(string, new Counter());
            }
            this.line.get(string).increment();
        }

        public double getAccuracy() {
            if (this.acc == -1.0) {
                if (this.total == 0) {
                    this.acc = 0.0;
                }
                this.acc = (double)this.correct / (double)this.total;
            }
            return this.acc;
        }

        public int getValue(String string) {
            Counter counter = this.line.get(string);
            if (counter == null) {
                return 0;
            }
            return counter.value();
        }
    }

    private static class CategoryComparator
    implements Comparator<String> {
        private Map<String, ConfusionMatrixLine> confusionMatrix;

        public CategoryComparator(Map<String, ConfusionMatrixLine> map) {
            this.confusionMatrix = map;
        }

        @Override
        public int compare(String string, String string2) {
            double d;
            if (string.equals(string2)) {
                return 0;
            }
            ConfusionMatrixLine confusionMatrixLine = this.confusionMatrix.get(string);
            ConfusionMatrixLine confusionMatrixLine2 = this.confusionMatrix.get(string2);
            if (confusionMatrixLine == null || confusionMatrixLine2 == null) {
                if (confusionMatrixLine == null) {
                    return 1;
                }
                if (confusionMatrixLine2 == null) {
                    return -1;
                }
                return 0;
            }
            double d2 = confusionMatrixLine.getAccuracy();
            if (d2 == (d = confusionMatrixLine2.getAccuracy())) {
                return string.compareTo(string2);
            }
            if (d > d2) {
                return 1;
            }
            return -1;
        }
    }

    private class Stats {
        private final Mean accuracy = new Mean();
        private final Mean averageSentenceLength = new Mean();
        private int minimalSentenceLength = Integer.MAX_VALUE;
        private int maximumSentenceLength = Integer.MIN_VALUE;
        private final Map<String, Mean> tokAccuracies = new HashMap<String, Mean>();
        private final Map<String, Counter> tokOcurrencies = new HashMap<String, Counter>();
        private final Map<String, Counter> tokErrors = new HashMap<String, Counter>();
        private final Map<String, Counter> tagOcurrencies = new HashMap<String, Counter>();
        private final Map<String, Counter> tagErrors = new HashMap<String, Counter>();
        private final Map<String, FMeasure> tagFMeasure = new HashMap<String, FMeasure>();
        private final Map<String, ConfusionMatrixLine> generalConfusionMatrix = new HashMap<String, ConfusionMatrixLine>();
        private final Map<String, Map<String, ConfusionMatrixLine>> tokenConfusionMatrix = new HashMap<String, Map<String, ConfusionMatrixLine>>();

        private Stats() {
        }

        public void add(POSSample pOSSample, POSSample pOSSample2) {
            int n = pOSSample.getSentence().length;
            this.averageSentenceLength.add(n);
            if (this.minimalSentenceLength > n) {
                this.minimalSentenceLength = n;
            }
            if (this.maximumSentenceLength < n) {
                this.maximumSentenceLength = n;
            }
            String[] stringArray = pOSSample.getSentence();
            String[] stringArray2 = pOSSample.getTags();
            String[] stringArray3 = pOSSample2.getTags();
            this.updateTagFMeasure(stringArray2, stringArray3);
            for (int i = 0; i < stringArray.length; ++i) {
                this.add(stringArray[i], stringArray2[i], stringArray3[i]);
            }
        }

        private void add(String string, String string2, String string3) {
            if (!this.tokAccuracies.containsKey(string)) {
                this.tokAccuracies.put(string, new Mean());
                this.tokOcurrencies.put(string, new Counter());
                this.tokErrors.put(string, new Counter());
            }
            this.tokOcurrencies.get(string).increment();
            if (!this.tagOcurrencies.containsKey(string2)) {
                this.tagOcurrencies.put(string2, new Counter());
                this.tagErrors.put(string2, new Counter());
            }
            this.tagOcurrencies.get(string2).increment();
            if (string2.equals(string3)) {
                this.tokAccuracies.get(string).add(1.0);
                this.accuracy.add(1.0);
            } else {
                this.tokAccuracies.get(string).add(0.0);
                this.tokErrors.get(string).increment();
                this.tagErrors.get(string2).increment();
                this.accuracy.add(0.0);
            }
            if (!this.generalConfusionMatrix.containsKey(string2)) {
                this.generalConfusionMatrix.put(string2, new ConfusionMatrixLine(string2));
            }
            this.generalConfusionMatrix.get(string2).increment(string3);
            if (!this.tokenConfusionMatrix.containsKey(string)) {
                this.tokenConfusionMatrix.put(string, new HashMap());
            }
            if (!this.tokenConfusionMatrix.get(string).containsKey(string2)) {
                this.tokenConfusionMatrix.get(string).put(string2, new ConfusionMatrixLine(string2));
            }
            this.tokenConfusionMatrix.get(string).get(string2).increment(string3);
        }

        private void updateTagFMeasure(String[] stringArray, String[] stringArray2) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
            hashSet.addAll(Arrays.asList(stringArray2));
            for (String string : hashSet) {
                ArrayList<Span> arrayList = new ArrayList<Span>();
                ArrayList<Span> arrayList2 = new ArrayList<Span>();
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].equals(string)) {
                        arrayList.add(new Span(i, i + 1));
                    }
                    if (!stringArray2[i].equals(string)) continue;
                    arrayList2.add(new Span(i, i + 1));
                }
                if (!this.tagFMeasure.containsKey(string)) {
                    this.tagFMeasure.put(string, new FMeasure());
                }
                this.tagFMeasure.get(string).updateScores(arrayList.toArray(new Span[arrayList.size()]), arrayList2.toArray(new Span[arrayList2.size()]));
            }
        }

        public double getAccuracy() {
            return this.accuracy.mean();
        }

        public int getNumberOfTags() {
            return this.tagOcurrencies.keySet().size();
        }

        public long getNumberOfSentences() {
            return this.averageSentenceLength.count();
        }

        public double getAverageSentenceSize() {
            return this.averageSentenceLength.mean();
        }

        public int getMinSentenceSize() {
            return this.minimalSentenceLength;
        }

        public int getMaxSentenceSize() {
            return this.maximumSentenceLength;
        }

        public double getTokenAccuracy(String string) {
            return this.tokAccuracies.get(string).mean();
        }

        public int getTokenErrors(String string) {
            return this.tokErrors.get(string).value();
        }

        public int getTokenFrequency(String string) {
            return this.tokOcurrencies.get(string).value();
        }

        public SortedSet<String> getTokensOrderedByFrequency() {
            TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    if (string.equals(string2)) {
                        return 0;
                    }
                    int n = 0;
                    int n2 = 0;
                    if (Stats.this.tokOcurrencies.containsKey(string)) {
                        n = ((Counter)Stats.this.tokOcurrencies.get(string)).value();
                    }
                    if (Stats.this.tokOcurrencies.containsKey(string2)) {
                        n2 = ((Counter)Stats.this.tokOcurrencies.get(string2)).value();
                    }
                    if (n == n2) {
                        return string.compareTo(string2);
                    }
                    return n2 - n;
                }
            });
            treeSet.addAll(this.tokOcurrencies.keySet());
            return Collections.unmodifiableSortedSet(treeSet);
        }

        public SortedSet<String> getTokensOrderedByNumberOfErrors() {
            TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    if (string.equals(string2)) {
                        return 0;
                    }
                    int n = 0;
                    int n2 = 0;
                    if (Stats.this.tokErrors.containsKey(string)) {
                        n = ((Counter)Stats.this.tokErrors.get(string)).value();
                    }
                    if (Stats.this.tokErrors.containsKey(string2)) {
                        n2 = ((Counter)Stats.this.tokErrors.get(string2)).value();
                    }
                    if (n == n2) {
                        return string.compareTo(string2);
                    }
                    return n2 - n;
                }
            });
            treeSet.addAll(this.tokErrors.keySet());
            return treeSet;
        }

        public int getTagFrequency(String string) {
            return this.tagOcurrencies.get(string).value();
        }

        public int getTagErrors(String string) {
            return this.tagErrors.get(string).value();
        }

        public double getTagFMeasure(String string) {
            return this.tagFMeasure.get(string).getFMeasure();
        }

        public double getTagRecall(String string) {
            return this.tagFMeasure.get(string).getRecallScore();
        }

        public double getTagPrecision(String string) {
            return this.tagFMeasure.get(string).getPrecisionScore();
        }

        public SortedSet<String> getTagsOrderedByErrors() {
            TreeSet<String> treeSet = new TreeSet<String>(new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    if (string.equals(string2)) {
                        return 0;
                    }
                    int n = 0;
                    int n2 = 0;
                    if (Stats.this.tagErrors.containsKey(string)) {
                        n = ((Counter)Stats.this.tagErrors.get(string)).value();
                    }
                    if (Stats.this.tagErrors.containsKey(string2)) {
                        n2 = ((Counter)Stats.this.tagErrors.get(string2)).value();
                    }
                    if (n == n2) {
                        return string.compareTo(string2);
                    }
                    return n2 - n;
                }
            });
            treeSet.addAll(this.tagErrors.keySet());
            return Collections.unmodifiableSortedSet(treeSet);
        }

        public SortedSet<String> getConfusionMatrixTagset() {
            return this.getConfusionMatrixTagset(this.generalConfusionMatrix);
        }

        public double[][] getConfusionMatrix() {
            return this.createConfusionMatrix(this.getConfusionMatrixTagset(), this.generalConfusionMatrix);
        }

        public SortedSet<String> getConfusionMatrixTagset(String string) {
            return this.getConfusionMatrixTagset(this.tokenConfusionMatrix.get(string));
        }

        public double[][] getConfusionMatrix(String string) {
            return this.createConfusionMatrix(this.getConfusionMatrixTagset(string), this.tokenConfusionMatrix.get(string));
        }

        private double[][] createConfusionMatrix(SortedSet<String> sortedSet, Map<String, ConfusionMatrixLine> map) {
            int n = sortedSet.size();
            double[][] dArray = new double[n][n + 1];
            int n2 = 0;
            for (String string : sortedSet) {
                int n3 = 0;
                for (String string2 : sortedSet) {
                    dArray[n2][n3] = map.get(string) != null ? map.get(string).getValue(string2) : 0;
                    ++n3;
                }
                dArray[n2][n3] = map.get(string) != null ? map.get(string).getAccuracy() : 0.0;
                ++n2;
            }
            return dArray;
        }

        private SortedSet<String> getConfusionMatrixTagset(Map<String, ConfusionMatrixLine> map) {
            TreeSet<String> treeSet = new TreeSet<String>(new CategoryComparator(map));
            treeSet.addAll(map.keySet());
            LinkedList linkedList = new LinkedList();
            for (String string : treeSet) {
                linkedList.addAll(map.get(string).line.keySet());
            }
            treeSet.addAll(linkedList);
            return Collections.unmodifiableSortedSet(treeSet);
        }
    }
}

