/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.postag;

import chalk.tools.cmdline.AbstractBasicCmdLineTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.PerformanceMonitor;
import chalk.tools.cmdline.postag.POSModelLoader;
import chalk.tools.postag.POSModel;
import chalk.tools.postag.POSSample;
import chalk.tools.postag.POSTaggerME;
import chalk.tools.tokenize.WhitespaceTokenizer;
import chalk.tools.util.PlainTextByLineStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;

public final class POSTaggerTool
extends AbstractBasicCmdLineTool {
    @Override
    public String getShortDescription() {
        return "learnable part of speech tagger";
    }

    @Override
    public String getHelp() {
        return "Usage: chalk " + this.getName() + " model < sentences";
    }

    @Override
    public void run(String[] stringArray) {
        if (stringArray.length != 1) {
            System.out.println(this.getHelp());
        } else {
            POSModel pOSModel = (POSModel)new POSModelLoader().load(new File(stringArray[0]));
            POSTaggerME pOSTaggerME = new POSTaggerME(pOSModel);
            PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
            PerformanceMonitor performanceMonitor = new PerformanceMonitor(System.err, "sent");
            performanceMonitor.start();
            try {
                String string;
                while ((string = (String)plainTextByLineStream.read()) != null) {
                    String[] stringArray2 = WhitespaceTokenizer.INSTANCE.tokenize(string);
                    String[] stringArray3 = pOSTaggerME.tag(stringArray2);
                    POSSample pOSSample = new POSSample(stringArray2, stringArray3);
                    System.out.println(pOSSample.toString());
                    performanceMonitor.incrementCounter();
                }
            }
            catch (IOException iOException) {
                CmdLineUtil.handleStdinIoError(iOException);
            }
            performanceMonitor.stopAndPrintFinalResult();
        }
    }
}

