/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.postag;

import chalk.tools.cmdline.AbstractTrainerTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.params.TrainingToolParams;
import chalk.tools.cmdline.postag.TrainingParams;
import chalk.tools.dictionary.Dictionary;
import chalk.tools.postag.MutableTagDictionary;
import chalk.tools.postag.POSSample;
import chalk.tools.postag.POSTaggerFactory;
import chalk.tools.postag.POSTaggerME;
import chalk.tools.postag.TagDictionary;
import chalk.tools.util.InvalidFormatException;
import chalk.tools.util.model.BaseModel;
import chalk.tools.util.model.ModelType;
import chalk.tools.util.model.ModelUtil;
import java.io.File;
import java.io.IOException;
import nak.model.TrainUtil;

public final class POSTaggerTrainerTool
extends AbstractTrainerTool<POSSample, TrainerToolParams> {
    public POSTaggerTrainerTool() {
        super(POSSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "trains a model for the part-of-speech tagger";
    }

    @Override
    public void run(String string, String[] stringArray) {
        Object object;
        super.run(string, stringArray);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), true);
        if (this.mlParams != null && !TrainUtil.isValid(this.mlParams.getSettings())) {
            throw new TerminateToolException(1, "Training parameters file '" + ((TrainerToolParams)this.params).getParams() + "' is invalid!");
        }
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((TrainerToolParams)this.params).getIterations(), ((TrainerToolParams)this.params).getCutoff());
            this.mlParams.put("Algorithm", POSTaggerTrainerTool.getModelType(((TrainerToolParams)this.params).getType()).toString());
        }
        File file = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("pos tagger model", file);
        Dictionary dictionary = null;
        Integer n = ((TrainerToolParams)this.params).getNgram();
        if (n != null) {
            System.err.print("Building ngram dictionary ... ");
            try {
                dictionary = POSTaggerME.buildNGramDictionary(this.sampleStream, n);
                this.sampleStream.reset();
            }
            catch (IOException iOException) {
                throw new TerminateToolException(-1, "IO error while building NGram Dictionary: " + iOException.getMessage(), iOException);
            }
            System.err.println("done");
        }
        POSTaggerFactory pOSTaggerFactory = null;
        try {
            pOSTaggerFactory = POSTaggerFactory.create(((TrainerToolParams)this.params).getFactory(), dictionary, null);
        }
        catch (InvalidFormatException invalidFormatException) {
            throw new TerminateToolException(-1, invalidFormatException.getMessage(), invalidFormatException);
        }
        if (((TrainerToolParams)this.params).getDict() != null) {
            try {
                pOSTaggerFactory.setTagDictionary(pOSTaggerFactory.createTagDictionary(((TrainerToolParams)this.params).getDict()));
            }
            catch (IOException iOException) {
                throw new TerminateToolException(-1, "IO error while loading POS Dictionary: " + iOException.getMessage(), iOException);
            }
        }
        if (((TrainerToolParams)this.params).getTagDictCutoff() != null) {
            try {
                object = pOSTaggerFactory.getTagDictionary();
                if (object == null) {
                    object = pOSTaggerFactory.createEmptyTagDictionary();
                    pOSTaggerFactory.setTagDictionary((TagDictionary)object);
                }
                if (!(object instanceof MutableTagDictionary)) {
                    throw new IllegalArgumentException("Can't extend a POSDictionary that does not implement MutableTagDictionary.");
                }
                POSTaggerME.populatePOSDictionary(this.sampleStream, (MutableTagDictionary)object, ((TrainerToolParams)this.params).getTagDictCutoff());
                this.sampleStream.reset();
            }
            catch (IOException iOException) {
                throw new TerminateToolException(-1, "IO error while creating/extending POS Dictionary: " + iOException.getMessage(), iOException);
            }
        }
        try {
            object = POSTaggerME.train(this.factory.getLang(), this.sampleStream, this.mlParams, pOSTaggerFactory);
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("pos tagger", file, (BaseModel)object);
    }

    static ModelType getModelType(String string) {
        if (string == null) {
            string = "maxent";
        }
        ModelType modelType = string.equals("maxent") ? ModelType.MAXENT : (string.equals("perceptron") ? ModelType.PERCEPTRON : (string.equals("perceptron_sequence") ? ModelType.PERCEPTRON_SEQUENCE : null));
        return modelType;
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

