/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.sentdetect;

import chalk.tools.cmdline.AbstractTrainerTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.params.TrainingToolParams;
import chalk.tools.cmdline.sentdetect.TrainingParams;
import chalk.tools.dictionary.Dictionary;
import chalk.tools.sentdetect.SentenceDetectorFactory;
import chalk.tools.sentdetect.SentenceDetectorME;
import chalk.tools.sentdetect.SentenceModel;
import chalk.tools.sentdetect.SentenceSample;
import chalk.tools.util.ObjectStream;
import chalk.tools.util.model.ModelUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import nak.model.TrainUtil;

public final class SentenceDetectorTrainerTool
extends AbstractTrainerTool<SentenceSample, TrainerToolParams> {
    public SentenceDetectorTrainerTool() {
        super(SentenceSample.class, TrainerToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "trainer for the learnable sentence detector";
    }

    static Dictionary loadDict(File file) throws IOException {
        Dictionary dictionary = null;
        if (file != null) {
            CmdLineUtil.checkInputFile("abb dict", file);
            dictionary = new Dictionary(new FileInputStream(file));
        }
        return dictionary;
    }

    @Override
    public void run(String string, String[] stringArray) {
        SentenceModel sentenceModel;
        super.run(string, stringArray);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((TrainerToolParams)this.params).getParams(), false);
        if (this.mlParams != null && TrainUtil.isSequenceTraining(this.mlParams.getSettings())) {
            throw new TerminateToolException(1, "Sequence training is not supported!");
        }
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((TrainerToolParams)this.params).getIterations(), ((TrainerToolParams)this.params).getCutoff());
        }
        File file = ((TrainerToolParams)this.params).getModel();
        CmdLineUtil.checkOutputFile("sentence detector model", file);
        char[] cArray = null;
        if (((TrainerToolParams)this.params).getEosChars() != null) {
            cArray = ((TrainerToolParams)this.params).getEosChars().toCharArray();
        }
        try {
            Dictionary dictionary = SentenceDetectorTrainerTool.loadDict(((TrainerToolParams)this.params).getAbbDict());
            SentenceDetectorFactory sentenceDetectorFactory = SentenceDetectorFactory.create(((TrainerToolParams)this.params).getFactory(), this.factory.getLang(), true, dictionary, cArray);
            sentenceModel = SentenceDetectorME.train(this.factory.getLang(), (ObjectStream<SentenceSample>)this.sampleStream, sentenceDetectorFactory, this.mlParams);
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        CmdLineUtil.writeModel("sentence detector", file, sentenceModel);
    }

    static interface TrainerToolParams
    extends TrainingParams,
    TrainingToolParams {
    }
}

