/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.tokenizer;

import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.PerformanceMonitor;
import chalk.tools.tokenize.Tokenizer;
import chalk.tools.tokenize.TokenizerStream;
import chalk.tools.tokenize.WhitespaceTokenStream;
import chalk.tools.util.PlainTextByLineStream;
import java.io.IOException;
import java.io.InputStreamReader;

final class CommandLineTokenizer {
    private final Tokenizer tokenizer;

    CommandLineTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    void process() {
        PlainTextByLineStream plainTextByLineStream = new PlainTextByLineStream(new InputStreamReader(System.in));
        WhitespaceTokenStream whitespaceTokenStream = new WhitespaceTokenStream(new TokenizerStream(this.tokenizer, plainTextByLineStream));
        PerformanceMonitor performanceMonitor = new PerformanceMonitor(System.err, "sent");
        performanceMonitor.start();
        try {
            String string;
            while ((string = (String)whitespaceTokenStream.read()) != null) {
                System.out.println(string);
                performanceMonitor.incrementCounter();
            }
        }
        catch (IOException iOException) {
            CmdLineUtil.handleStdinIoError(iOException);
        }
        performanceMonitor.stopAndPrintFinalResult();
    }
}

