/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.cmdline.tokenizer;

import chalk.tools.cmdline.AbstractCrossValidatorTool;
import chalk.tools.cmdline.CmdLineUtil;
import chalk.tools.cmdline.TerminateToolException;
import chalk.tools.cmdline.params.CVParams;
import chalk.tools.cmdline.tokenizer.TokenEvaluationErrorListener;
import chalk.tools.cmdline.tokenizer.TokenizerTrainerTool;
import chalk.tools.cmdline.tokenizer.TrainingParams;
import chalk.tools.dictionary.Dictionary;
import chalk.tools.tokenize.TokenSample;
import chalk.tools.tokenize.TokenizerCrossValidator;
import chalk.tools.tokenize.TokenizerFactory;
import chalk.tools.util.eval.FMeasure;
import chalk.tools.util.model.ModelUtil;
import java.io.IOException;

public final class TokenizerCrossValidatorTool
extends AbstractCrossValidatorTool<TokenSample, CVToolParams> {
    public TokenizerCrossValidatorTool() {
        super(TokenSample.class, CVToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "K-fold cross validator for the learnable tokenizer";
    }

    @Override
    public void run(String string, String[] stringArray) {
        TokenizerCrossValidator tokenizerCrossValidator;
        Object object;
        super.run(string, stringArray);
        this.mlParams = CmdLineUtil.loadTrainingParameters(((CVToolParams)this.params).getParams(), false);
        if (this.mlParams == null) {
            this.mlParams = ModelUtil.createTrainingParameters(((CVToolParams)this.params).getIterations(), ((CVToolParams)this.params).getCutoff());
        }
        TokenEvaluationErrorListener tokenEvaluationErrorListener = null;
        if (((CVToolParams)this.params).getMisclassified().booleanValue()) {
            tokenEvaluationErrorListener = new TokenEvaluationErrorListener();
        }
        try {
            object = TokenizerTrainerTool.loadDict(((CVToolParams)this.params).getAbbDict());
            TokenizerFactory tokenizerFactory = TokenizerFactory.create(((CVToolParams)this.params).getFactory(), this.factory.getLang(), (Dictionary)object, ((CVToolParams)this.params).getAlphaNumOpt(), null);
            tokenizerCrossValidator = new TokenizerCrossValidator(this.mlParams, tokenizerFactory, tokenEvaluationErrorListener);
            tokenizerCrossValidator.evaluate(this.sampleStream, ((CVToolParams)this.params).getFolds());
        }
        catch (IOException iOException) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + iOException.getMessage(), iOException);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        object = tokenizerCrossValidator.getFMeasure();
        System.out.println(((FMeasure)object).toString());
    }

    static interface CVToolParams
    extends CVParams,
    TrainingParams {
    }
}

