/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.DiscourseModel;
import chalk.tools.coref.Linker;
import chalk.tools.coref.LinkerMode;
import chalk.tools.coref.mention.HeadFinder;
import chalk.tools.coref.mention.Mention;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.mention.MentionFinder;
import chalk.tools.coref.mention.Parse;
import chalk.tools.coref.resolver.AbstractResolver;
import chalk.tools.coref.sim.Gender;
import chalk.tools.coref.sim.Number;
import java.io.IOException;

public abstract class AbstractLinker
implements Linker {
    protected MentionFinder mentionFinder;
    protected boolean debug = true;
    protected LinkerMode mode;
    protected static Linker linker;
    protected AbstractResolver[] resolvers;
    protected String[] resolverNames;
    protected DiscourseEntity[] entities;
    protected int SINGULAR_PRONOUN;
    protected String corefProject;
    protected HeadFinder headFinder;
    protected boolean useDiscourseModel;
    protected boolean removeUnresolvedMentions;

    public AbstractLinker(String string, LinkerMode linkerMode) {
        this(string, linkerMode, true);
    }

    public AbstractLinker(String string, LinkerMode linkerMode, boolean bl) {
        this.corefProject = string;
        this.mode = linkerMode;
        this.SINGULAR_PRONOUN = -1;
        this.useDiscourseModel = bl;
        this.removeUnresolvedMentions = true;
    }

    protected void resolve(MentionContext mentionContext, DiscourseModel discourseModel) {
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < this.resolvers.length; ++i) {
            if (this.resolvers[i].canResolve(mentionContext)) {
                if (this.mode == LinkerMode.TEST) {
                    this.entities[i] = this.resolvers[i].resolve(mentionContext, discourseModel);
                    bl2 = true;
                } else if (this.mode == LinkerMode.TRAIN) {
                    this.entities[i] = this.resolvers[i].retain(mentionContext, discourseModel);
                    if (i + 1 != this.resolvers.length) {
                        bl2 = true;
                    }
                } else if (this.mode == LinkerMode.EVAL) {
                    this.entities[i] = this.resolvers[i].retain(mentionContext, discourseModel);
                } else {
                    System.err.println("AbstractLinker.Unknown mode: " + (Object)((Object)this.mode));
                }
                if (i != this.SINGULAR_PRONOUN || this.entities[i] != null) continue;
                bl = false;
                continue;
            }
            this.entities[i] = null;
        }
        if (!bl2 && this.removeUnresolvedMentions) {
            bl = false;
        }
        DiscourseEntity discourseEntity = this.checkForMerges(discourseModel, this.entities);
        if (bl) {
            this.updateExtent(discourseModel, mentionContext, discourseEntity, this.useDiscourseModel);
        }
    }

    @Override
    public HeadFinder getHeadFinder() {
        return this.headFinder;
    }

    protected void updateExtent(DiscourseModel discourseModel, MentionContext mentionContext, DiscourseEntity discourseEntity, boolean bl) {
        if (bl) {
            if (discourseEntity != null) {
                if (discourseEntity.getGenderProbability() < mentionContext.getGenderProb()) {
                    discourseEntity.setGender(mentionContext.getGender());
                    discourseEntity.setGenderProbability(mentionContext.getGenderProb());
                }
                if (discourseEntity.getNumberProbability() < mentionContext.getNumberProb()) {
                    discourseEntity.setNumber(mentionContext.getNumber());
                    discourseEntity.setNumberProbability(mentionContext.getNumberProb());
                }
                discourseEntity.addMention(mentionContext);
                discourseModel.mentionEntity(discourseEntity);
            } else {
                discourseEntity = new DiscourseEntity(mentionContext, mentionContext.getGender(), mentionContext.getGenderProb(), mentionContext.getNumber(), mentionContext.getNumberProb());
                discourseModel.addEntity(discourseEntity);
            }
        } else if (discourseEntity != null) {
            DiscourseEntity discourseEntity2 = new DiscourseEntity(mentionContext, mentionContext.getGender(), mentionContext.getGenderProb(), mentionContext.getNumber(), mentionContext.getNumberProb());
            discourseModel.addEntity(discourseEntity2);
            discourseEntity2.setId(discourseEntity.getId());
        } else {
            DiscourseEntity discourseEntity3 = new DiscourseEntity(mentionContext, mentionContext.getGender(), mentionContext.getGenderProb(), mentionContext.getNumber(), mentionContext.getNumberProb());
            discourseModel.addEntity(discourseEntity3);
        }
    }

    protected DiscourseEntity checkForMerges(DiscourseModel discourseModel, DiscourseEntity[] discourseEntityArray) {
        DiscourseEntity discourseEntity = discourseEntityArray[0];
        for (int i = 1; i < discourseEntityArray.length; ++i) {
            DiscourseEntity discourseEntity2 = discourseEntityArray[i];
            if (discourseEntity2 == null) continue;
            if (discourseEntity != null && discourseEntity != discourseEntity2) {
                discourseModel.mergeEntities(discourseEntity, discourseEntity2, 1.0f);
                continue;
            }
            discourseEntity = discourseEntity2;
        }
        return discourseEntity;
    }

    @Override
    public DiscourseEntity[] getEntities(Mention[] mentionArray) {
        MentionContext[] mentionContextArray = this.constructMentionContexts(mentionArray);
        DiscourseModel discourseModel = new DiscourseModel();
        for (int i = 0; i < mentionContextArray.length; ++i) {
            this.resolve(mentionContextArray[i], discourseModel);
        }
        return discourseModel.getEntities();
    }

    @Override
    public void setEntities(Mention[] mentionArray) {
        this.getEntities(mentionArray);
    }

    @Override
    public void train() throws IOException {
        for (int i = 0; i < this.resolvers.length; ++i) {
            this.resolvers[i].train();
        }
    }

    @Override
    public MentionFinder getMentionFinder() {
        return this.mentionFinder;
    }

    @Override
    public MentionContext[] constructMentionContexts(Mention[] mentionArray) {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        MentionContext[] mentionContextArray = new MentionContext[mentionArray.length];
        int n4 = mentionArray.length;
        for (int i = 0; i < n4; ++i) {
            int n5;
            Parse parse = mentionArray[i].getParse();
            if (parse == null) {
                System.err.println("no parse for " + mentionArray[i]);
            }
            if ((n5 = parse.getSentenceNumber()) != n3) {
                n = 0;
                n3 = n5;
                n2 = 0;
                for (int j = i; j < mentionArray.length && n5 == mentionArray[j].getParse().getSentenceNumber(); ++j) {
                    ++n2;
                }
            }
            mentionContextArray[i] = new MentionContext(mentionArray[i], n, n2, i, n5, this.getHeadFinder());
            mentionContextArray[i].setId(mentionArray[i].getId());
            ++n;
            if (this.mode == LinkerMode.SIM) continue;
            Gender gender = this.computeGender(mentionContextArray[i]);
            mentionContextArray[i].setGender(gender.getType(), gender.getConfidence());
            Number number = this.computeNumber(mentionContextArray[i]);
            mentionContextArray[i].setNumber(number.getType(), number.getConfidence());
        }
        return mentionContextArray;
    }

    protected abstract Gender computeGender(MentionContext var1);

    protected abstract Number computeNumber(MentionContext var1);
}

