/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref;

import chalk.tools.dictionary.Dictionary;
import chalk.tools.util.StringList;
import chalk.tools.util.model.BaseModel;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import nak.io.BinaryGISModelReader;
import nak.model.AbstractModel;

public class CorefModel
extends BaseModel {
    private static final String COMPONENT_NAME = "Coref";
    private static final String MALE_NAMES_DICTIONARY_ENTRY_NAME = "maleNames.dictionary";
    private static final String FEMALE_NAMES_DICTIONARY_ENTRY_NAME = "femaleNames.dictionary";
    private static final String NUMBER_MODEL_ENTRY_NAME = "number.model";
    private static final String COMMON_NOUN_RESOLVER_MODEL_ENTRY_NAME = "commonNounResolver.model";
    private static final String DEFINITE_NOUN_RESOLVER_MODEL_ENTRY_NAME = "definiteNounResolver.model";
    private static final String SPEECH_PRONOUN_RESOLVER_MODEL_ENTRY_NAME = "speechPronounResolver.model";
    private static final String PLURAL_NOUN_RESOLVER_MODEL_ENTRY_NAME = "pluralNounResolver.model";
    private static final String SINGULAR_PRONOUN_RESOLVER_MODEL_ENTRY_NAME = "singularPronounResolver.model";
    private static final String PROPER_NOUN_RESOLVER_MODEL_ENTRY_NAME = "properNounResolver.model";
    private static final String SIM_MODEL_ENTRY_NAME = "sim.model";
    private static final String PLURAL_PRONOUN_RESOLVER_MODEL_ENTRY_NAME = "pluralPronounResolver.model";

    public CorefModel(String string, String string2) throws IOException {
        super(COMPONENT_NAME, string, null);
        this.artifactMap.put(MALE_NAMES_DICTIONARY_ENTRY_NAME, CorefModel.readNames(string2 + File.separator + "gen.mas"));
        this.artifactMap.put(FEMALE_NAMES_DICTIONARY_ENTRY_NAME, CorefModel.readNames(string2 + File.separator + "gen.fem"));
        this.artifactMap.put(NUMBER_MODEL_ENTRY_NAME, this.createModel(string2 + File.separator + "num.bin.gz"));
        this.artifactMap.put(COMMON_NOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(string2 + File.separator + "cmodel.bin.gz"));
        this.artifactMap.put(DEFINITE_NOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(string2 + File.separator + "defmodel.bin.gz"));
        this.artifactMap.put(SPEECH_PRONOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(string2 + File.separator + "fmodel.bin.gz"));
        this.artifactMap.put(PLURAL_NOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(string2 + File.separator + "plmodel.bin.gz"));
        this.artifactMap.put(SINGULAR_PRONOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(string2 + File.separator + "pmodel.bin.gz"));
        this.artifactMap.put(PROPER_NOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(string2 + File.separator + "pnmodel.bin.gz"));
        this.artifactMap.put(SIM_MODEL_ENTRY_NAME, this.createModel(string2 + File.separator + "sim.bin.gz"));
        this.artifactMap.put(PLURAL_PRONOUN_RESOLVER_MODEL_ENTRY_NAME, this.createModel(string2 + File.separator + "tmodel.bin.gz"));
        this.checkArtifactMap();
    }

    private AbstractModel createModel(String string) throws IOException {
        return new BinaryGISModelReader(new DataInputStream(new GZIPInputStream(new FileInputStream(string)))).getModel();
    }

    private static Dictionary readNames(String string) throws IOException {
        Dictionary dictionary = new Dictionary();
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        String string2 = bufferedReader.readLine();
        while (string2 != null) {
            dictionary.put(new StringList(string2));
            string2 = bufferedReader.readLine();
        }
        return dictionary;
    }

    public Dictionary getMaleNames() {
        return (Dictionary)this.artifactMap.get(MALE_NAMES_DICTIONARY_ENTRY_NAME);
    }

    public Dictionary getFemaleNames() {
        return (Dictionary)this.artifactMap.get(FEMALE_NAMES_DICTIONARY_ENTRY_NAME);
    }

    public AbstractModel getNumberModel() {
        return (AbstractModel)this.artifactMap.get(NUMBER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getCommonNounResolverModel() {
        return (AbstractModel)this.artifactMap.get(COMMON_NOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getDefiniteNounResolverModel() {
        return (AbstractModel)this.artifactMap.get(DEFINITE_NOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getSpeechPronounResolverModel() {
        return (AbstractModel)this.artifactMap.get(SPEECH_PRONOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getPluralNounResolverModel() {
        return (AbstractModel)this.artifactMap.get(PLURAL_NOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getSingularPronounResolverModel() {
        return (AbstractModel)this.artifactMap.get(SINGULAR_PRONOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getProperNounResolverModel() {
        return (AbstractModel)this.artifactMap.get(PROPER_NOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public AbstractModel getSimModel() {
        return (AbstractModel)this.artifactMap.get(SIM_MODEL_ENTRY_NAME);
    }

    public AbstractModel getPluralPronounResolverModel() {
        return (AbstractModel)this.artifactMap.get(PLURAL_PRONOUN_RESOLVER_MODEL_ENTRY_NAME);
    }

    public static void main(String[] stringArray) throws IOException {
        if (stringArray.length != 1) {
            System.err.println("Usage: CorefModel projectDirectory");
            System.exit(-1);
        }
        String string = stringArray[0];
        CorefModel corefModel = new CorefModel("en", string);
        corefModel.serialize(new FileOutputStream("coref.model"));
    }
}

