/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref;

import chalk.tools.coref.CorefSample;
import chalk.tools.coref.DefaultLinker;
import chalk.tools.coref.LinkerMode;
import chalk.tools.coref.TreebankLinker;
import chalk.tools.coref.mention.DefaultParse;
import chalk.tools.coref.mention.Mention;
import chalk.tools.coref.mention.MentionFinder;
import chalk.tools.coref.mention.Parse;
import chalk.tools.coref.resolver.MaxentResolver;
import chalk.tools.coref.sim.Context;
import chalk.tools.coref.sim.GenderModel;
import chalk.tools.coref.sim.NumberModel;
import chalk.tools.coref.sim.SimilarityModel;
import chalk.tools.coref.sim.TrainSimilarityModel;
import chalk.tools.util.ObjectStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Stack;

public class CorefTrainer {
    private static boolean containsToken(String string, chalk.tools.parser.Parse parse) {
        for (chalk.tools.parser.Parse parse2 : parse.getTagNodes()) {
            if (!parse2.getCoveredText().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static Mention[] getMentions(CorefSample corefSample, MentionFinder mentionFinder) {
        ArrayList<Mention> arrayList = new ArrayList<Mention>();
        for (Parse parse : corefSample.getParses()) {
            chalk.tools.parser.Parse parse2 = ((DefaultParse)parse).getParse();
            Mention[] mentionArray = mentionFinder.getMentions(parse);
            int n = mentionArray.length;
            block1: for (int i = 0; i < n; ++i) {
                if (mentionArray[i].getParse() != null) continue;
                Stack<chalk.tools.parser.Parse> stack = new Stack<chalk.tools.parser.Parse>();
                stack.add(parse2);
                while (!stack.isEmpty()) {
                    chalk.tools.parser.Parse parse3 = (chalk.tools.parser.Parse)stack.pop();
                    if (parse3.getSpan().equals(mentionArray[i].getSpan()) && parse3.getType().startsWith("NML")) {
                        DefaultParse defaultParse = new DefaultParse(parse3, parse.getSentenceNumber());
                        mentionArray[i].setParse(defaultParse);
                        mentionArray[i].setId(defaultParse.getEntityId());
                        continue block1;
                    }
                    stack.addAll(Arrays.asList(parse3.getChildren()));
                }
            }
            arrayList.addAll(Arrays.asList(mentionArray));
        }
        return arrayList.toArray(new Mention[arrayList.size()]);
    }

    public static void train(String string, ObjectStream<CorefSample> objectStream, boolean bl, boolean bl2) throws IOException {
        Mention[] mentionArray;
        Object object;
        TrainSimilarityModel trainSimilarityModel = SimilarityModel.trainModel(string + "/coref/sim");
        TrainSimilarityModel trainSimilarityModel2 = GenderModel.trainModel(string + "/coref/gen");
        TrainSimilarityModel trainSimilarityModel3 = NumberModel.trainModel(string + "/coref/num");
        bl = true;
        DefaultLinker defaultLinker = bl ? new TreebankLinker(string + "/coref/", LinkerMode.SIM) : new DefaultLinker(string + "/coref/", LinkerMode.SIM);
        Object object2 = objectStream.read();
        while (object2 != null) {
            object = CorefTrainer.getMentions((CorefSample)object2, defaultLinker.getMentionFinder());
            mentionArray = defaultLinker.constructMentionContexts((Mention[])object);
            trainSimilarityModel.setExtents((Context[])mentionArray);
            trainSimilarityModel2.setExtents((Context[])mentionArray);
            trainSimilarityModel3.setExtents((Context[])mentionArray);
            object2 = objectStream.read();
        }
        trainSimilarityModel.trainModel();
        trainSimilarityModel2.trainModel();
        trainSimilarityModel3.trainModel();
        MaxentResolver.setSimilarityModel(SimilarityModel.testModel(string + "/coref" + "/sim"));
        objectStream.reset();
        object2 = bl ? new TreebankLinker(string + "/coref/", LinkerMode.TRAIN, bl2) : new DefaultLinker(string + "/coref/", LinkerMode.TRAIN, bl2);
        object = objectStream.read();
        while (object != null) {
            mentionArray = CorefTrainer.getMentions((CorefSample)object, object2.getMentionFinder());
            object2.setEntities(mentionArray);
            object = objectStream.read();
        }
        object2.train();
    }
}

