/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref;

import chalk.tools.coref.AbstractLinker;
import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.LinkerMode;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.mention.PTBHeadFinder;
import chalk.tools.coref.mention.ShallowParseMentionFinder;
import chalk.tools.coref.resolver.AbstractResolver;
import chalk.tools.coref.resolver.CommonNounResolver;
import chalk.tools.coref.resolver.DefiniteNounResolver;
import chalk.tools.coref.resolver.FixedNonReferentialResolver;
import chalk.tools.coref.resolver.IsAResolver;
import chalk.tools.coref.resolver.MaxentResolver;
import chalk.tools.coref.resolver.PerfectResolver;
import chalk.tools.coref.resolver.PluralNounResolver;
import chalk.tools.coref.resolver.PluralPronounResolver;
import chalk.tools.coref.resolver.ProperNounResolver;
import chalk.tools.coref.resolver.ResolverMode;
import chalk.tools.coref.resolver.SingularPronounResolver;
import chalk.tools.coref.resolver.SpeechPronounResolver;
import chalk.tools.coref.sim.Gender;
import chalk.tools.coref.sim.MaxentCompatibilityModel;
import chalk.tools.coref.sim.Number;
import chalk.tools.coref.sim.SimilarityModel;
import java.io.IOException;

public class DefaultLinker
extends AbstractLinker {
    protected MaxentCompatibilityModel mcm;

    public DefaultLinker(String string, LinkerMode linkerMode) throws IOException {
        this(string, linkerMode, true, -1.0);
    }

    public DefaultLinker(String string, LinkerMode linkerMode, boolean bl) throws IOException {
        this(string, linkerMode, bl, -1.0);
    }

    public DefaultLinker(String string, LinkerMode linkerMode, boolean bl, double d) throws IOException {
        super(string, linkerMode, bl);
        if (linkerMode != LinkerMode.SIM) {
            this.mcm = new MaxentCompatibilityModel(this.corefProject);
        }
        this.initHeadFinder();
        this.initMentionFinder();
        if (linkerMode != LinkerMode.SIM) {
            this.initResolvers(linkerMode, d);
            this.entities = new DiscourseEntity[this.resolvers.length];
        }
    }

    protected void initResolvers(LinkerMode linkerMode, double d) throws IOException {
        if (linkerMode == LinkerMode.TRAIN) {
            this.mentionFinder.setPrenominalNamedEntityCollection(false);
            this.mentionFinder.setCoordinatedNounPhraseCollection(false);
        }
        this.SINGULAR_PRONOUN = 0;
        if (LinkerMode.TEST == linkerMode || LinkerMode.EVAL == linkerMode) {
            if (d < 0.0) {
                this.resolvers = new MaxentResolver[]{new SingularPronounResolver(this.corefProject, ResolverMode.TEST), new ProperNounResolver(this.corefProject, ResolverMode.TEST), new DefiniteNounResolver(this.corefProject, ResolverMode.TEST), new IsAResolver(this.corefProject, ResolverMode.TEST), new PluralPronounResolver(this.corefProject, ResolverMode.TEST), new PluralNounResolver(this.corefProject, ResolverMode.TEST), new CommonNounResolver(this.corefProject, ResolverMode.TEST), new SpeechPronounResolver(this.corefProject, ResolverMode.TEST)};
            } else {
                FixedNonReferentialResolver fixedNonReferentialResolver = new FixedNonReferentialResolver(d);
                this.resolvers = new MaxentResolver[]{new SingularPronounResolver(this.corefProject, ResolverMode.TEST, fixedNonReferentialResolver), new ProperNounResolver(this.corefProject, ResolverMode.TEST, fixedNonReferentialResolver), new DefiniteNounResolver(this.corefProject, ResolverMode.TEST, fixedNonReferentialResolver), new IsAResolver(this.corefProject, ResolverMode.TEST, fixedNonReferentialResolver), new PluralPronounResolver(this.corefProject, ResolverMode.TEST, fixedNonReferentialResolver), new PluralNounResolver(this.corefProject, ResolverMode.TEST, fixedNonReferentialResolver), new CommonNounResolver(this.corefProject, ResolverMode.TEST, fixedNonReferentialResolver), new SpeechPronounResolver(this.corefProject, ResolverMode.TEST, fixedNonReferentialResolver)};
            }
            if (LinkerMode.EVAL == linkerMode) {
                // empty if block
            }
            MaxentResolver.setSimilarityModel(SimilarityModel.testModel(this.corefProject + "/sim"));
        } else if (LinkerMode.TRAIN == linkerMode) {
            this.resolvers = new AbstractResolver[9];
            this.resolvers[0] = new SingularPronounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[1] = new ProperNounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[2] = new DefiniteNounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[3] = new IsAResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[4] = new PluralPronounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[5] = new PluralNounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[6] = new CommonNounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[7] = new SpeechPronounResolver(this.corefProject, ResolverMode.TRAIN);
            this.resolvers[8] = new PerfectResolver();
        } else {
            System.err.println("DefaultLinker: Invalid Mode");
        }
    }

    protected void initHeadFinder() {
        this.headFinder = PTBHeadFinder.getInstance();
    }

    protected void initMentionFinder() {
        this.mentionFinder = ShallowParseMentionFinder.getInstance(this.headFinder);
    }

    @Override
    protected Gender computeGender(MentionContext mentionContext) {
        return this.mcm.computeGender(mentionContext);
    }

    @Override
    protected Number computeNumber(MentionContext mentionContext) {
        return this.mcm.computeNumber(mentionContext);
    }
}

