/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref;

import chalk.tools.coref.mention.MentionContext;
import chalk.tools.util.ReverseListIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public abstract class DiscourseElement {
    private List<MentionContext> extents = new ArrayList<MentionContext>(1);
    private int id = -1;
    private MentionContext lastExtent;

    public DiscourseElement(MentionContext mentionContext) {
        this.lastExtent = mentionContext;
        this.extents.add(mentionContext);
    }

    public Iterator<MentionContext> getRecentMentions() {
        return new ReverseListIterator<MentionContext>(this.extents);
    }

    public Iterator<MentionContext> getMentions() {
        return this.extents.listIterator();
    }

    public int getNumMentions() {
        return this.extents.size();
    }

    public void addMention(MentionContext mentionContext) {
        this.extents.add(mentionContext);
        this.lastExtent = mentionContext;
    }

    public MentionContext getLastExtent() {
        return this.lastExtent;
    }

    public void setId(int n) {
        this.id = n;
    }

    public int getId() {
        return this.id;
    }

    public String toString() {
        Iterator<MentionContext> iterator = this.extents.iterator();
        MentionContext mentionContext = iterator.next();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("[ ").append(mentionContext.toText());
        while (iterator.hasNext()) {
            mentionContext = iterator.next();
            stringBuilder.append(", ").append(mentionContext.toText());
        }
        stringBuilder.append(" ]");
        return stringBuilder.toString();
    }
}

