/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.mention.MentionContext;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DiscourseModel {
    private List<DiscourseEntity> entities = new ArrayList<DiscourseEntity>();
    int nextEntityId = 1;

    public void mentionEntity(DiscourseEntity discourseEntity) {
        if (this.entities.remove(discourseEntity)) {
            this.entities.add(0, discourseEntity);
        } else {
            System.err.println("DiscourseModel.mentionEntity: failed to remove " + discourseEntity);
        }
    }

    public int getNumEntities() {
        return this.entities.size();
    }

    public DiscourseEntity getEntity(int n) {
        return this.entities.get(n);
    }

    public void addEntity(DiscourseEntity discourseEntity) {
        discourseEntity.setId(this.nextEntityId);
        ++this.nextEntityId;
        this.entities.add(0, discourseEntity);
    }

    public void mergeEntities(DiscourseEntity discourseEntity, DiscourseEntity discourseEntity2, float f) {
        Iterator<MentionContext> iterator = discourseEntity2.getMentions();
        while (iterator.hasNext()) {
            discourseEntity.addMention(iterator.next());
        }
        this.entities.remove(discourseEntity2);
    }

    public DiscourseEntity[] getEntities() {
        DiscourseEntity[] discourseEntityArray = new DiscourseEntity[this.entities.size()];
        this.entities.toArray(discourseEntityArray);
        return discourseEntityArray;
    }

    public void clear() {
        this.entities.clear();
    }
}

