/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.mention;

import chalk.tools.coref.mention.HeadFinder;
import chalk.tools.coref.mention.Mention;
import chalk.tools.coref.mention.MentionFinder;
import chalk.tools.coref.mention.Parse;
import chalk.tools.coref.resolver.ResolverUtils;
import chalk.tools.util.Span;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class AbstractMentionFinder
implements MentionFinder {
    protected HeadFinder headFinder;
    protected boolean collectPrenominalNamedEntities;
    protected boolean collectCoordinatedNounPhrases;

    private void gatherHeads(Parse parse, Map<Parse, Parse> map) {
        Parse parse2 = this.headFinder.getHead(parse);
        if (parse2 != null) {
            map.put(parse2, parse);
        }
    }

    protected Map<Parse, Parse> constructHeadMap(List<Parse> list) {
        HashMap<Parse, Parse> hashMap = new HashMap<Parse, Parse>();
        for (int i = 0; i < list.size(); ++i) {
            Parse parse = list.get(i);
            this.gatherHeads(parse, hashMap);
        }
        return hashMap;
    }

    @Override
    public boolean isPrenominalNamedEntityCollection() {
        return this.collectPrenominalNamedEntities;
    }

    @Override
    public void setPrenominalNamedEntityCollection(boolean bl) {
        this.collectPrenominalNamedEntities = bl;
    }

    protected boolean isBasalNounPhrase(Parse parse) {
        return parse.getNounPhrases().size() == 0;
    }

    protected boolean isPossessive(Parse parse) {
        Object object;
        Parse parse2;
        Parse parse3;
        List<Parse> list = parse.getSyntacticChildren();
        if (list.size() > 1 && (parse3 = list.get(0)).isNounPhrase() && (parse2 = (object = parse3.getTokens()).get(object.size() - 1)).getSyntacticType().equals("POS")) {
            return true;
        }
        if (list.size() > 2) {
            parse3 = list.get(0);
            object = list.get(1);
            parse2 = list.get(2);
            if (object.isToken() && object.getSyntacticType().equals("POS") && parse3.isNounPhrase() && parse2.isNounPhrase()) {
                return true;
            }
        }
        return false;
    }

    protected boolean isOfPrepPhrase(Parse parse) {
        Parse parse2;
        Parse parse3;
        List<Parse> list;
        Parse parse4;
        List<Parse> list2 = parse.getSyntacticChildren();
        return list2.size() == 2 && (parse4 = list2.get(0)).isNounPhrase() && (list = (parse3 = list2.get(1)).getSyntacticChildren()).size() == 2 && (parse2 = list.get(0)).isToken() && ((Object)parse2).toString().equals("of");
    }

    protected boolean isConjoinedBasal(Parse parse) {
        List<Parse> list = parse.getSyntacticChildren();
        boolean bl = true;
        boolean bl2 = false;
        for (int i = 0; i < list.size(); ++i) {
            Parse parse2 = list.get(i);
            if (parse2.isToken()) {
                if (!parse2.getSyntacticType().equals("CC")) continue;
                bl2 = true;
                continue;
            }
            bl = false;
            break;
        }
        return bl && bl2;
    }

    private void collectCoordinatedNounPhraseMentions(Parse parse, List<Mention> list) {
        List<Parse> list2 = parse.getSyntacticChildren();
        for (Parse parse2 : list2) {
            if (!parse2.getSyntacticType().equals("UCP") && !parse2.getSyntacticType().equals("NX")) continue;
            return;
        }
        List<Parse> list3 = parse.getTokens();
        boolean bl = false;
        int n = this.headFinder.getHeadIndex(parse);
        for (int i = n - 1; i >= 0; --i) {
            Mention mention;
            Span span;
            Parse parse3 = (Parse)list3.get(i);
            String string = ((Object)parse3).toString();
            if ((string.equals("and") || string.equals("or")) && !this.isPartOfName(parse3)) {
                if (n != i) {
                    if (i - 1 < 0 || !((Parse)list3.get(i - 1)).getSyntacticType().startsWith("NN")) break;
                    span = new Span(((Parse)list3.get(i + 1)).getSpan().getStart(), ((Parse)list3.get(n)).getSpan().getEnd());
                    mention = new Mention(span, span, parse3.getEntityId(), null, "CNP");
                    list.add(mention);
                    bl = true;
                }
                n = i - 1;
                continue;
            }
            if (bl && string.equals(",")) {
                if (n != i) {
                    span = new Span(((Parse)list3.get(i + 1)).getSpan().getStart(), ((Parse)list3.get(n)).getSpan().getEnd());
                    mention = new Mention(span, span, parse3.getEntityId(), null, "CNP");
                    list.add(mention);
                }
                n = i - 1;
                continue;
            }
            if (!bl || i != 0 || n < 0) continue;
            span = new Span(((Parse)list3.get(i)).getSpan().getStart(), ((Parse)list3.get(n)).getSpan().getEnd());
            mention = new Mention(span, span, parse3.getEntityId(), null, "CNP");
            list.add(mention);
        }
    }

    private boolean handledPronoun(String string) {
        return ResolverUtils.singularThirdPersonPronounPattern.matcher(string).find() || ResolverUtils.pluralThirdPersonPronounPattern.matcher(string).find() || ResolverUtils.speechPronounPattern.matcher(string).find();
    }

    private void collectPossesivePronouns(Parse parse, List<Mention> list) {
        List<Parse> list2 = parse.getTokens();
        Parse parse2 = this.headFinder.getHeadToken(parse);
        for (int i = list2.size() - 2; i >= 0; --i) {
            Parse parse3 = list2.get(i);
            if (parse3 == parse2 || !parse3.getSyntacticType().startsWith("PRP") || !this.handledPronoun(((Object)parse3).toString())) continue;
            Mention mention = new Mention(parse3.getSpan(), parse3.getSpan(), parse3.getEntityId(), null, "np");
            list.add(mention);
            break;
        }
    }

    private void removeDuplicates(List<Mention> list) {
        Mention mention = null;
        Iterator<Mention> iterator = list.iterator();
        while (iterator.hasNext()) {
            Mention mention2 = iterator.next();
            if (mention != null && mention2.getSpan().equals(mention.getSpan())) {
                iterator.remove();
                continue;
            }
            mention = mention2;
        }
    }

    private boolean isHeadOfExistingMention(Parse parse, Map<Parse, Parse> map, Set<Parse> set) {
        Parse parse2 = map.get(parse);
        while (parse2 != null) {
            if (set.contains(parse2)) {
                return true;
            }
            parse2 = map.get(parse2);
        }
        return false;
    }

    private void clearMentions(Set<Parse> set, Parse parse) {
        Span span = parse.getSpan();
        Iterator<Parse> iterator = set.iterator();
        while (iterator.hasNext()) {
            Parse parse2 = iterator.next();
            if (parse2.getSpan().contains(span)) continue;
            iterator.remove();
        }
    }

    private Mention[] collectMentions(List<Parse> list, Map<Parse, Parse> map) {
        ArrayList<Mention> arrayList = new ArrayList<Mention>(list.size());
        HashSet<Parse> hashSet = new HashSet<Parse>();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Parse parse = list.get(i);
            if (!this.isHeadOfExistingMention(parse, map, hashSet)) {
                this.clearMentions(hashSet, parse);
                if (!this.isPartOfName(parse)) {
                    Parse parse2 = this.headFinder.getLastHead(parse);
                    Mention mention = new Mention(parse.getSpan(), parse2.getSpan(), parse2.getEntityId(), parse, null);
                    arrayList.add(mention);
                    hashSet.add(parse);
                    String string = this.getEntityType(this.headFinder.getHeadToken(parse2));
                    if (string != null) {
                        mention.setNameType(string);
                    }
                }
            }
            if (!this.isBasalNounPhrase(parse)) continue;
            if (this.collectPrenominalNamedEntities) {
                this.collectPrenominalNamedEntities(parse, arrayList);
            }
            if (this.collectCoordinatedNounPhrases) {
                this.collectCoordinatedNounPhraseMentions(parse, arrayList);
            }
            this.collectPossesivePronouns(parse, arrayList);
        }
        Collections.sort(arrayList);
        this.removeDuplicates(arrayList);
        return arrayList.toArray(new Mention[arrayList.size()]);
    }

    private void collectPrenominalNamedEntities(Parse parse, List<Mention> list) {
        Parse parse2 = this.headFinder.getHeadToken(parse);
        List<Parse> list2 = parse.getNamedEntities();
        Span span = parse2.getSpan();
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            Parse parse3 = list2.get(i);
            if (parse3.getSpan().contains(span)) continue;
            Mention mention = new Mention(parse3.getSpan(), parse3.getSpan(), parse3.getEntityId(), null, "NAME");
            mention.setNameType(parse3.getEntityType());
            list.add(mention);
        }
    }

    private String getEntityType(Parse parse) {
        Parse parse2;
        int n;
        String string;
        Object object;
        for (object = parse.getParent(); object != null; object = object.getParent()) {
            string = object.getEntityType();
            if (string != null) {
                return string;
            }
            if (object.isSentence()) break;
        }
        if ((n = (object = parse.getChildren()).size()) > 0 && (string = (parse2 = (Parse)object.get(n - 1)).getEntityType()) != null) {
            return string;
        }
        return null;
    }

    private boolean isPartOfName(Parse parse) {
        for (Parse parse2 = parse.getParent(); parse2 != null; parse2 = parse2.getParent()) {
            String string = parse2.getEntityType();
            if (string != null && !parse.getSpan().contains(parse2.getSpan())) {
                return true;
            }
            if (parse2.isSentence()) break;
        }
        return false;
    }

    public List<Parse> getNamedEntities(Parse parse) {
        return parse.getNamedEntities();
    }

    @Override
    public Mention[] getMentions(Parse parse) {
        List<Parse> list = parse.getNounPhrases();
        Collections.sort(list);
        Map<Parse, Parse> map = this.constructHeadMap(list);
        Mention[] mentionArray = this.collectMentions(list, map);
        return mentionArray;
    }

    @Override
    public boolean isCoordinatedNounPhraseCollection() {
        return this.collectCoordinatedNounPhrases;
    }

    @Override
    public void setCoordinatedNounPhraseCollection(boolean bl) {
        this.collectCoordinatedNounPhrases = bl;
    }
}

