/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.mention;

import chalk.tools.coref.mention.AbstractParse;
import chalk.tools.coref.mention.Parse;
import chalk.tools.util.Span;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class DefaultParse
extends AbstractParse {
    public static String[] NAME_TYPES = new String[]{"person", "organization", "location", "date", "time", "percentage", "money"};
    private chalk.tools.parser.Parse parse;
    private int sentenceNumber;
    private static Set<String> entitySet = new HashSet<String>(Arrays.asList(NAME_TYPES));

    public DefaultParse(chalk.tools.parser.Parse parse, int n) {
        this.parse = parse;
        this.sentenceNumber = n;
    }

    @Override
    public int getSentenceNumber() {
        return this.sentenceNumber;
    }

    @Override
    public List<Parse> getNamedEntities() {
        ArrayList<chalk.tools.parser.Parse> arrayList = new ArrayList<chalk.tools.parser.Parse>();
        LinkedList<chalk.tools.parser.Parse> linkedList = new LinkedList<chalk.tools.parser.Parse>(Arrays.asList(this.parse.getChildren()));
        while (linkedList.size() > 0) {
            chalk.tools.parser.Parse parse = (chalk.tools.parser.Parse)linkedList.remove(0);
            if (entitySet.contains(parse.getType())) {
                arrayList.add(parse);
                continue;
            }
            linkedList.addAll(Arrays.asList(parse.getChildren()));
        }
        return this.createParses(arrayList.toArray(new chalk.tools.parser.Parse[arrayList.size()]));
    }

    @Override
    public List<Parse> getChildren() {
        return this.createParses(this.parse.getChildren());
    }

    @Override
    public List<Parse> getSyntacticChildren() {
        ArrayList<chalk.tools.parser.Parse> arrayList = new ArrayList<chalk.tools.parser.Parse>(Arrays.asList(this.parse.getChildren()));
        for (int i = 0; i < arrayList.size(); ++i) {
            chalk.tools.parser.Parse parse = (chalk.tools.parser.Parse)arrayList.get(i);
            if (!entitySet.contains(parse.getType())) continue;
            arrayList.remove(i);
            arrayList.addAll(i, Arrays.asList(parse.getChildren()));
            --i;
        }
        return this.createParses(arrayList.toArray(new chalk.tools.parser.Parse[arrayList.size()]));
    }

    @Override
    public List<Parse> getTokens() {
        ArrayList<chalk.tools.parser.Parse> arrayList = new ArrayList<chalk.tools.parser.Parse>();
        LinkedList<chalk.tools.parser.Parse> linkedList = new LinkedList<chalk.tools.parser.Parse>(Arrays.asList(this.parse.getChildren()));
        while (linkedList.size() > 0) {
            chalk.tools.parser.Parse parse = (chalk.tools.parser.Parse)linkedList.remove(0);
            if (parse.isPosTag()) {
                arrayList.add(parse);
                continue;
            }
            linkedList.addAll(0, Arrays.asList(parse.getChildren()));
        }
        return this.createParses(arrayList.toArray(new chalk.tools.parser.Parse[arrayList.size()]));
    }

    @Override
    public String getSyntacticType() {
        if (entitySet.contains(this.parse.getType())) {
            return null;
        }
        if (this.parse.getType().contains("#")) {
            return this.parse.getType().substring(0, this.parse.getType().indexOf(35));
        }
        return this.parse.getType();
    }

    private List<Parse> createParses(chalk.tools.parser.Parse[] parseArray) {
        ArrayList<Parse> arrayList = new ArrayList<Parse>(parseArray.length);
        int n = parseArray.length;
        for (int i = 0; i < n; ++i) {
            arrayList.add(new DefaultParse(parseArray[i], this.sentenceNumber));
        }
        return arrayList;
    }

    @Override
    public String getEntityType() {
        if (entitySet.contains(this.parse.getType())) {
            return this.parse.getType();
        }
        return null;
    }

    @Override
    public boolean isParentNAC() {
        for (chalk.tools.parser.Parse parse = this.parse.getParent(); parse != null; parse = parse.getParent()) {
            if (!parse.getType().equals("NAC")) continue;
            return true;
        }
        return false;
    }

    @Override
    public Parse getParent() {
        chalk.tools.parser.Parse parse = this.parse.getParent();
        if (parse == null) {
            return null;
        }
        return new DefaultParse(parse, this.sentenceNumber);
    }

    @Override
    public boolean isNamedEntity() {
        return entitySet.contains(this.parse.getType());
    }

    @Override
    public boolean isNounPhrase() {
        return this.parse.getType().equals("NP") || this.parse.getType().startsWith("NP#");
    }

    @Override
    public boolean isSentence() {
        return this.parse.getType().equals("TOP");
    }

    @Override
    public boolean isToken() {
        return this.parse.isPosTag();
    }

    @Override
    public int getEntityId() {
        String string = this.parse.getType();
        if (string.contains("#")) {
            String string2 = string.substring(string.indexOf(35) + 1);
            return Integer.parseInt(string2);
        }
        return -1;
    }

    @Override
    public Span getSpan() {
        return this.parse.getSpan();
    }

    @Override
    public int compareTo(Parse parse) {
        if (parse == this) {
            return 0;
        }
        if (this.getSentenceNumber() < parse.getSentenceNumber()) {
            return -1;
        }
        if (this.getSentenceNumber() > parse.getSentenceNumber()) {
            return 1;
        }
        if (this.parse.getSpan().getStart() == parse.getSpan().getStart() && this.parse.getSpan().getEnd() == parse.getSpan().getEnd()) {
            System.out.println("Maybe incorrect measurement!");
            Stack stack = new Stack();
        }
        return this.parse.getSpan().compareTo(parse.getSpan());
    }

    @Override
    public String toString() {
        return this.parse.getCoveredText();
    }

    @Override
    public Parse getPreviousToken() {
        chalk.tools.parser.Parse parse = this.parse.getParent();
        chalk.tools.parser.Parse parse2 = this.parse;
        int n = -1;
        while (parse != null && n < 0) {
            n = parse.indexOf(parse2) - 1;
            if (n >= 0) continue;
            parse2 = parse;
            parse = parse.getParent();
        }
        if (n < 0) {
            return null;
        }
        chalk.tools.parser.Parse parse3 = parse.getChildren()[n];
        while (!parse3.isPosTag()) {
            chalk.tools.parser.Parse[] parseArray = parse3.getChildren();
            parse3 = parseArray[parseArray.length - 1];
        }
        return new DefaultParse(parse3, this.sentenceNumber);
    }

    @Override
    public Parse getNextToken() {
        chalk.tools.parser.Parse parse;
        chalk.tools.parser.Parse parse2 = this.parse;
        int n = -1;
        for (parse = this.parse.getParent(); parse != null && (n = parse.indexOf(parse2) + 1) == parse.getChildCount(); parse = parse.getParent()) {
            parse2 = parse;
        }
        if (parse == null) {
            return null;
        }
        chalk.tools.parser.Parse parse3 = parse.getChildren()[n];
        while (!parse3.isPosTag()) {
            parse3 = parse3.getChildren()[0];
        }
        return new DefaultParse(parse3, this.sentenceNumber);
    }

    public boolean equals(Object object) {
        boolean bl = object == this ? true : (object instanceof DefaultParse ? this.parse == ((DefaultParse)object).parse : false);
        return bl;
    }

    public int hashCode() {
        return this.parse.hashCode();
    }

    public chalk.tools.parser.Parse getParse() {
        return this.parse;
    }
}

