/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.mention;

import chalk.tools.coref.mention.Dictionary;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import net.didion.jwnl.JWNLException;
import net.didion.jwnl.data.Adjective;
import net.didion.jwnl.data.FileDictionaryElementFactory;
import net.didion.jwnl.data.IndexWord;
import net.didion.jwnl.data.POS;
import net.didion.jwnl.data.Pointer;
import net.didion.jwnl.data.PointerType;
import net.didion.jwnl.data.Synset;
import net.didion.jwnl.data.VerbFrame;
import net.didion.jwnl.dictionary.FileBackedDictionary;
import net.didion.jwnl.dictionary.MorphologicalProcessor;
import net.didion.jwnl.dictionary.file_manager.FileManager;
import net.didion.jwnl.dictionary.file_manager.FileManagerImpl;
import net.didion.jwnl.dictionary.morph.DefaultMorphologicalProcessor;
import net.didion.jwnl.dictionary.morph.DetachSuffixesOperation;
import net.didion.jwnl.dictionary.morph.LookupExceptionsOperation;
import net.didion.jwnl.dictionary.morph.LookupIndexWordOperation;
import net.didion.jwnl.dictionary.morph.Operation;
import net.didion.jwnl.dictionary.morph.TokenizerOperation;
import net.didion.jwnl.princeton.data.PrincetonWN17FileDictionaryElementFactory;
import net.didion.jwnl.princeton.file.PrincetonRandomAccessDictionaryFile;

public class JWNLDictionary
implements Dictionary {
    private net.didion.jwnl.dictionary.Dictionary dict;
    private MorphologicalProcessor morphy;
    private static String[] empty = new String[0];

    public JWNLDictionary(String string) throws IOException, JWNLException {
        PointerType.initialize();
        Adjective.initialize();
        VerbFrame.initialize();
        HashMap<POS, String[][]> hashMap = new HashMap<POS, String[][]>();
        hashMap.put(POS.NOUN, new String[][]{{"s", ""}, {"ses", "s"}, {"xes", "x"}, {"zes", "z"}, {"ches", "ch"}, {"shes", "sh"}, {"men", "man"}, {"ies", "y"}});
        hashMap.put(POS.VERB, new String[][]{{"s", ""}, {"ies", "y"}, {"es", "e"}, {"es", ""}, {"ed", "e"}, {"ed", ""}, {"ing", "e"}, {"ing", ""}});
        hashMap.put(POS.ADJECTIVE, new String[][]{{"er", ""}, {"est", ""}, {"er", "e"}, {"est", "e"}});
        DetachSuffixesOperation detachSuffixesOperation = new DetachSuffixesOperation(hashMap);
        detachSuffixesOperation.addDelegate("operations", new Operation[]{new LookupIndexWordOperation(), new LookupExceptionsOperation()});
        TokenizerOperation tokenizerOperation = new TokenizerOperation(new String[]{" ", "-"});
        tokenizerOperation.addDelegate("token_operations", new Operation[]{new LookupIndexWordOperation(), new LookupExceptionsOperation(), detachSuffixesOperation});
        DetachSuffixesOperation detachSuffixesOperation2 = new DetachSuffixesOperation(hashMap);
        detachSuffixesOperation2.addDelegate("operations", new Operation[]{new LookupIndexWordOperation(), new LookupExceptionsOperation()});
        Operation[] operationArray = new Operation[]{new LookupExceptionsOperation(), detachSuffixesOperation2, tokenizerOperation};
        this.morphy = new DefaultMorphologicalProcessor(operationArray);
        FileManagerImpl fileManagerImpl = new FileManagerImpl(string, PrincetonRandomAccessDictionaryFile.class);
        PrincetonWN17FileDictionaryElementFactory princetonWN17FileDictionaryElementFactory = new PrincetonWN17FileDictionaryElementFactory();
        FileBackedDictionary.install((FileManager)fileManagerImpl, (MorphologicalProcessor)this.morphy, (FileDictionaryElementFactory)princetonWN17FileDictionaryElementFactory, (boolean)true);
        this.dict = net.didion.jwnl.dictionary.Dictionary.getInstance();
        this.morphy = this.dict.getMorphologicalProcessor();
    }

    @Override
    public String[] getLemmas(String string, String string2) {
        try {
            POS pOS = string2.startsWith("N") || string2.startsWith("n") ? POS.NOUN : (string2.startsWith("V") || string2.startsWith("v") ? POS.VERB : (string2.startsWith("J") || string2.startsWith("a") ? POS.ADJECTIVE : (string2.startsWith("R") || string2.startsWith("r") ? POS.ADVERB : POS.NOUN)));
            List list = this.morphy.lookupAllBaseForms(pOS, string);
            return list.toArray(new String[list.size()]);
        }
        catch (JWNLException jWNLException) {
            jWNLException.printStackTrace();
            return null;
        }
    }

    @Override
    public String getSenseKey(String string, String string2, int n) {
        try {
            IndexWord indexWord = this.dict.getIndexWord(POS.NOUN, string);
            if (indexWord == null) {
                return null;
            }
            return String.valueOf(indexWord.getSynsetOffsets()[n]);
        }
        catch (JWNLException jWNLException) {
            jWNLException.printStackTrace();
            return null;
        }
    }

    @Override
    public int getNumSenses(String string, String string2) {
        try {
            IndexWord indexWord = this.dict.getIndexWord(POS.NOUN, string);
            if (indexWord == null) {
                return 0;
            }
            return indexWord.getSenseCount();
        }
        catch (JWNLException jWNLException) {
            return 0;
        }
    }

    private void getParents(Synset synset, List<String> list) throws JWNLException {
        Pointer[] pointerArray = synset.getPointers();
        int n = pointerArray.length;
        for (int i = 0; i < n; ++i) {
            if (pointerArray[i].getType() != PointerType.HYPERNYM) continue;
            Synset synset2 = pointerArray[i].getTargetSynset();
            list.add(String.valueOf(synset2.getOffset()));
            this.getParents(synset2, list);
        }
    }

    @Override
    public String[] getParentSenseKeys(String string, String string2, int n) {
        try {
            IndexWord indexWord = this.dict.getIndexWord(POS.NOUN, string);
            if (indexWord != null) {
                Synset synset = indexWord.getSense(n + 1);
                ArrayList<String> arrayList = new ArrayList<String>();
                this.getParents(synset, arrayList);
                return arrayList.toArray(new String[arrayList.size()]);
            }
            return empty;
        }
        catch (JWNLException jWNLException) {
            jWNLException.printStackTrace();
            return null;
        }
    }

    public static void main(String[] stringArray) throws IOException, JWNLException {
        String string = System.getProperty("WNSEARCHDIR");
        System.err.println("searchDir=" + string);
        if (string != null) {
            JWNLDictionary jWNLDictionary = new JWNLDictionary(System.getProperty("WNSEARCHDIR"));
            String string2 = stringArray[0];
            String[] stringArray2 = jWNLDictionary.getLemmas(string2, "NN");
            int n = stringArray2.length;
            for (int i = 0; i < n; ++i) {
                int n2 = jWNLDictionary.getNumSenses(stringArray2[i], "NN");
                for (int j = 0; j < n2; ++j) {
                    System.out.println(stringArray2[i] + " (" + j + ")\t" + Arrays.asList(jWNLDictionary.getParentSenseKeys(stringArray2[i], "NN", j)));
                }
            }
        }
    }
}

