/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.mention;

import chalk.tools.coref.mention.HeadFinder;
import chalk.tools.coref.mention.Mention;
import chalk.tools.coref.mention.Parse;
import chalk.tools.coref.sim.Context;
import chalk.tools.coref.sim.GenderEnum;
import chalk.tools.coref.sim.NumberEnum;
import chalk.tools.util.Span;
import java.util.List;

public class MentionContext
extends Context {
    private int nonDescriptorStart;
    private Parse head;
    private Span indexSpan;
    private int nounLocation;
    private int nounNumber;
    private int maxNounLocation;
    private int sentenceNumber;
    private Parse prevToken;
    private Parse nextToken;
    private Parse basalNextToken;
    private Parse headToken;
    private Parse firstToken;
    private String firstTokenText;
    private String firstTokenTag;
    private GenderEnum gender;
    private double genderProb;
    private NumberEnum number;
    private double numberProb;

    public MentionContext(Span span, Span span2, int n, Parse parse, String string, String string2, int n2, int n3, int n4, int n5, HeadFinder headFinder) {
        super(span, span2, n, parse, string, string2, headFinder);
        this.nounLocation = n2;
        this.maxNounLocation = n3;
        this.nounNumber = n4;
        this.sentenceNumber = n5;
        this.indexSpan = parse.getSpan();
        this.prevToken = parse.getPreviousToken();
        this.nextToken = parse.getNextToken();
        this.head = headFinder.getLastHead(parse);
        List<Parse> list = this.head.getTokens();
        this.tokens = list.toArray(new Parse[list.size()]);
        this.basalNextToken = this.head.getNextToken();
        this.nonDescriptorStart = 0;
        this.initHeads(headFinder.getHeadIndex(this.head));
        this.gender = GenderEnum.UNKNOWN;
        this.genderProb = 0.0;
        this.number = NumberEnum.UNKNOWN;
        this.numberProb = 0.0;
    }

    public MentionContext(Mention mention, int n, int n2, int n3, int n4, HeadFinder headFinder) {
        this(mention.getSpan(), mention.getHeadSpan(), mention.getId(), mention.getParse(), mention.type, mention.nameType, n, n2, n3, n4, headFinder);
    }

    private void initHeads(int n) {
        this.headTokenIndex = n;
        this.headToken = (Parse)this.tokens[this.getHeadTokenIndex()];
        this.headTokenText = ((Object)this.headToken).toString();
        this.headTokenTag = this.headToken.getSyntacticType();
        this.firstToken = (Parse)this.tokens[0];
        this.firstTokenTag = this.firstToken.getSyntacticType();
        this.firstTokenText = ((Object)this.firstToken).toString();
    }

    public Parse getHeadTokenParse() {
        return this.headToken;
    }

    public String getHeadText() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.tokens.length; ++i) {
            stringBuilder.append(" ").append(this.tokens[i].toString());
        }
        return stringBuilder.toString().substring(1);
    }

    public Parse getHead() {
        return this.head;
    }

    public int getNonDescriptorStart() {
        return this.nonDescriptorStart;
    }

    public Span getIndexSpan() {
        return this.indexSpan;
    }

    public int getNounPhraseSentenceIndex() {
        return this.nounLocation;
    }

    public int getNounPhraseDocumentIndex() {
        return this.nounNumber;
    }

    public int getMaxNounPhraseSentenceIndex() {
        return this.maxNounLocation;
    }

    public Parse getNextTokenBasal() {
        return this.basalNextToken;
    }

    public Parse getPreviousToken() {
        return this.prevToken;
    }

    public Parse getNextToken() {
        return this.nextToken;
    }

    public int getSentenceNumber() {
        return this.sentenceNumber;
    }

    public Parse getFirstToken() {
        return this.firstToken;
    }

    public String getFirstTokenText() {
        return this.firstTokenText;
    }

    public String getFirstTokenTag() {
        return this.firstTokenTag;
    }

    public Parse[] getTokenParses() {
        return (Parse[])this.tokens;
    }

    public String toText() {
        return ((Object)this.parse).toString();
    }

    public void setGender(GenderEnum genderEnum, double d) {
        this.gender = genderEnum;
        this.genderProb = d;
    }

    public GenderEnum getGender() {
        return this.gender;
    }

    public double getGenderProb() {
        return this.genderProb;
    }

    public void setNumber(NumberEnum numberEnum, double d) {
        this.number = numberEnum;
        this.numberProb = d;
    }

    public NumberEnum getNumber() {
        return this.number;
    }

    public double getNumberProb() {
        return this.numberProb;
    }
}

