/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.mention;

import chalk.tools.coref.mention.HeadFinder;
import chalk.tools.coref.mention.Parse;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public final class PTBHeadFinder
implements HeadFinder {
    private static PTBHeadFinder instance;
    private static Set<String> skipSet;

    private PTBHeadFinder() {
    }

    public static HeadFinder getInstance() {
        if (instance == null) {
            instance = new PTBHeadFinder();
        }
        return instance;
    }

    @Override
    public Parse getHead(Parse parse) {
        if (parse == null) {
            return null;
        }
        if (parse.isNounPhrase()) {
            Parse parse2;
            Object object;
            Parse parse3;
            List<Parse> list = parse.getSyntacticChildren();
            if (list.size() > 2) {
                parse3 = list.get(0);
                object = list.get(1);
                parse2 = list.get(2);
                if (object.isToken() && object.getSyntacticType().equals("POS") && parse3.isNounPhrase() && parse2.isNounPhrase()) {
                    return parse2;
                }
            }
            if (list.size() > 1 && (parse3 = list.get(0)).isNounPhrase()) {
                object = parse3.getTokens();
                if (object.size() == 0) {
                    System.err.println("PTBHeadFinder: NP " + parse3 + " with no tokens");
                }
                if ((parse2 = (Parse)object.get(object.size() - 1)).getSyntacticType().equals("POS")) {
                    return null;
                }
            }
            if (list.size() > 1) {
                for (int i = 1; i < list.size() - 1; ++i) {
                    object = list.get(i);
                    if (!object.isToken() || !object.getSyntacticType().equals("CC")) continue;
                    return null;
                }
            }
            for (int i = 0; i < list.size(); ++i) {
                object = list.get(i);
                if (!object.isNounPhrase()) continue;
                return object;
            }
            return null;
        }
        return null;
    }

    @Override
    public int getHeadIndex(Parse parse) {
        Parse parse2;
        List<Parse> list = parse.getSyntacticChildren();
        boolean bl = false;
        int n = 0;
        int n2 = list.size();
        for (int i = 0; i < n2; ++i) {
            parse2 = list.get(i);
            if (parse2.getSyntacticType().startsWith("S") && i != 0) {
                bl = true;
            }
            if (!bl) continue;
            n += parse2.getTokens().size();
        }
        List<Parse> list2 = parse.getTokens();
        if (list2.size() == 0) {
            System.err.println("PTBHeadFinder.getHeadIndex(): empty tok list for parse " + parse);
        }
        for (n2 = list2.size() - n - 1; n2 >= 0; --n2) {
            parse2 = list2.get(n2);
            if (skipSet.contains(parse2.getSyntacticType())) continue;
            return n2;
        }
        return list2.size() - n - 1;
    }

    @Override
    public Parse getLastHead(Parse parse) {
        Parse parse2;
        while (null != (parse2 = this.getHead(parse))) {
            parse = parse2;
        }
        return parse;
    }

    @Override
    public Parse getHeadToken(Parse parse) {
        List<Parse> list = parse.getTokens();
        return list.get(this.getHeadIndex(parse));
    }

    static {
        skipSet = new HashSet<String>();
        skipSet.add("POS");
        skipSet.add(",");
        skipSet.add(":");
        skipSet.add(".");
        skipSet.add("''");
        skipSet.add("-RRB-");
        skipSet.add("-RCB-");
    }
}

