/*
 * Decompiled with CFR 0.152.
 */
package chalk.tools.coref.resolver;

import chalk.tools.coref.DiscourseEntity;
import chalk.tools.coref.DiscourseModel;
import chalk.tools.coref.mention.MentionContext;
import chalk.tools.coref.mention.Parse;
import chalk.tools.coref.resolver.Resolver;
import chalk.tools.util.CountedSet;
import java.io.IOException;

public abstract class AbstractResolver
implements Resolver {
    protected int numEntitiesBack;
    protected boolean showExclusions;
    protected CountedSet<Integer> distances;
    protected int numSentencesBack;

    public AbstractResolver(int n) {
        this.numEntitiesBack = n;
        this.showExclusions = true;
        this.distances = new CountedSet();
    }

    protected int getNumEntities() {
        return this.numEntitiesBack;
    }

    public void setNumberSentencesBack(int n) {
        this.numSentencesBack = n;
    }

    protected int getNumEntities(DiscourseModel discourseModel) {
        return Math.min(discourseModel.getNumEntities(), this.numEntitiesBack);
    }

    protected Parse getHead(MentionContext mentionContext) {
        return mentionContext.getHeadTokenParse();
    }

    protected int getHeadIndex(MentionContext mentionContext) {
        Parse[] parseArray = mentionContext.getTokenParses();
        for (int i = parseArray.length - 1; i >= 0; --i) {
            Parse parse = parseArray[i];
            if (parse.getSyntacticType().equals("POS") || parse.getSyntacticType().equals(",") || parse.getSyntacticType().equals(".")) continue;
            return i;
        }
        return parseArray.length - 1;
    }

    protected String getHeadString(MentionContext mentionContext) {
        return mentionContext.getHeadTokenText().toLowerCase();
    }

    protected boolean outOfRange(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        return false;
    }

    protected boolean excluded(MentionContext mentionContext, DiscourseEntity discourseEntity) {
        MentionContext mentionContext2 = discourseEntity.getLastExtent();
        return mentionContext.getSentenceNumber() == mentionContext2.getSentenceNumber() && mentionContext.getIndexSpan().getEnd() <= mentionContext2.getIndexSpan().getEnd();
    }

    @Override
    public DiscourseEntity retain(MentionContext mentionContext, DiscourseModel discourseModel) {
        if (mentionContext.getId() == -1) {
            return null;
        }
        for (int i = 0; i < discourseModel.getNumEntities(); ++i) {
            DiscourseEntity discourseEntity = discourseModel.getEntity(i);
            MentionContext mentionContext2 = discourseEntity.getLastExtent();
            if (mentionContext2.getId() != mentionContext.getId()) continue;
            this.distances.add(i);
            return discourseEntity;
        }
        return null;
    }

    protected String featureString(MentionContext mentionContext) {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = mentionContext.getTokens();
        stringBuilder.append(objectArray[0].toString());
        int n = objectArray.length;
        for (int i = 1; i < n; ++i) {
            stringBuilder.append("_").append(objectArray[i].toString());
        }
        return stringBuilder.toString();
    }

    @Override
    public void train() throws IOException {
    }
}

